/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Collection;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class AndExpression
extends BooleanExpression {
    public AndExpression(Expression expression, Expression expression2) {
        super(expression, 10, expression2);
    }

    @Override
    protected Expression preEvaluate() {
        if (Literal.isConstantBoolean(this.getLhsExpression(), false) || Literal.isConstantBoolean(this.getRhsExpression(), false)) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (Literal.hasEffectiveBooleanValue(this.getLhsExpression(), true)) {
            AndExpression andExpression = this;
            return andExpression.forceToBoolean(andExpression.getRhsExpression());
        }
        if (Literal.hasEffectiveBooleanValue(this.getRhsExpression(), true)) {
            AndExpression andExpression = this;
            return andExpression.forceToBoolean(andExpression.getLhsExpression());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != this) {
            return object2;
        }
        object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        if (this.getRhsExpression() instanceof UserFunctionCall && ((TypeHierarchy)object).isSubType(this.getRhsExpression().getItemType(), BuiltInAtomicType.BOOLEAN) && !ExpressionTool.isLoopingSubexpression(this, null)) {
            object = Choose.makeConditional(this.getLhsExpression(), this.getRhsExpression(), Literal.makeLiteral(BooleanValue.FALSE, this));
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        return this;
    }

    @Override
    public double getCost() {
        return this.getLhsExpression().getCost() + this.getRhsExpression().getCost() / 2.0;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new AndExpression(this.getLhsExpression().copy((RebindingMap)object), this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Expression negate() {
        Expression expression = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
        Expression expression2 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
        return new OrExpression(expression, expression2);
    }

    @Override
    protected String tag() {
        return "and";
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.getLhsExpression().effectiveBooleanValue(xPathContext) && this.getRhsExpression().effectiveBooleanValue(xPathContext);
    }

    public static Expression distribute(Collection<Expression> object) {
        Expression expression = null;
        if (object != null) {
            boolean bl2 = true;
            object = object.iterator();
            while (object.hasNext()) {
                Expression expression2 = (Expression)object.next();
                if (bl2) {
                    bl2 = false;
                    expression = expression2;
                    continue;
                }
                expression = new AndExpression(expression, expression2);
            }
        }
        return expression;
    }
}

