/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class ArithmeticExpression
extends BinaryExpression {
    protected Calculator calculator;
    private PlainType a;

    public ArithmeticExpression(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public String getExpressionName() {
        return "arithmetic";
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x4000000;
    }

    public void setCalculator(Calculator calculator) {
        this.calculator = calculator;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo groundedValue) {
        ((Expression)this).resetLocalStaticProperties();
        this.getLhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)((Object)groundedValue));
        this.getRhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)((Object)groundedValue));
        Object object = expressionVisitor.getConfiguration();
        TypeHierarchy typeHierarchy = ((Configuration)object).getTypeHierarchy();
        Object object2 = ((Configuration)object).getTypeChecker(false);
        Expression expression = this.getLhsExpression();
        Expression expression2 = this.getRhsExpression();
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        Object object3 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(((TypeChecker)object2).staticTypeCheck(this.getLhsExpression(), sequenceType, (RoleDiagnostic)object3, expressionVisitor));
        object3 = this.getLhsExpression().getItemType();
        if (object3 instanceof ErrorType) {
            return Literal.makeEmptySequence();
        }
        if ((object3 = (AtomicType)object3.getPrimitiveItemType()).getFingerprint() == 631) {
            this.setLhsExpression(UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object, this.getLhsExpression(), BuiltInAtomicType.DOUBLE));
            object3 = BuiltInAtomicType.DOUBLE;
        } else if ((this.getLhsExpression().getSpecialProperties() & 0x4000000) == 0 && typeHierarchy.relationship((ItemType)object3, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.setLhsExpression(UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object, this.getLhsExpression(), BuiltInAtomicType.DOUBLE));
            object3 = (AtomicType)this.getLhsExpression().getItemType().getPrimitiveItemType();
        }
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(((TypeChecker)object2).staticTypeCheck(this.getRhsExpression(), sequenceType, roleDiagnostic, expressionVisitor));
        object2 = this.getRhsExpression().getItemType();
        if (object2 instanceof ErrorType) {
            return Literal.makeEmptySequence();
        }
        if ((object2 = (AtomicType)object2.getPrimitiveItemType()).getFingerprint() == 631) {
            this.setRhsExpression(UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object, this.getRhsExpression(), BuiltInAtomicType.DOUBLE));
            object2 = BuiltInAtomicType.DOUBLE;
        } else if ((this.getRhsExpression().getSpecialProperties() & 0x4000000) == 0 && typeHierarchy.relationship((ItemType)object2, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.setRhsExpression(UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object, this.getRhsExpression(), BuiltInAtomicType.DOUBLE));
            object2 = (AtomicType)this.getRhsExpression().getItemType().getPrimitiveItemType();
        }
        if (this.getLhsExpression() != expression) {
            ArithmeticExpression arithmeticExpression = this;
            arithmeticExpression.adoptChildExpression(arithmeticExpression.getLhsExpression());
        }
        if (this.getRhsExpression() != expression2) {
            ArithmeticExpression arithmeticExpression = this;
            arithmeticExpression.adoptChildExpression(arithmeticExpression.getRhsExpression());
        }
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeEmptySequence();
        }
        if (object3.isExternalType() || object2.isExternalType()) {
            object = new XPathException("Arithmetic operators are not defined for external objects");
            ((XPathException)object).setLocation(this.getLocation());
            ((XPathException)object).setErrorCode("XPTY0004");
            throw object;
        }
        if (this.operator == 299) {
            if (this.getRhsExpression() instanceof Literal && ((Literal)this.getRhsExpression()).getValue() instanceof NumericValue) {
                object = (NumericValue)((Literal)this.getRhsExpression()).getValue();
                return Literal.makeLiteral(((NumericValue)object).negate(), this);
            }
            object = new NegateExpression(this.getRhsExpression());
            ((NegateExpression)object).setBackwardsCompatible(false);
            return ((Expression)object).typeCheck(expressionVisitor, (ContextItemStaticInfo)((Object)groundedValue));
        }
        boolean bl2 = !object3.equals(BuiltInAtomicType.ANY_ATOMIC) && !object2.equals(BuiltInAtomicType.ANY_ATOMIC) && !object3.equals(NumericType.getInstance()) && !object2.equals(NumericType.getInstance());
        this.calculator = Calculator.getCalculator(object3.getFingerprint(), object2.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), bl2);
        if (this.calculator == null) {
            groundedValue = new XPathException("Arithmetic operator is not defined for arguments of types (" + object3.getDescription() + ", " + object2.getDescription() + ")");
            ((XPathException)((Object)groundedValue)).setLocation(this.getLocation());
            ((XPathException)((Object)groundedValue)).setIsTypeError(true);
            ((XPathException)((Object)groundedValue)).setErrorCode("XPTY0004");
            throw groundedValue;
        }
        if (this.calculator.code().matches("d.d")) {
            if (this.getLhsExpression() instanceof Literal && !object3.equals(BuiltInAtomicType.DOUBLE) && (groundedValue = ((Literal)this.getLhsExpression()).getValue()) instanceof NumericValue) {
                this.setLhsExpression(Literal.makeLiteral(new DoubleValue(((NumericValue)groundedValue).getDoubleValue()), this));
            }
            if (this.getRhsExpression() instanceof Literal && !object2.equals(BuiltInAtomicType.DOUBLE) && (groundedValue = ((Literal)this.getRhsExpression()).getValue()) instanceof NumericValue) {
                this.setRhsExpression(Literal.makeLiteral(new DoubleValue(((NumericValue)groundedValue).getDoubleValue()), this));
            }
        }
        try {
            if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
                return Literal.makeLiteral(this.evaluateItem(expressionVisitor.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        IntegerValue[] integerValueArray = this.getLhsExpression().getIntegerBounds();
        IntegerValue[] integerValueArray2 = this.getRhsExpression().getIntegerBounds();
        if (integerValueArray == null || integerValueArray2 == null) {
            return null;
        }
        switch (this.operator) {
            case 15: {
                return new IntegerValue[]{integerValueArray[0].plus(integerValueArray2[0]), integerValueArray[1].plus(integerValueArray2[1])};
            }
            case 16: {
                return new IntegerValue[]{integerValueArray[0].minus(integerValueArray2[1]), integerValueArray[1].minus(integerValueArray2[0])};
            }
            case 17: {
                if (this.getRhsExpression() instanceof Literal) {
                    IntegerValue integerValue = integerValueArray2[0];
                    if (integerValue.signum() > 0) {
                        return new IntegerValue[]{integerValueArray[0].times(integerValue), integerValueArray[1].times(integerValue)};
                    }
                    return null;
                }
                if (this.getLhsExpression() instanceof Literal) {
                    IntegerValue integerValue = integerValueArray2[0];
                    if (integerValue.signum() > 0) {
                        return new IntegerValue[]{integerValueArray2[0].times(integerValue), integerValueArray2[1].times(integerValue)};
                    }
                    return null;
                }
            }
            case 18: 
            case 56: {
                IntegerValue integerValue;
                if (this.getRhsExpression() instanceof Literal && (integerValue = integerValueArray2[0]).signum() > 0) {
                    try {
                        return new IntegerValue[]{integerValueArray[0].idiv(integerValue), integerValueArray[1].idiv(integerValue)};
                    }
                    catch (XPathException xPathException) {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ArithmeticExpression(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((ArithmeticExpression)object).calculator = this.calculator;
        return object;
    }

    public static AtomicValue compute(AtomicValue atomicValue, int n2, AtomicValue atomicValue2, XPathContext xPathContext) {
        int n3 = atomicValue.getPrimitiveType().getFingerprint();
        int n4 = atomicValue2.getPrimitiveType().getFingerprint();
        Calculator calculator = Calculator.getCalculator(n3, n4, n2, false);
        return calculator.compute(atomicValue, atomicValue2, xPathContext);
    }

    public static int mapOpCode(int n2) {
        switch (n2) {
            case 15: {
                return 0;
            }
            case 16: 
            case 299: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 3;
            }
            case 56: {
                return 5;
            }
            case 19: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public PlainType getItemType() {
        SimpleType simpleType;
        ItemType itemType;
        if (this.a != null) {
            return this.a;
        }
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType itemType2 = this.getLhsExpression().getItemType();
        if (!(itemType2 instanceof AtomicType)) {
            itemType2 = itemType2.getAtomizedItemType();
        }
        if (!((itemType = this.getRhsExpression().getItemType()) instanceof AtomicType)) {
            itemType = itemType.getAtomizedItemType();
        }
        if ((simpleType = this.calculator.getResultType((AtomicType)itemType2.getPrimitiveItemType(), (AtomicType)itemType.getPrimitiveItemType())).equals(BuiltInAtomicType.ANY_ATOMIC)) {
            TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
            if ((this.operator == 15 || this.operator == 16) && (typeHierarchy.isSubType(itemType, NumericType.getInstance()) || typeHierarchy.isSubType(itemType2, NumericType.getInstance()))) {
                simpleType = NumericType.getInstance();
            }
        }
        this.a = simpleType;
        return this.a;
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (this.getParentExpression() instanceof FilterExpression && ((FilterExpression)this.getParentExpression()).getRhsExpression() == this) {
            return UType.NUMERIC;
        }
        if (this.operator == 299) {
            return UType.NUMERIC;
        }
        return UType.ANY_ATOMIC;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.a = null;
    }

    public AtomicValue evaluateItem(XPathContext xPathContext) {
        Object object = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
        if (object == null) {
            return null;
        }
        AtomicValue atomicValue = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        try {
            return this.calculator.compute((AtomicValue)object, atomicValue, xPathContext);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object).maybeSetFailingExpression(this);
            ((XPathException)object).maybeSetContext(xPathContext);
            throw object;
        }
    }

    @Override
    protected String tag() {
        return "arith";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
        if (this.calculator != null) {
            expressionPresenter.emitAttribute("calc", this.calculator.code());
        }
    }
}

