/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class Assignation
extends Expression
implements LocalBinding {
    private Operand a = new Operand(this, null, OperandRole.NAVIGATE);
    private Operand b = new Operand(this, null, this instanceof LetExpression ? OperandRole.SAME_FOCUS_ACTION : c);
    protected int slotNumber = -999;
    protected StructuredQName variableName;
    protected SequenceType requiredType;
    protected boolean isIndexedVariable = false;
    protected boolean hasLoopingReference = false;
    protected List<VariableReference> references = null;
    private static final OperandRole c = new OperandRole(4, OperandUsage.TRANSMISSION);

    public Operand getSequenceOp() {
        return this.a;
    }

    public Operand getActionOp() {
        return this.b;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.a, this.b);
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableQName(StructuredQName structuredQName) {
        this.variableName = structuredQName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.variableName;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return this.getSequence().getIntegerBounds();
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public int computeDependencies() {
        int n2 = super.computeDependencies();
        if (!ExpressionTool.containsLocalVariableReference(this)) {
            n2 &= 0xFFFFFF7F;
        }
        return n2;
    }

    @Override
    public Sequence<?> evaluateVariable(XPathContext xPathContext) {
        Sequence<?> sequence = xPathContext.evaluateLocalVariable(this.slotNumber);
        if (!(sequence instanceof GroundedValue) && !(sequence instanceof NodeInfo)) {
            sequence = sequence.materialize();
            xPathContext.setLocalVariable(this.slotNumber, sequence);
        }
        return sequence;
    }

    public void setAction(Expression expression) {
        this.b.setChildExpression(expression);
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        this.getSequence().checkForUpdatingSubexpressions();
        if (this.getSequence().isUpdatingExpression()) {
            XPathException xPathException = new XPathException("An updating expression cannot be used to initialize a variable", "XUST0001");
            xPathException.setLocator(this.getSequence().getLocation());
            throw xPathException;
        }
        this.getAction().checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getAction().isUpdatingExpression();
    }

    public Expression getAction() {
        return this.b.getChildExpression();
    }

    public void setSequence(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Expression getSequence() {
        return this.a.getChildExpression();
    }

    public void setSlotNumber(int n2) {
        this.slotNumber = n2;
    }

    public int getRequiredSlots() {
        return 1;
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        Assignation assignation = this;
        assignation.setAction(assignation.getAction().unordered(bl2, bl3));
        return this;
    }

    @Override
    public double getCost() {
        return this.getSequence().getCost() + 5.0 * this.getAction().getCost();
    }

    @Override
    public void suppressValidation(int n2) {
        this.getAction().suppressValidation(n2);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this, pathMapNodeSet2);
        return this.getAction().addToPathMap(pathMap, pathMapNodeSet);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.computeHashCode();
        }
        return this.variableName.getDisplayName();
    }

    public String getVariableEQName() {
        if (this.variableName == null) {
            return "Q{http://ns.saxonica.com/anonymous-var}var" + this.computeHashCode();
        }
        if (this.variableName.hasURI("")) {
            return this.variableName.getLocalPart();
        }
        return this.variableName.getEQName();
    }

    public void refineTypeInformation(ItemType itemType, int n2, GroundedValue<?> groundedValue, int n3, Assignation assignation) {
        ExpressionTool.processExpressionTree(assignation.getAction(), null, (expression, object) -> {
            if (expression instanceof VariableReference && ((VariableReference)expression).getBinding() == assignation) {
                ((VariableReference)expression).refineVariableType(itemType, n2, groundedValue, n3);
            }
            return false;
        });
    }

    @Override
    public void addReference(VariableReference variableReference, boolean bl2) {
        this.hasLoopingReference |= bl2;
        if (this.references == null) {
            this.references = new ArrayList<VariableReference>();
        }
        for (VariableReference variableReference2 : this.references) {
            if (variableReference2 != variableReference) continue;
            return;
        }
        this.references.add(variableReference);
    }

    public int getNominalReferenceCount() {
        if (this.isIndexedVariable) {
            return 10000;
        }
        if (this.references == null || this.hasLoopingReference) {
            return 10;
        }
        return this.references.size();
    }

    protected boolean removeDeadReferences() {
        boolean bl2 = false;
        if (this.references != null) {
            for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
                boolean bl3 = false;
                bl2 |= this.references.get(i2).isInLoop();
                for (Expression expression = this.references.get(i2).getParentExpression(); expression != null; expression = expression.getParentExpression()) {
                    if (expression != this) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                this.references.remove(i2);
            }
        }
        return bl2;
    }

    protected void verifyReferences() {
        this.rebuildReferenceList(false);
    }

    public void rebuildReferenceList(boolean bl2) {
        int[] nArray = new int[]{0, bl2 ? Integer.MAX_VALUE : 500};
        ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
        Assignation assignation = this;
        Assignation.a(assignation, assignation.getAction(), arrayList, nArray);
        this.references = nArray[1] <= 0 ? null : arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Binding binding, Expression object2, List<VariableReference> list, int[] nArray) {
        void var2_4;
        void var3_5;
        if (object2 instanceof LocalVariableReference) {
            LocalVariableReference localVariableReference = (LocalVariableReference)object2;
            if (localVariableReference.getBinding() == binding) {
                localVariableReference.recomputeInLoop();
                void v0 = var3_5;
                v0[0] = v0[0] + (localVariableReference.isInLoop() ? 10 : 1);
                var2_4.add((LocalVariableReference)object2);
            }
            return;
        }
        if ((((Expression)object2).getDependencies() & 0x80) != 0) {
            void v1 = var3_5;
            v1[1] = v1[1] - true;
            if (v1[1] <= 0) {
                var3_5[0] = 100;
                var3_5[1] = false;
                return;
            }
            for (Operand operand : ((Expression)object2).operands()) {
                Assignation.a(binding, operand.getChildExpression(), (List<VariableReference>)var2_4, (int[])var3_5);
            }
        }
    }

    @Override
    public boolean isIndexedVariable() {
        return this.isIndexedVariable;
    }

    public boolean replaceVariable(Expression object) {
        boolean bl2 = ExpressionTool.inlineVariableReferences(this.getAction(), this, (Expression)object);
        if (bl2 && this.isIndexedVariable() && object instanceof VariableReference && (object = ((VariableReference)object).getBinding()) instanceof Assignation) {
            ((Assignation)object).setIndexedVariable();
        }
        return bl2;
    }

    @Override
    public void setIndexedVariable() {
        this.isIndexedVariable = true;
    }
}

