/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class AtomicSequenceConverter
extends UnaryExpression {
    public static ToStringMappingFunction TO_STRING_MAPPER = new ToStringMappingFunction();
    private PlainType a;
    protected Converter converter;
    private RoleDiagnostic b;

    public AtomicSequenceConverter(Expression expression, PlainType plainType) {
        super(expression);
        this.a = plainType;
    }

    public void allocateConverterStatically(Configuration configuration, boolean bl2) {
        this.converter = this.allocateConverter(configuration, bl2, this.getBaseExpression().getItemType());
    }

    public Converter allocateConverter(Configuration configuration, boolean bl2) {
        return this.allocateConverter(configuration, bl2, this.getBaseExpression().getItemType());
    }

    protected Converter getConverterDynamically(XPathContext xPathContext) {
        if (this.converter != null) {
            return this.converter;
        }
        return this.allocateConverter(xPathContext.getConfiguration(), false);
    }

    public Converter allocateConverter(Configuration object, boolean bl2, ItemType itemType) {
        object = ((Configuration)object).getConversionRules();
        Converter converter = null;
        if (itemType instanceof ErrorType) {
            converter = Converter.IdentityConverter.INSTANCE;
        } else if (!(itemType instanceof AtomicType)) {
            converter = null;
        } else if (this.a instanceof AtomicType) {
            converter = ((ConversionRules)object).getConverter((AtomicType)itemType, (AtomicType)this.a);
        } else if (((SimpleType)((Object)this.a)).isUnionType()) {
            converter = new StringConverter.StringToUnionConverter(this.a, (ConversionRules)object);
        }
        if (converter == null && !bl2) {
            Object object2 = object;
            converter = new Converter(this, (ConversionRules)object2, (ConversionRules)object2){
                private /* synthetic */ ConversionRules a;
                private /* synthetic */ AtomicSequenceConverter b;
                {
                    this.b = atomicSequenceConverter;
                    this.a = conversionRules2;
                    super(conversionRules);
                }

                @Override
                public final ConversionResult convert(AtomicValue atomicValue) {
                    Converter converter = this.a.getConverter(atomicValue.getPrimitiveType(), (AtomicType)this.b.a);
                    if (converter == null) {
                        return new ValidationFailure("Cannot convert value from " + atomicValue.getPrimitiveType() + " to " + this.b.a);
                    }
                    return converter.convert(atomicValue);
                }
            };
        }
        return converter;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.ATOMIC_SEQUENCE;
    }

    public PlainType getRequiredItemType() {
        return this.a;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setRoleDiagnostic(RoleDiagnostic roleDiagnostic) {
        if (roleDiagnostic != null && !"XPTY0004".equals(roleDiagnostic.getErrorCode())) {
            this.b = roleDiagnostic;
        }
    }

    public RoleDiagnostic getRoleDiagnostic() {
        return this.b;
    }

    @Override
    public Expression simplify() {
        Expression expression = this.getBaseExpression().simplify();
        this.setBaseExpression(expression);
        if (expression instanceof Literal && this.a instanceof AtomicType) {
            if (Literal.isEmptySequence(expression)) {
                return expression;
            }
            Object object = this.getConfiguration();
            this.allocateConverterStatically((Configuration)object, true);
            if (this.converter != null) {
                object = ((Expression)this).iterate(new EarlyEvaluationContext((Configuration)object)).materialize();
                return Literal.makeLiteral(object, expression);
            }
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.typeCheckChildren((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object = ((ExpressionVisitor)object).getConfiguration();
        object2 = ((Configuration)object).getTypeHierarchy();
        Expression expression = this.getBaseExpression();
        if (((TypeHierarchy)object2).isSubType(expression.getItemType(), this.a)) {
            return expression;
        }
        if (this.converter == null) {
            this.allocateConverterStatically((Configuration)object, true);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object = super.optimize(expressionVisitor, contextItemStaticInfo);
        if (object != this) {
            return object;
        }
        if (this.getBaseExpression() instanceof UntypedSequenceConverter) {
            object = (UntypedSequenceConverter)this.getBaseExpression();
            if ((object = ((Expression)object).getItemType()) == this.a) {
                return this.getBaseExpression();
            }
            if (!(this.a != BuiltInAtomicType.STRING && this.a != BuiltInAtomicType.UNTYPED_ATOMIC || object != BuiltInAtomicType.STRING && object != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                object = (UntypedSequenceConverter)this.getBaseExpression();
                object = new UntypedSequenceConverter(((UnaryExpression)object).getBaseExpression(), this.a);
                return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
            }
        } else if (this.getBaseExpression() instanceof AtomicSequenceConverter) {
            object = (AtomicSequenceConverter)this.getBaseExpression();
            if ((object = ((Expression)object).getItemType()) == this.a) {
                return this.getBaseExpression();
            }
            if (!(this.a != BuiltInAtomicType.STRING && this.a != BuiltInAtomicType.UNTYPED_ATOMIC || object != BuiltInAtomicType.STRING && object != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                object = (AtomicSequenceConverter)this.getBaseExpression();
                object = new AtomicSequenceConverter(((UnaryExpression)object).getBaseExpression(), this.a);
                return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
            }
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties() | 0x800000;
        n2 = this.a == BuiltInAtomicType.UNTYPED_ATOMIC ? (n2 &= 0xFBFFFFFF) : (n2 |= 0x4000000);
        return n2;
    }

    @Override
    public String getStreamerName() {
        return "AtomicSequenceConverter";
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new AtomicSequenceConverter(this.getBaseExpression().copy((RebindingMap)object), this.a);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((AtomicSequenceConverter)object).setConverter(this.converter);
        ((AtomicSequenceConverter)object).setRoleDiagnostic(this.getRoleDiagnostic());
        return object;
    }

    public SequenceIterator<? extends AtomicValue> iterate(XPathContext object) {
        SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate((XPathContext)object);
        if ((object = this.getConverterDynamically((XPathContext)object)) == Converter.ToStringConverter.INSTANCE) {
            return new ItemMappingIterator(sequenceIterator, TO_STRING_MAPPER, true);
        }
        AtomicSequenceMappingFunction atomicSequenceMappingFunction = new AtomicSequenceMappingFunction();
        atomicSequenceMappingFunction.setConverter((Converter)object);
        if (this.b != null) {
            atomicSequenceMappingFunction.setErrorCode(this.b.getErrorCode());
        }
        return new ItemMappingIterator<AtomicValue, AtomicValue>(sequenceIterator, atomicSequenceMappingFunction, true);
    }

    public AtomicValue evaluateItem(XPathContext object) {
        Converter converter = this.getConverterDynamically((XPathContext)object);
        object = (AtomicValue)this.getBaseExpression().evaluateItem((XPathContext)object);
        if (object == null) {
            return null;
        }
        object = converter.convert((AtomicValue)object);
        if (this.b != null && object instanceof ValidationFailure) {
            ((ValidationFailure)object).setErrorCode(this.b.getErrorCode());
        }
        return object.asAtomic();
    }

    @Override
    public ItemType getItemType() {
        return this.a;
    }

    @Override
    public int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.a.equals(((AtomicSequenceConverter)object).a);
    }

    @Override
    public int computeHashCode() {
        return super.computeHashCode() ^ this.a.hashCode();
    }

    @Override
    public String getExpressionName() {
        return "convert";
    }

    @Override
    protected String displayOperator(Configuration configuration) {
        return "convert";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("convert", this);
        expressionPresenter.emitAttribute("from", this.getBaseExpression().getItemType().toExportString());
        expressionPresenter.emitAttribute("to", this.a.toExportString());
        if (this.converter instanceof Converter.PromoterToDouble || this.converter instanceof Converter.PromoterToFloat) {
            expressionPresenter.emitAttribute("flags", "p");
        }
        if (this.getRoleDiagnostic() != null) {
            expressionPresenter.emitAttribute("diag", this.getRoleDiagnostic().save());
        }
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public static class ToStringMappingFunction
    implements ItemMappingFunction<Item<?>, StringValue> {
        @Override
        public StringValue mapItem(Item<?> item) {
            return StringValue.makeStringValue(item.getStringValueCS());
        }
    }

    public static class AtomicSequenceMappingFunction
    implements ItemMappingFunction<AtomicValue, AtomicValue> {
        private Converter a;
        private String b;

        public void setConverter(Converter converter) {
            this.a = converter;
        }

        public void setErrorCode(String string) {
            this.b = string;
        }

        @Override
        public AtomicValue mapItem(AtomicValue conversionResult) {
            conversionResult = this.a.convert((AtomicValue)conversionResult);
            if (this.b != null && conversionResult instanceof ValidationFailure) {
                ((ValidationFailure)conversionResult).setErrorCode(this.b);
            }
            return conversionResult.asAtomic();
        }
    }
}

