/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AttributeGetter;
import net.sf.saxon.expr.AxisAtomizingIterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AtomizedValueIterator;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomizingIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.UntypedAtomizingIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;

public final class Atomizer
extends UnaryExpression {
    private boolean a = false;
    private boolean b = false;
    private ItemType c = null;
    private RoleDiagnostic d = null;
    public static final UType STRING_KINDS = UType.NAMESPACE.union(UType.COMMENT).union(UType.PI);
    public static final UType UNTYPED_KINDS = UType.TEXT.union(UType.DOCUMENT);
    public static final UType UNTYPED_IF_UNTYPED_KINDS = UType.TEXT.union(UType.ELEMENT).union(UType.DOCUMENT).union(UType.ATTRIBUTE);

    public Atomizer(Expression expression, RoleDiagnostic roleDiagnostic) {
        super(expression);
        this.d = roleDiagnostic;
        expression.setFlattened(true);
    }

    public static Expression makeAtomizer(Expression expression, RoleDiagnostic roleDiagnostic) {
        if (expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicSequence) {
            return expression;
        }
        return new Atomizer(expression, roleDiagnostic);
    }

    @Override
    protected final OperandRole getOperandRole() {
        return OperandRole.ATOMIC_SEQUENCE;
    }

    @Override
    public final int getImplementationMethod() {
        return 10;
    }

    public final ItemType getOperandItemType() {
        if (this.c == null) {
            this.c = this.getBaseExpression().getItemType();
        }
        return this.c;
    }

    @Override
    public final Expression simplify() {
        this.a = !this.getPackageData().isSchemaAware();
        Atomizer atomizer = this;
        atomizer.a(atomizer.getConfiguration().getTypeHierarchy());
        Object object = this.getBaseExpression().simplify();
        if (object instanceof Literal) {
            Object t2;
            GroundedValue<?> groundedValue = ((Literal)object).getValue();
            if (groundedValue instanceof AtomicValue) {
                return object;
            }
            groundedValue = groundedValue.iterate();
            while ((t2 = groundedValue.next()) != null) {
                if (t2 instanceof NodeInfo) {
                    return this;
                }
                if (!(t2 instanceof Function)) continue;
                if (((Function)t2).isArray()) {
                    return this;
                }
                if (((Function)t2).isMap()) {
                    object = new XPathException(this.a("Cannot atomize a map (" + t2.toShortString() + ")"), "FOTY0013");
                    ((XPathException)object).setIsTypeError(true);
                    ((XPathException)object).setLocation(this.getLocation());
                    throw object;
                }
                object = new XPathException(this.a("Cannot atomize a function item"), "FOTY0013");
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
            return object;
        }
        if (object instanceof ValueOf && (((ValueOf)object).getOptions() & 1) == 0) {
            return ((ValueOf)object).convertToCastAsString();
        }
        this.setBaseExpression((Expression)object);
        return this;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        this.a |= !((ExpressionVisitor)object).getStaticContext().getPackageData().isSchemaAware();
        object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        this.a((TypeHierarchy)object);
        ((Expression)this).resetLocalStaticProperties();
        object2 = this.getOperandItemType();
        if (((TypeHierarchy)object).isSubType((ItemType)object2, BuiltInAtomicType.ANY_ATOMIC)) {
            return this.getBaseExpression();
        }
        if (!object2.isAtomizable((TypeHierarchy)object)) {
            if (object2 instanceof FunctionItemType) {
                object = object2 instanceof MapType ? "map" : "function item";
                object = new XPathException(this.a("Cannot atomize a " + (String)object), "FOTY0013");
            } else {
                object = new XPathException(this.a("Cannot atomize an element that is defined in the schema to have element-only content"), "FOTY0012");
            }
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        this.getBaseExpression().setFlattened(true);
        return this;
    }

    private void a(TypeHierarchy object) {
        Object object2 = this.getOperandItemType();
        if (((TypeHierarchy)object).relationship((ItemType)object2, ArrayItemType.ANY_ARRAY_TYPE) != 4) {
            this.b = false;
            return;
        }
        this.b = this.a;
        if (!this.b && (object = this.getBaseExpression().getItemType()) instanceof NodeTest) {
            object2 = ((NodeTest)object).getContentType();
            if (object2 == Untyped.getInstance() || object2.isAtomicType() || object2.isComplexType() && object2 != AnyType.getInstance()) {
                this.b = true;
            }
            if (!object.getUType().overlaps(UType.ELEMENT.union(UType.ATTRIBUTE))) {
                this.b = true;
            }
        }
    }

    private String a(String string) {
        if (this.d == null) {
            return string;
        }
        return string + ". Found while atomizing the " + this.d.getMessage();
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object = super.optimize(expressionVisitor, contextItemStaticInfo);
        if (object == this) {
            Expression expression;
            Object object2 = expressionVisitor.getConfiguration().getTypeHierarchy();
            if (object2.isSubType((expression = this.getBaseExpression()).getItemType(), BuiltInAtomicType.ANY_ATOMIC)) {
                return expression;
            }
            if (expression instanceof ValueOf && (((ValueOf)expression).getOptions() & 1) == 0) {
                object = ((ValueOf)expression).convertToCastAsString();
                return object.optimize(expressionVisitor, contextItemStaticInfo);
            }
            if (expression instanceof LetExpression || expression instanceof ForExpression) {
                object = ((Assignation)expression).getAction();
                ((Assignation)expression).setAction(new Atomizer((Expression)object, this.d));
                return expression.optimize(expressionVisitor, contextItemStaticInfo);
            }
            if (expression instanceof Choose) {
                ((Choose)expression).atomizeActions();
                return expression.optimize(expressionVisitor, contextItemStaticInfo);
            }
            if (expression instanceof Block) {
                object = ((Block)expression).getOperanda();
                object2 = new Expression[((Operand[])object).length];
                for (int i2 = 0; i2 < ((Operand[])object).length; ++i2) {
                    object2[i2] = new Atomizer(object[i2].getChildExpression(), this.d);
                }
                Block block = new Block((Expression[])object2);
                return ((Expression)block).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
            }
            if (this.a && expression instanceof AxisExpression && ((AxisExpression)expression).getAxis() == 2 && ((AxisExpression)expression).getNodeTest() instanceof NameTest && !((AxisExpression)expression).isContextPossiblyUndefined()) {
                object = ((AxisExpression)expression).getNodeTest().getMatchingNodeName();
                object2 = new FingerprintedQName((StructuredQName)object, expressionVisitor.getConfiguration().getNamePool());
                AttributeGetter attributeGetter = new AttributeGetter((FingerprintedQName)object2);
                int n2 = 0;
                if (!(((AxisExpression)expression).getContextItemType() instanceof NodeTest)) {
                    n2 = 2;
                }
                attributeGetter.setRequiredChecks(n2);
                ExpressionTool.copyLocationInfo(this, attributeGetter);
                return attributeGetter;
            }
        }
        return object;
    }

    public final boolean isUntyped() {
        return this.a;
    }

    @Override
    public final int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return (n2 &= 0xF6C0FFFF) | 0x800000;
    }

    @Override
    public final void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.c = null;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new Atomizer(this.getBaseExpression().copy((RebindingMap)object), this.d);
        v0.a = this.a;
        ((Atomizer)object).b = this.b;
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final String getStreamerName() {
        return "Atomizer";
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        try {
            SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate(xPathContext);
            return Atomizer.getAtomizingIterator(sequenceIterator, this.a && this.c instanceof NodeTest);
        }
        catch (XPathException xPathException) {
            if (this.d == null || xPathException instanceof TerminationException || xPathException.getErrorCodeQName() == null || !xPathException.getErrorCodeQName().hasURI("http://www.w3.org/2005/xqt-errors")) {
                throw xPathException;
            }
            String string = this.a(xPathException.getMessage());
            XPathException xPathException2 = new XPathException(string, xPathException.getErrorCodeLocalPart(), xPathException.getLocator());
            xPathException2.setXPathContext(xPathContext);
            xPathException2.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    public final AtomicValue evaluateItem(XPathContext item) {
        item = this.getBaseExpression().evaluateItem((XPathContext)((Object)item));
        if (item == null) {
            return null;
        }
        return item.atomize().head();
    }

    @Override
    public final ItemType getItemType() {
        this.c = this.getBaseExpression().getItemType();
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        return Atomizer.getAtomizedItemType(this.getBaseExpression(), this.a, typeHierarchy);
    }

    public static ItemType getAtomizedItemType(Expression object, boolean bl2, TypeHierarchy object2) {
        if ((object = ((Expression)object).getItemType()).isPlainType()) {
            return object;
        }
        if (object instanceof NodeTest) {
            object2 = object.getUType();
            if (bl2) {
                if (STRING_KINDS.subsumes((UType)object2)) {
                    return BuiltInAtomicType.STRING;
                }
                if (UNTYPED_IF_UNTYPED_KINDS.subsumes((UType)object2)) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if (UNTYPED_KINDS.subsumes((UType)object2)) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return object.getAtomizedItemType();
        }
        if (object instanceof JavaExternalObjectType) {
            return object.getAtomizedItemType();
        }
        if (object instanceof ArrayItemType) {
            object2 = ((ArrayItemType)object).getMemberType().getPrimaryType().getAtomizedItemType();
            if (object2 == null) {
                return ErrorType.getInstance();
            }
            return object2;
        }
        if (object instanceof FunctionItemType) {
            return ErrorType.getInstance();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public final int computeCardinality() {
        Object object = this.getOperandItemType();
        Expression expression = this.getBaseExpression();
        if (this.b) {
            return expression.getCardinality();
        }
        if (this.a && object instanceof NodeTest) {
            return expression.getCardinality();
        }
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return 57344;
        }
        if (object.isPlainType()) {
            return expression.getCardinality();
        }
        if (object instanceof NodeTest && (object = ((NodeTest)object).getContentType()).isAtomicType()) {
            return expression.getCardinality();
        }
        return 57344;
    }

    @Override
    public final PathMap.PathMapNodeSet addToPathMap(PathMap object, PathMap.PathMapNodeSet object2) {
        ItemType itemType;
        object = this.getBaseExpression().addToPathMap((PathMap)object, (PathMap.PathMapNodeSet)object2);
        if (object != null && (((TypeHierarchy)(object2 = this.getConfiguration().getTypeHierarchy())).relationship(NodeKindTest.ELEMENT, itemType = this.getBaseExpression().getItemType()) != 4 || ((TypeHierarchy)object2).relationship(NodeKindTest.DOCUMENT, itemType) != 4)) {
            ((PathMap.PathMapNodeSet)object).setAtomized();
        }
        return null;
    }

    public static SequenceIterator<? extends AtomicValue> getAtomizingIterator(SequenceIterator sequenceIterator, boolean bl2) {
        int n2 = sequenceIterator.getProperties();
        if ((n2 & 2) != 0) {
            n2 = ((LastPositionFinder)((Object)sequenceIterator)).getLength();
            if (n2 == 0) {
                return EmptyIterator.emptyIterator();
            }
            if (n2 == 1) {
                sequenceIterator = sequenceIterator.next();
                return sequenceIterator.atomize().iterate();
            }
        } else if ((n2 & 8) != 0) {
            return new AxisAtomizingIterator((AtomizedValueIterator)sequenceIterator);
        }
        if (bl2) {
            return new UntypedAtomizingIterator(sequenceIterator);
        }
        return new AtomizingIterator(sequenceIterator);
    }

    public static AtomicSequence atomize(Sequence<?> object) {
        if (object instanceof AtomicSequence) {
            return (AtomicSequence)object;
        }
        if (object instanceof EmptySequence) {
            return EmptyAtomicSequence.getInstance();
        }
        object = Atomizer.getAtomizingIterator(object.iterate(), false);
        return new AtomicArray((SequenceIterator<? extends AtomicValue>)object);
    }

    @Override
    public final String getExpressionName() {
        return "data";
    }

    @Override
    public final String toString() {
        return "data(" + this.getBaseExpression().toString() + ")";
    }

    @Override
    public final String toShortString() {
        return this.getBaseExpression().toShortString();
    }
}

