/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.UntypedAtomicValue;

public final class AttributeGetter
extends Expression {
    public static final int CHECK_CONTEXT_ITEM_IS_NODE = 2;
    private FingerprintedQName a;
    private int b = 2;

    public AttributeGetter(FingerprintedQName fingerprintedQName) {
        this.a = fingerprintedQName;
    }

    public final FingerprintedQName getAttributeName() {
        return this.a;
    }

    public final void setRequiredChecks(int n2) {
        this.b = n2;
    }

    public final int getRequiredChecks() {
        return this.b;
    }

    @Override
    public final ItemType getItemType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public final int computeCardinality() {
        return 24576;
    }

    @Override
    public final int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    protected final int computeSpecialProperties() {
        return 0x800000;
    }

    @Override
    public final AttributeGetter copy(RebindingMap object) {
        object = new AttributeGetter(this.a);
        ((AttributeGetter)object).setRequiredChecks(this.b);
        return object;
    }

    @Override
    public final PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet object) {
        if (object == null) {
            object = new ContextItemExpression();
            object = new PathMap.PathMapNodeSet(pathMap.makeNewRoot((Expression)object));
        }
        return ((PathMap.PathMapNodeSet)object).createArc((byte)2, new NameTest(2, this.a, this.getConfiguration().getNamePool()));
    }

    @Override
    public final int getImplementationMethod() {
        return 1;
    }

    public final Item evaluateItem(XPathContext object) {
        Item<?> item = object.getContextItem();
        if (item instanceof TinyElementImpl) {
            object = ((TinyElementImpl)item).getAttributeValue(this.a.getFingerprint());
            if (object == null) {
                return null;
            }
            return new UntypedAtomicValue((CharSequence)object);
        }
        if (item == null) {
            this.dynamicError("The context item for @" + this.a.getDisplayName() + " is absent", "XPDY0002", (XPathContext)object);
        }
        if (!(item instanceof NodeInfo)) {
            this.typeError("The context item for @" + this.a.getDisplayName() + " is not a node", "XPDY0002", (XPathContext)object);
        }
        assert (item instanceof NodeInfo);
        object = (NodeInfo)item;
        if (object.getNodeKind() == 1) {
            if ((object = object.getAttributeValue(this.a.getURI(), this.a.getLocalPart())) == null) {
                return null;
            }
            return new UntypedAtomicValue((CharSequence)object);
        }
        return null;
    }

    @Override
    public final String getExpressionName() {
        return "attGetter";
    }

    @Override
    public final String toShortString() {
        return "@" + this.a.getDisplayName();
    }

    @Override
    public final String toString() {
        return "data(@" + this.a.getDisplayName() + ")";
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof AttributeGetter && ((AttributeGetter)object).a.equals(this.a);
    }

    @Override
    public final int computeHashCode() {
        return 0x14673 ^ this.a.hashCode();
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("attVal", this);
        expressionPresenter.emitAttribute("name", this.a.getStructuredQName());
        expressionPresenter.emitAttribute("chk", "" + this.b);
        expressionPresenter.endElement();
    }
}

