/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public final class AxisExpression
extends Expression {
    private byte a;
    private NodeTest b;
    private ItemType c = null;
    private ContextItemStaticInfo d = ContextItemStaticInfo.DEFAULT;
    private int e = -1;
    private boolean f = false;
    private boolean g = false;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.a = by;
        this.b = nodeTest;
    }

    public final void setAxis(byte by) {
        this.a = by;
    }

    @Override
    public final String getExpressionName() {
        return "axisStep";
    }

    @Override
    public final Expression simplify() {
        Expression expression = super.simplify();
        if (expression != this) {
            return expression;
        }
        if (!(this.b != null && this.b != AnyNodeTest.getInstance() || this.a != 9 && this.a != 0)) {
            this.b = MultipleNodeKindTest.PARENT_NODE;
        }
        return this;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        ItemType itemType = ((ContextItemStaticInfo)object2).getItemType();
        boolean bl2 = this.g || this.f && this.d.getItemType().equals(itemType);
        this.f = true;
        if (itemType == ErrorType.getInstance()) {
            XPathException xPathException = new XPathException("Axis step " + this + " cannot be used here: the context item is absent");
            xPathException.setErrorCode("XPDY0002");
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        this.d = object2;
        Object object3 = ((ExpressionVisitor)object).getConfiguration();
        if (itemType.getGenre() != Genre.NODE) {
            int n2 = ((TypeHierarchy)(object3 = ((Configuration)object3).getTypeHierarchy())).relationship(itemType, AnyNodeTest.getInstance());
            if (n2 == 4) {
                object = new XPathException("Axis step " + this + " cannot be used here: the context item is not a node");
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setErrorCode("XPTY0020");
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
            if (n2 == 3 || n2 == 1) {
                if (Literal.isEmptySequence((Expression)(object = this.a((ExpressionVisitor)object, (ContextItemStaticInfo)object2, !bl2)))) {
                    return object;
                }
                object2 = new ContextItemExpression();
                ExpressionTool.copyLocationInfo(this, (Expression)object2);
                RoleDiagnostic roleDiagnostic = new RoleDiagnostic(14, "", this.a);
                roleDiagnostic.setErrorCode("XPTY0020");
                object2 = new ItemChecker((Expression)object2, AnyNodeTest.getInstance(), roleDiagnostic);
                ExpressionTool.copyLocationInfo(this, (Expression)object2);
                object = new SimpleStepExpression((Expression)object2, (Expression)object);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
        }
        if (((ExpressionVisitor)object).getStaticContext().getOptimizerOptions().isSet(8192)) {
            return this.a((ExpressionVisitor)object, (ContextItemStaticInfo)object2, !bl2);
        }
        return this;
    }

    private Expression a(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, boolean bl2) {
        block85: {
            UType uType;
            UType uType2;
            Object object;
            Object object2 = expressionVisitor.getStaticContext();
            Object object3 = object2.getConfiguration();
            Object object4 = contextItemStaticInfo.getItemType();
            if (!(object4 instanceof NodeTest)) {
                object4 = AnyNodeTest.getInstance();
            }
            if (this.b != null && !AxisInfo.getTargetUType(UType.ANY_NODE, this.a).overlaps(this.b.getUType())) {
                if (bl2) {
                    expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select " + this.b.getUType().toStringWithIndefiniteArticle(), this.getLocation());
                }
                return Literal.makeEmptySequence();
            }
            if (this.b instanceof NameTest && this.a == 8 && !((NameTest)this.b).getNamespaceURI().isEmpty()) {
                if (bl2) {
                    expressionVisitor.issueWarning("The names of namespace nodes are never prefixed, so this axis step will never select anything", this.getLocation());
                }
                return Literal.makeEmptySequence();
            }
            UType uType3 = object4.getUType();
            Object object5 = AxisInfo.getTargetUType(uType3, this.a);
            Object object6 = object = this.b == null ? UType.ANY_NODE : this.b.getUType();
            if (((UType)object5).equals(UType.VOID)) {
                if (bl2) {
                    expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis starting at " + uType3.toStringWithIndefiniteArticle() + " will never select anything", this.getLocation());
                }
                return Literal.makeEmptySequence();
            }
            if (!((UType)object5).overlaps((UType)object)) {
                if (bl2) {
                    expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis starting at " + uType3.toStringWithIndefiniteArticle() + " will never select " + this.b.getUType().toStringWithIndefiniteArticle(), this.getLocation());
                }
                return Literal.makeEmptySequence();
            }
            byte by = AxisInfo.excludeSelfAxis[this.a];
            UType uType4 = uType2 = this.b == null ? UType.ANY_NODE : this.b.getUType();
            if (this.a != by && !(uType = AxisInfo.getTargetUType(uType3, by)).overlaps((UType)object)) {
                this.a = (byte)12;
                object5 = AxisInfo.getTargetUType(uType3, this.a);
            }
            Object object7 = ((UType)object5).toItemType();
            this.c = this.b == null || this.b instanceof AnyNodeTest ? object7 : (object7 instanceof AnyNodeTest || ((UType)object5).subsumes(this.b.getUType()) ? this.b : new CombinedNodeTest((NodeTest)object7, 23, this.b));
            int n2 = object4.getPrimitiveType();
            if (this.b != null) {
                int n3;
                if (object4 instanceof DocumentNodeTest && uType2.equals(UType.ELEMENT) && ((Optional)(object = ((NodeTest)(object5 = ((DocumentNodeTest)object4).getElementTest())).getRequiredNodeNames())).isPresent() && ((Optional)(object7 = this.b.getRequiredNodeNames())).isPresent()) {
                    if (this.a == 3) {
                        if (((IntSet)((Optional)object7).get()).intersect((IntSet)((Optional)object).get()).isEmpty()) {
                            if (bl2) {
                                expressionVisitor.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this.getLocation());
                            }
                            return Literal.makeEmptySequence();
                        }
                        if (object2.getPackageData().isSchemaAware() && object5 instanceof SchemaNodeTest && ((IntSet)((Optional)object).get()).size() == 1) {
                            IntIterator intIterator = ((IntSet)((Optional)object).get()).iterator();
                            int n4 = intIterator.hasNext() ? intIterator.next() : -1;
                            SchemaDeclaration schemaDeclaration = ((Configuration)object3).getElementDeclaration(n4);
                            if (schemaDeclaration == null) {
                                if (bl2) {
                                    expressionVisitor.issueWarning("Element " + ((Configuration)object3).getNamePool().getEQName(n4) + " is not declared in the schema", this.getLocation());
                                }
                                this.c = object5;
                            } else {
                                SchemaType schemaType = schemaDeclaration.getType();
                                this.c = new CombinedNodeTest((NodeTest)object5, 23, new ContentTypeTest(1, schemaType, (Configuration)object3, true));
                            }
                        } else {
                            this.c = object5;
                        }
                        return this;
                    }
                    if (this.a == 4 && (n3 = !((IntSet)((Optional)object7).get()).intersect((IntSet)((Optional)object).get()).isEmpty() ? 1 : 0) == 0) {
                        object4 = ExpressionTool.makePathExpression(new AxisExpression(3, (NodeTest)object5), new AxisExpression(4, this.b));
                        ExpressionTool.copyLocationInfo(this, (Expression)object4);
                        return ((Expression)object4).typeCheck(expressionVisitor, contextItemStaticInfo);
                    }
                }
                if ((object5 = ((NodeTest)object4).getContentType()) == AnyType.getInstance()) {
                    return this;
                }
                if (!object2.getPackageData().isSchemaAware() && (object = this.b.getContentType()) != AnyType.getInstance() && object != Untyped.getInstance() && object != AnySimpleType.getInstance() && object != BuiltInAtomicType.ANY_ATOMIC && object != BuiltInAtomicType.UNTYPED_ATOMIC && object != BuiltInAtomicType.STRING) {
                    if (bl2) {
                        expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select any typed nodes, because the expression is being compiled in an environment that is not schema-aware", this.getLocation());
                    }
                    return Literal.makeEmptySequence();
                }
                int n5 = this.b.getFingerprint();
                object7 = this.b.getMatchingNodeName();
                if (object5.isSimpleType()) {
                    if (bl2) {
                        if ((this.a == 3 || this.a == 4 || this.a == 5) && UType.PARENT_NODE_KINDS.union(UType.ATTRIBUTE).subsumes(uType2)) {
                            expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select any " + uType2 + " nodes when starting at " + (n2 == 2 ? "an attribute node" : AxisExpression.a((SchemaType)object5)), this.getLocation());
                        } else if (this.a == 3 && uType2.equals(UType.TEXT) && this.getParentExpression() instanceof Atomizer) {
                            expressionVisitor.issueWarning("Selecting the text nodes of an element with simple content may give the wrong answer in the presence of comments or processing instructions. It is usually better to omit the '/text()' step", this.getLocation());
                        } else if (this.a == 2) {
                            Iterator<? extends SchemaType> iterator = ((Configuration)object3).getExtensionsOfType((SchemaType)object5);
                            boolean bl3 = false;
                            if (n5 == -1) {
                                while (iterator.hasNext()) {
                                    ComplexType complexType = (ComplexType)iterator.next();
                                    if (!complexType.allowsAttributes()) continue;
                                    bl3 = true;
                                    break;
                                }
                            } else {
                                while (iterator.hasNext()) {
                                    ComplexType complexType = (ComplexType)iterator.next();
                                    try {
                                        if (complexType.getAttributeUseType((StructuredQName)object7) == null) continue;
                                        bl3 = true;
                                        break;
                                    }
                                    catch (SchemaException schemaException) {
                                    }
                                }
                            }
                            if (!bl3) {
                                expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select " + (object7 == null ? "any attribute nodes" : "an attribute node named " + AxisExpression.a((StructuredQName)object7, (StaticContext)object2)) + " when starting at " + AxisExpression.a((SchemaType)object5), this.getLocation());
                            }
                        }
                    }
                } else {
                    if (((ComplexType)object5).isSimpleContent() && (this.a == 3 || this.a == 4 || this.a == 5) && UType.PARENT_NODE_KINDS.subsumes(uType2)) {
                        if (bl2) {
                            expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select any " + uType2 + " nodes when starting at " + AxisExpression.a((SchemaType)object5) + ", as this type requires simple content", this.getLocation());
                        }
                        return Literal.makeEmptySequence();
                    }
                    if (((ComplexType)object5).isEmptyContent() && (this.a == 3 || this.a == 4 || this.a == 5)) {
                        Iterator<? extends SchemaType> iterator = ((Configuration)object3).getExtensionsOfType((SchemaType)object5);
                        while (iterator.hasNext()) {
                            object4 = (ComplexType)iterator.next();
                            if (object4.isEmptyContent()) continue;
                            return this;
                        }
                        if (bl2) {
                            expressionVisitor.issueWarning("The " + AxisInfo.axisName[this.a] + " axis will never select any nodes when starting at " + AxisExpression.a((SchemaType)object5) + ", as this type requires empty content", this.getLocation());
                        }
                        return Literal.makeEmptySequence();
                    }
                    if (this.a == 2) {
                        if (n5 == -1) {
                            if (bl2 && !((ComplexType)object5).allowsAttributes()) {
                                expressionVisitor.issueWarning("The complex type " + object5.getDescription() + " allows no attributes other than the standard attributes in the xsi namespace", this.getLocation());
                            }
                        } else {
                            try {
                                SimpleType simpleType = n5 == 641 ? BuiltInAtomicType.QNAME : (n5 == 643 ? BuiltInListType.ANY_URIS : (n5 == 644 ? BuiltInAtomicType.ANY_URI : (n5 == 642 ? BuiltInAtomicType.BOOLEAN : ((ComplexType)object5).getAttributeUseType((StructuredQName)object7))));
                                if (simpleType == null) {
                                    if (bl2) {
                                        expressionVisitor.issueWarning("The complex type " + object5.getDescription() + " does not allow an attribute named " + AxisExpression.a((StructuredQName)object7, (StaticContext)object2), this.getLocation());
                                        return Literal.makeEmptySequence();
                                    }
                                    break block85;
                                }
                                this.c = new CombinedNodeTest(this.b, 23, new ContentTypeTest(2, simpleType, (Configuration)object3, false));
                            }
                            catch (SchemaException schemaException) {}
                        }
                    } else if (this.a == 3 && uType2.equals(UType.ELEMENT)) {
                        try {
                            n3 = n5;
                            if (object7 == null) {
                                if (((ComplexType)object5).containsElementWildcard()) {
                                    return this;
                                }
                                object4 = new IntHashSet();
                                ((ComplexType)object5).gatherAllPermittedChildren((IntHashSet)object4, false);
                                if (((IntHashSet)object4).isEmpty()) {
                                    if (bl2) {
                                        expressionVisitor.issueWarning("The complex type " + object5.getDescription() + " does not allow children", this.getLocation());
                                    }
                                    return Literal.makeEmptySequence();
                                }
                                if (((IntHashSet)object4).size() == 1) {
                                    IntIterator intIterator = ((IntHashSet)object4).iterator();
                                    if (intIterator.hasNext()) {
                                        n3 = intIterator.next();
                                    }
                                } else {
                                    return this;
                                }
                            }
                            if ((object4 = ((ComplexType)object5).getElementParticleType(n3, true)) == null) {
                                if (bl2) {
                                    StructuredQName structuredQName = this.getConfiguration().getNamePool().getStructuredQName(n3);
                                    String string = "The complex type " + object5.getDescription() + " does not allow a child element named " + AxisExpression.a(structuredQName, (StaticContext)object2);
                                    object2 = new IntHashSet();
                                    ((ComplexType)object5).gatherAllPermittedChildren((IntHashSet)object2, false);
                                    if (!((IntHashSet)object2).contains(-1)) {
                                        object7 = ((IntHashSet)object2).iterator();
                                        while (object7.hasNext()) {
                                            int n6 = object7.next();
                                            StructuredQName structuredQName2 = this.getConfiguration().getNamePool().getStructuredQName(n6);
                                            if (!structuredQName2.getLocalPart().equals(structuredQName.getLocalPart()) || n6 == n3) continue;
                                            string = string + ". Perhaps the namespace is " + (structuredQName.hasURI("") ? "missing" : "wrong") + ", and " + structuredQName2.getEQName() + " was intended?";
                                            break;
                                        }
                                        expressionVisitor.issueWarning(string, this.getLocation());
                                    }
                                }
                                return Literal.makeEmptySequence();
                            }
                            this.c = new CombinedNodeTest(this.b, 23, new ContentTypeTest(1, (SchemaType)object4, (Configuration)object3, true));
                            this.e = ((ComplexType)object5).getElementParticleCardinality(n3, true);
                            ExpressionTool.resetStaticProperties(this);
                            if (this.e == 8192) {
                                StructuredQName structuredQName = this.getConfiguration().getNamePool().getStructuredQName(n3);
                                expressionVisitor.issueWarning("The complex type " + object5.getDescription() + " appears not to allow a child element named " + AxisExpression.a(structuredQName, (StaticContext)object2), this.getLocation());
                                return Literal.makeEmptySequence();
                            }
                            if (!(Cardinality.allowsMany(this.e) || this.getParentExpression() instanceof FirstItemExpression || expressionVisitor.isOptimizeForPatternMatching())) {
                                return FirstItemExpression.makeFirstItemExpression(this);
                            }
                        }
                        catch (SchemaException schemaException) {}
                    } else if (this.a == 4 && uType2.equals(UType.ELEMENT) && n5 != -1) {
                        try {
                            IntHashSet intHashSet = new IntHashSet();
                            ((ComplexType)object5).gatherAllPermittedDescendants(intHashSet);
                            if (intHashSet.contains(-1)) {
                                return this;
                            }
                            if (intHashSet.contains(n5)) {
                                SchemaType schemaType;
                                Object object8;
                                object4 = new IntHashSet();
                                ((ComplexType)object5).gatherAllPermittedChildren((IntHashSet)object4, false);
                                Object object9 = new IntHashSet();
                                bl2 = false;
                                boolean bl4 = false;
                                object7 = ((IntHashSet)object4).iterator();
                                while (object7.hasNext()) {
                                    int n7 = object7.next();
                                    if (n7 == n5) {
                                        ((IntHashSet)object9).add(n7);
                                        bl2 = true;
                                    }
                                    if ((object8 = ((ComplexType)object5).getElementParticleType(n7, true)) == null) {
                                        throw new AssertionError((Object)("Can't find type for child element " + n7));
                                    }
                                    if (!(object8 instanceof ComplexType)) continue;
                                    intHashSet = new IntHashSet();
                                    ((ComplexType)object8).gatherAllPermittedDescendants(intHashSet);
                                    if (!intHashSet.contains(n5)) continue;
                                    ((IntHashSet)object9).add(n7);
                                    bl4 = true;
                                }
                                this.c = this.b;
                                if (bl4 && (schemaType = ((ComplexType)object5).getDescendantElementType(n5)) != AnyType.getInstance()) {
                                    this.c = new CombinedNodeTest(this.b, 23, new ContentTypeTest(1, schemaType, (Configuration)object3, true));
                                }
                                if (((IntHashSet)object9).size() < ((IntHashSet)object4).size()) {
                                    object4 = ((Configuration)object3).getNamePool();
                                    object3 = object9;
                                    object9 = null;
                                    object3 = ((IntHashSet)object3).iterator();
                                    while (object3.hasNext()) {
                                        int n8 = object3.next();
                                        object5 = new NameTest(1, n8, (NamePool)object4);
                                        if (object9 == null) {
                                            object9 = object5;
                                            continue;
                                        }
                                        object9 = new CombinedNodeTest((NodeTest)object9, 1, (NodeTest)object5);
                                    }
                                    IntHashSet intHashSet2 = object9;
                                    object8 = new AxisExpression(3, (NodeTest)((Object)intHashSet2));
                                    ExpressionTool.copyLocationInfo(this, (Expression)object8);
                                    byte by2 = bl2 ? (bl4 ? (byte)5 : 12) : (byte)4;
                                    Expression expression = new AxisExpression(by2, (NodeTest)this.c);
                                    ExpressionTool.copyLocationInfo(this, expression);
                                    expression = ExpressionTool.makePathExpression((Expression)object8, expression);
                                    ExpressionTool.copyLocationInfo(this, expression);
                                    return expression.typeCheck(expressionVisitor, contextItemStaticInfo);
                                }
                            } else if (bl2) {
                                expressionVisitor.issueWarning("The complex type " + object5.getDescription() + " does not allow a descendant element named " + AxisExpression.a((StructuredQName)object7, (StaticContext)object2), this.getLocation());
                            }
                        }
                        catch (SchemaException schemaException) {
                            throw new AssertionError((Object)schemaException);
                        }
                    }
                }
            }
        }
        return this;
    }

    private static String a(StructuredQName structuredQName, StaticContext object) {
        String string = structuredQName.getURI();
        if (string.equals("")) {
            return structuredQName.getLocalPart();
        }
        object = object.getNamespaceResolver();
        Iterator<String> iterator = object.iteratePrefixes();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string.equals(object.getURIForPrefix(string2, true))) continue;
            if (string2.isEmpty()) {
                return "Q{" + string + "}" + structuredQName.getLocalPart();
            }
            return string2 + ":" + structuredQName.getLocalPart();
        }
        return "Q{" + string + "}" + structuredQName.getLocalPart();
    }

    private static String a(SchemaType schemaType) {
        String string = schemaType.getDescription();
        if (string.startsWith("of element")) {
            return "a valid element named" + string.substring(10);
        }
        if (string.startsWith("of attribute")) {
            return "a valid attribute named" + string.substring(12);
        }
        return "a node with " + (schemaType.isSimpleType() ? "simple" : "complex") + " type " + string;
    }

    public final ItemType getContextItemType() {
        return this.d.getItemType();
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.g = true;
        this.d = contextItemStaticInfo;
        return this;
    }

    @Override
    public final double getCost() {
        switch (this.a) {
            case 2: 
            case 9: 
            case 12: {
                return 1.0;
            }
            case 0: 
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                return 5.0;
            }
        }
        return 20.0;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof AxisExpression && this.a == ((AxisExpression)object).a && Objects.equals(this.b, ((AxisExpression)object).b);
    }

    @Override
    public final int computeHashCode() {
        int n2 = 9375162 + this.a << 20;
        if (this.b != null) {
            n2 ^= this.b.getPrimitiveType() << 16;
            n2 ^= this.b.getFingerprint();
        }
        return n2;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new AxisExpression(this.a, this.b);
        new AxisExpression(this.a, this.b).c = this.c;
        ((AxisExpression)object).d = this.d;
        ((AxisExpression)object).e = this.e;
        ((AxisExpression)object).f = this.f;
        ((AxisExpression)object).g = this.g;
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final int computeSpecialProperties() {
        Object object;
        return 0x1810000 | (AxisInfo.isForwards[this.a] ? 131072 : 262144) | (AxisInfo.isPeerAxis[this.a] || ((object = this.b) == null ? false : (((UType)(object = object.getUType())).overlaps(UType.ELEMENT) ? false : (((UType)object).overlaps(UType.DOCUMENT) ? ((UType)object).equals(UType.DOCUMENT) : true))) ? 524288 : 0) | (AxisInfo.isSubtreeAxis[this.a] ? 0x100000 : 0) | (this.a == 2 || this.a == 8 ? 0x200000 : 0);
    }

    @Override
    public final ItemType getItemType() {
        if (this.c != null) {
            return this.c;
        }
        short s2 = AxisInfo.principalNodeType[this.a];
        switch (s2) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(s2);
            }
        }
        if (this.b == null) {
            return AnyNodeTest.getInstance();
        }
        return this.b;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        uType = AxisInfo.getTargetUType(uType, this.a);
        if (this.b == null) {
            return uType;
        }
        return uType.intersection(this.b.getUType());
    }

    @Override
    public final int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public final int computeCardinality() {
        if (this.e != -1) {
            return this.e;
        }
        NodeTest nodeTest = this.b;
        Object object = this.d.getItemType();
        if (object instanceof NodeTest) {
            object = (NodeTest)object;
        } else if (object instanceof AnyItemType) {
            object = AnyNodeTest.getInstance();
        } else {
            return 57344;
        }
        if (this.a == 2 && nodeTest instanceof NameTest) {
            if ((object = ((NodeTest)object).getContentType()) instanceof ComplexType) {
                try {
                    return ((ComplexType)object).getAttributeUseCardinality(nodeTest.getMatchingNodeName());
                }
                catch (SchemaException schemaException) {
                    return 24576;
                }
            }
            if (object instanceof SimpleType) {
                return 8192;
            }
            return 24576;
        }
        if (this.a == 4 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
            if ((object = ((NodeTest)object).getContentType()) instanceof ComplexType) {
                try {
                    return ((ComplexType)object).getDescendantElementCardinality(nodeTest.getFingerprint());
                }
                catch (SchemaException schemaException) {
                    return 57344;
                }
            }
            return 8192;
        }
        if (this.a == 12) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public final boolean isSubtreeExpression() {
        return AxisInfo.isSubtreeAxis[this.a];
    }

    public final byte getAxis() {
        return this.a;
    }

    public final NodeTest getNodeTest() {
        return this.b;
    }

    @Override
    public final PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet object) {
        if (object == null) {
            object = new ContextItemExpression();
            object = new PathMap.PathMapNodeSet(pathMap.makeNewRoot((Expression)object));
        }
        return ((PathMap.PathMapNodeSet)object).createArc(this.a, this.b == null ? AnyNodeTest.getInstance() : this.b);
    }

    public final boolean isContextPossiblyUndefined() {
        return this.d.isPossiblyAbsent();
    }

    public final ContextItemStaticInfo getContextItemStaticInfo() {
        return this.d;
    }

    @Override
    public final Pattern toPattern(Configuration object) {
        object = this.getNodeTest();
        if (object == null) {
            object = AnyNodeTest.getInstance();
        }
        if (object instanceof AnyNodeTest && (this.a == 3 || this.a == 4 || this.a == 12)) {
            object = AnyChildNodeTest.getInstance();
        }
        int n2 = ((NodeTest)object).getPrimitiveType();
        if (this.a == 12) {
            object = new NodeTestPattern((NodeTest)object);
        } else if (this.a == 2) {
            object = n2 == 0 ? new NodeTestPattern(NodeKindTest.ATTRIBUTE) : (!AxisInfo.containsNodeKind(this.a, n2) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern((NodeTest)object));
        } else if (this.a == 3 || this.a == 4 || this.a == 5) {
            object = n2 != 0 && !AxisInfo.containsNodeKind(this.a, n2) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern((NodeTest)object);
        } else if (this.a == 8) {
            object = n2 == 0 ? new NodeTestPattern(NodeKindTest.NAMESPACE) : (!AxisInfo.containsNodeKind(this.a, n2) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern((NodeTest)object));
        } else {
            throw new XPathException("Only downwards axes are allowed in a pattern", "XTSE0340");
        }
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final int getImplementationMethod() {
        return 2;
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        Item<?> item = xPathContext.getContextItem();
        if (item == null) {
            item = new XPathException("The context item for axis step " + this + " is absent");
            ((XPathException)((Object)item)).setErrorCode("XPDY0002");
            ((XPathException)((Object)item)).setXPathContext(xPathContext);
            ((XPathException)((Object)item)).setLocation(this.getLocation());
            ((XPathException)((Object)item)).setIsTypeError(true);
            throw item;
        }
        try {
            if (this.b == null) {
                return ((NodeInfo)item).iterateAxis(this.a);
            }
            return ((NodeInfo)item).iterateAxis(this.a, this.b);
        }
        catch (ClassCastException classCastException) {
            item = new XPathException("The context item for axis step " + this + " is not a node");
            ((XPathException)((Object)item)).setErrorCode("XPTY0020");
            ((XPathException)((Object)item)).setXPathContext(xPathContext);
            ((XPathException)((Object)item)).setLocation(this.getLocation());
            ((XPathException)((Object)item)).setIsTypeError(true);
            throw item;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            item = unsupportedOperationException;
            if (unsupportedOperationException.getCause() instanceof XPathException) {
                item = (XPathException)((Throwable)((Object)item)).getCause();
                ((XPathException)((Object)item)).maybeSetLocation(this.getLocation());
                ((XPathException)((Object)item)).maybeSetContext(xPathContext);
                throw item;
            }
            this.dynamicError(((Throwable)((Object)item)).getMessage(), "XPST0010", xPathContext);
            return null;
        }
    }

    public final AxisIterator iterate(NodeInfo nodeInfo) {
        if (this.b == null) {
            return nodeInfo.iterateAxis(this.a);
        }
        return nodeInfo.iterateAxis(this.a, this.b);
    }

    @Override
    public final void export(ExpressionPresenter object) {
        ((ExpressionPresenter)object).startElement("axis", this);
        ((ExpressionPresenter)object).emitAttribute("name", AxisInfo.axisName[this.a]);
        ((ExpressionPresenter)object).emitAttribute("nodeTest", this.b == null ? "node()" : this.b.toString());
        if ("JS".equals(((ExpressionPresenter.ExportOptions)((ExpressionPresenter)object).getOptions()).target)) {
            NodeTest nodeTest = AnyNodeTest.getInstance();
            if (this.a == 2) {
                nodeTest = NodeKindTest.makeNodeKindTest(2);
            } else if (this.a == 8) {
                nodeTest = NodeKindTest.makeNodeKindTest(13);
            }
            int n2 = ((ExpressionPresenter.ExportOptions)((ExpressionPresenter)object).getOptions()).targetVersion;
            try {
                ((ExpressionPresenter)object).emitAttribute("jsTest", this.b == null ? "return true;" : this.b.generateJavaScriptItemTypeTest(nodeTest, n2));
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw object;
            }
        }
        ((ExpressionPresenter)object).endElement();
    }

    @Override
    public final String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append(AxisInfo.axisName[this.a]);
        fastStringBuffer.append("::");
        fastStringBuffer.append(this.b == null ? "node()" : this.b.toString());
        return fastStringBuffer.toString();
    }

    @Override
    public final String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        if (this.a != 3) {
            if (this.a == 2) {
                fastStringBuffer.append("@");
            } else {
                fastStringBuffer.append(AxisInfo.axisName[this.a]);
                fastStringBuffer.append("::");
            }
        }
        if (this.b == null) {
            fastStringBuffer.append("node()");
        } else if (this.b instanceof NameTest && ((NameTest)this.b).getNodeKind() == AxisInfo.principalNodeType[this.a]) {
            fastStringBuffer.append(this.b.getMatchingNodeName().getDisplayName());
        } else {
            fastStringBuffer.append(this.b.toString());
        }
        return fastStringBuffer.toString();
    }

    @Override
    public final String getStreamerName() {
        return "AxisExpression";
    }

    public final Set<Expression> getPreconditions() {
        HashSet<Expression> hashSet = new HashSet<Expression>(1);
        Expression expression = ((Expression)this).copy(new RebindingMap());
        expression.setRetainedStaticContext(this.getRetainedStaticContext());
        hashSet.add(expression);
        return hashSet;
    }
}

