/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;

public class BigRangeIterator
implements LastPositionFinder,
AtomicIterator,
LookaheadIterator<AtomicValue> {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;

    public BigRangeIterator(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.subtract(bigInteger).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        this.a = bigInteger;
        this.b = bigInteger.subtract(BigInteger.valueOf(1L));
        this.c = bigInteger2;
    }

    @Override
    public boolean hasNext() {
        return this.b.compareTo(this.c) < 0;
    }

    @Override
    public IntegerValue next() {
        this.b = this.b.add(BigInteger.valueOf(1L));
        if (this.b.compareTo(this.c) > 0) {
            return null;
        }
        return IntegerValue.makeIntegerValue(this.b);
    }

    @Override
    public int getLength() {
        BigInteger bigInteger = this.c.subtract(this.a).add(BigInteger.valueOf(1L));
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UncheckedXPathException(new XPathException("Sequence exceeds Saxon limit (32-bit integer)"));
        }
        return bigInteger.intValue();
    }

    @Override
    public int getProperties() {
        return 6;
    }
}

