/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.PairIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.Cardinality;

public abstract class BinaryExpression
extends Expression {
    private Operand a;
    private Operand b;
    protected int operator;

    public BinaryExpression(Expression expression, int n2, Expression expression2) {
        this.operator = n2;
        this.a = new Operand(this, expression, this.getOperandRole(0));
        this.b = new Operand(this, expression2, this.getOperandRole(1));
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    @Override
    public final Iterable<Operand> operands() {
        return () -> new PairIterator<Operand>(this.a, this.b);
    }

    protected OperandRole getOperandRole(int n2) {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Operand getLhs() {
        return this.a;
    }

    public final Expression getLhsExpression() {
        return this.a.getChildExpression();
    }

    public void setLhsExpression(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Operand getRhs() {
        return this.b;
    }

    public final Expression getRhsExpression() {
        return this.b.getChildExpression();
    }

    public void setRhsExpression(Expression expression) {
        this.b.setChildExpression(expression);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.resetLocalStaticProperties();
        this.a.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        this.b.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        try {
            if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
                object = this.evaluateItem(((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext()).materialize();
                return Literal.makeLiteral(object, this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor groundedValue, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.optimize((ExpressionVisitor)((Object)groundedValue), contextItemStaticInfo);
        this.b.optimize((ExpressionVisitor)((Object)groundedValue), contextItemStaticInfo);
        try {
            if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal && (groundedValue = this.evaluateItem(((ExpressionVisitor)((Object)groundedValue)).getStaticContext().makeEarlyEvaluationContext())) != null) {
                groundedValue = groundedValue.materialize();
                return Literal.makeLiteral(groundedValue, this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public void setFlattened(boolean bl2) {
        this.getLhsExpression().setFlattened(bl2);
        this.getRhsExpression().setFlattened(bl2);
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public int computeCardinality() {
        Expression expression = this.getLhsExpression();
        Expression expression2 = this.getRhsExpression();
        if (!Cardinality.allowsZero(expression.getCardinality()) && expression.getItemType() instanceof AtomicType && !Cardinality.allowsZero(expression2.getCardinality()) && expression2.getItemType() instanceof AtomicType) {
            return 16384;
        }
        return 24576;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x800000;
    }

    protected static boolean isCommutative(int n2) {
        return n2 == 10 || n2 == 9 || n2 == 1 || n2 == 23 || n2 == 15 || n2 == 17 || n2 == 6 || n2 == 50 || n2 == 22 || n2 == 51;
    }

    protected static boolean isAssociative(int n2) {
        return n2 == 10 || n2 == 9 || n2 == 1 || n2 == 23 || n2 == 15 || n2 == 17;
    }

    protected static boolean isInverse(int n2, int n3) {
        return n2 != n3 && n2 == Token.inverse(n3);
    }

    @Override
    public int getImplementationMethod() {
        return 3;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BinaryExpression && this.hasCompatibleStaticContext((Expression)object)) {
            object = (BinaryExpression)object;
            Expression expression = this.getLhsExpression();
            Expression expression2 = this.getRhsExpression();
            Expression expression3 = ((BinaryExpression)object).getLhsExpression();
            Expression expression4 = ((BinaryExpression)object).getRhsExpression();
            if (this.operator == ((BinaryExpression)object).operator) {
                if (expression.isEqual(expression3) && expression2.isEqual(expression4)) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && expression.isEqual(expression4) && expression2.isEqual(expression3)) {
                    return true;
                }
                if (BinaryExpression.isAssociative(this.operator)) {
                    boolean bl2;
                    block9: {
                        List<Expression> list = super.a(new ArrayList<Expression>(4));
                        List<Expression> list2 = this.a(new ArrayList<Expression>(4));
                        if (list2.size() != list.size()) {
                            bl2 = false;
                        } else {
                            for (int i2 = 0; i2 < list2.size(); ++i2) {
                                if (((Object)list2.get(i2)).equals(list.get(i2))) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        return true;
                    }
                }
            }
            return BinaryExpression.isInverse(this.operator, ((BinaryExpression)object).operator) && expression.isEqual(expression4) && expression2.isEqual(expression3);
        }
        return false;
    }

    private List<Expression> a(List<Expression> list) {
        int n2;
        int n3;
        if (this.getLhsExpression() instanceof BinaryExpression && ((BinaryExpression)this.getLhsExpression()).operator == this.operator) {
            ((BinaryExpression)this.getLhsExpression()).a(list);
        } else {
            n3 = this.getLhsExpression().hashCode();
            list.add(this.getLhsExpression());
            for (n2 = list.size() - 1; n2 > 0 && n3 > list.get(n2 - 1).hashCode(); --n2) {
                list.set(n2, list.get(n2 - 1));
                list.set(n2 - 1, this.getLhsExpression());
            }
        }
        if (this.getRhsExpression() instanceof BinaryExpression && ((BinaryExpression)this.getRhsExpression()).operator == this.operator) {
            ((BinaryExpression)this.getRhsExpression()).a(list);
        } else {
            n3 = this.getRhsExpression().hashCode();
            list.add(this.getRhsExpression());
            for (n2 = list.size() - 1; n2 > 0 && n3 > list.get(n2 - 1).hashCode(); --n2) {
                list.set(n2, list.get(n2 - 1));
                list.set(n2 - 1, this.getRhsExpression());
            }
        }
        return list;
    }

    @Override
    public int computeHashCode() {
        int n2 = Math.min(this.operator, Token.inverse(this.operator));
        return ("BinaryExpression " + n2).hashCode() ^ this.getLhsExpression().hashCode() ^ this.getRhsExpression().hashCode();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getLhsExpression()) + " " + this.displayOperator() + " " + ExpressionTool.parenthesize(this.getRhsExpression());
    }

    @Override
    public String toShortString() {
        BinaryExpression binaryExpression = this;
        BinaryExpression binaryExpression2 = this;
        return binaryExpression.a(binaryExpression.getLhsExpression()) + " " + this.displayOperator() + " " + binaryExpression2.a(binaryExpression2.getRhsExpression());
    }

    private String a(Expression expression) {
        String string = expression.toShortString();
        if (expression instanceof BinaryExpression && XPathParser.operatorPrecedence(((BinaryExpression)expression).operator) < XPathParser.operatorPrecedence(this.operator)) {
            string = "(" + string + ")";
        }
        return string;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement(this.tag(), this);
        expressionPresenter.emitAttribute("op", this.displayOperator());
        this.explainExtraAttributes(expressionPresenter);
        this.getLhsExpression().export(expressionPresenter);
        this.getRhsExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    protected String tag() {
        return "operator";
    }

    protected void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
    }

    protected String displayOperator() {
        return Token.tokens[this.operator];
    }
}

