/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;

public abstract class BooleanExpression
extends BinaryExpression
implements Negatable {
    public BooleanExpression(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public String getExpressionName() {
        return Token.tokens[this.getOperator()] + "-expression";
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.getLhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.getRhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = expressionVisitor.getConfiguration().getTypeHierarchy();
        XPathException xPathException = TypeChecker.ebvError(this.getLhsExpression(), (TypeHierarchy)object);
        if (xPathException != null) {
            xPathException.setLocator(this.getLocation());
            throw xPathException;
        }
        object = TypeChecker.ebvError(this.getRhsExpression(), (TypeHierarchy)object);
        if (object != null) {
            ((TransformerException)object).setLocator(this.getLocation());
            throw object;
        }
        if (this.getLhsExpression() instanceof Literal && !(((Literal)this.getLhsExpression()).getValue() instanceof BooleanValue)) {
            BooleanExpression booleanExpression = this;
            booleanExpression.setLhsExpression(Literal.makeLiteral(BooleanValue.get(booleanExpression.getLhsExpression().effectiveBooleanValue(expressionVisitor.makeDynamicContext())), this));
        }
        if (this.getRhsExpression() instanceof Literal && !(((Literal)this.getRhsExpression()).getValue() instanceof BooleanValue)) {
            BooleanExpression booleanExpression = this;
            booleanExpression.setRhsExpression(Literal.makeLiteral(BooleanValue.get(booleanExpression.getRhsExpression().effectiveBooleanValue(expressionVisitor.makeDynamicContext())), this));
        }
        return this.preEvaluate();
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren((ExpressionVisitor)object, contextItemStaticInfo);
        boolean bl2 = ((ExpressionVisitor)object).isOptimizeForStreaming();
        BooleanExpression booleanExpression = this;
        booleanExpression.setLhsExpression(ExpressionTool.unsortedIfHomogeneous(booleanExpression.getLhsExpression(), bl2));
        BooleanExpression booleanExpression2 = this;
        booleanExpression2.setRhsExpression(ExpressionTool.unsortedIfHomogeneous(booleanExpression2.getRhsExpression(), bl2));
        Expression expression = BooleanFn.rewriteEffectiveBooleanValue(this.getLhsExpression(), (ExpressionVisitor)object, contextItemStaticInfo);
        if (expression != null) {
            this.setLhsExpression(expression);
        }
        if ((object = BooleanFn.rewriteEffectiveBooleanValue(this.getRhsExpression(), (ExpressionVisitor)object, contextItemStaticInfo)) != null) {
            this.setRhsExpression((Expression)object);
        }
        return this.preEvaluate();
    }

    protected abstract Expression preEvaluate();

    protected Expression forceToBoolean(Expression expression) {
        if (expression.getItemType() == BuiltInAtomicType.BOOLEAN && expression.getCardinality() == 16384) {
            return expression;
        }
        return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), expression);
    }

    @Override
    public boolean isNegatable(TypeHierarchy typeHierarchy) {
        return true;
    }

    @Override
    public abstract Expression negate();

    public BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public abstract boolean effectiveBooleanValue(XPathContext var1);

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    public static void listAndComponents(Expression object, List<Expression> list) {
        if (object instanceof BooleanExpression && ((BooleanExpression)object).getOperator() == 10) {
            for (Operand operand : ((Expression)object).operands()) {
                BooleanExpression.listAndComponents(operand.getChildExpression(), list);
            }
            return;
        }
        list.add((Expression)object);
    }

    @Override
    protected OperandRole getOperandRole(int n2) {
        return OperandRole.INSPECT;
    }
}

