/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntHashMap;

public abstract class Calculator {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int IDIV = 5;
    private static final int[] a = new int[]{15, 16, 17, 18, 19, 56};
    public static final Calculator[] ANY_ANY = new Calculator[]{new AnyPlusAny(), new AnyMinusAny(), new AnyTimesAny(), new AnyDivAny(), new AnyModAny(), new AnyIdivAny()};
    public static final Calculator[] DOUBLE_DOUBLE = new Calculator[]{new DoublePlusDouble(), new DoubleMinusDouble(), new DoubleTimesDouble(), new DoubleDivDouble(), new DoubleModDouble(), new d(0)};
    public static final Calculator[] DOUBLE_FLOAT = DOUBLE_DOUBLE;
    public static final Calculator[] DOUBLE_DECIMAL = DOUBLE_DOUBLE;
    public static final Calculator[] DOUBLE_INTEGER = DOUBLE_DOUBLE;
    public static final Calculator[] FLOAT_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] FLOAT_FLOAT = new Calculator[]{new FloatPlusFloat(), new FloatMinusFloat(), new FloatTimesFloat(), new FloatDivFloat(), new FloatModFloat(), new FloatIdivFloat()};
    public static final Calculator[] FLOAT_DECIMAL = FLOAT_FLOAT;
    public static final Calculator[] FLOAT_INTEGER = FLOAT_FLOAT;
    public static final Calculator[] DECIMAL_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] DECIMAL_FLOAT = FLOAT_FLOAT;
    public static final Calculator[] DECIMAL_DECIMAL = new Calculator[]{new DecimalPlusDecimal(), new DecimalMinusDecimal(), new DecimalTimesDecimal(), new DecimalDivDecimal(), new DecimalModDecimal(), new DecimalIdivDecimal()};
    public static final Calculator[] DECIMAL_INTEGER = DECIMAL_DECIMAL;
    public static final Calculator[] INTEGER_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] INTEGER_FLOAT = FLOAT_FLOAT;
    public static final Calculator[] INTEGER_DECIMAL = DECIMAL_DECIMAL;
    public static final Calculator[] INTEGER_INTEGER = new Calculator[]{new IntegerPlusInteger(), new IntegerMinusInteger(), new IntegerTimesInteger(), new IntegerDivInteger(), new IntegerModInteger(), new IntegerIdivInteger()};
    public static final Calculator[] DATETIME_DATETIME = new Calculator[]{null, new a(0), null, null, null, null};
    public static final Calculator[] DATETIME_DURATION = new Calculator[]{new c(0), new b(0), null, null, null, null};
    public static final Calculator[] DURATION_DATETIME = new Calculator[]{new h(0), null, null, null, null, null};
    public static final Calculator[] DURATION_DURATION = new Calculator[]{new i(0), new g(0), null, new e(0), null, null};
    public static final Calculator[] DURATION_NUMERIC = new Calculator[]{null, null, new j(0), new f(0), null, null};
    public static final Calculator[] NUMERIC_DURATION = new Calculator[]{null, null, new k(0), null, null, null};
    private static IntHashMap<Calculator[]> b = new IntHashMap(100);
    private static IntHashMap<String> c = new IntHashMap(100);

    public static int getTokenFromOperator(int n2) {
        return a[n2];
    }

    public String code() {
        String string = this.getClass().getSimpleName();
        return string.replaceAll("Any", "a").replaceAll("Double", "d").replaceAll("Float", "f").replaceAll("Decimal", "c").replaceAll("Integer", "i").replaceAll("Numeric", "n").replaceAll("DateTime", "t").replaceAll("Duration", "u").replaceAll("Plus", "+").replaceAll("Minus", "-").replaceAll("Times", "*").replaceAll("Div", "/").replaceAll("Idiv", "~").replaceAll("Mod", "%");
    }

    private static void a(int n2, int n3, Calculator[] calculatorArray, String string) {
        while (true) {
            int n4 = (n2 & 0xFFFF) << 16 | n3 & 0xFFFF;
            b.put(n4, calculatorArray);
            c.put(n4, string);
            if (n2 == 518) {
                Calculator.a(634, n3, calculatorArray, string);
                Calculator.a(633, n3, calculatorArray, string);
            }
            if (n3 == 518) {
                Calculator.a(n2, 634, calculatorArray, string);
                Calculator.a(n2, 633, calculatorArray, string);
            }
            if (n2 == 519) {
                Calculator.a(521, n3, calculatorArray, string);
                Calculator.a(520, n3, calculatorArray, string);
            }
            if (n3 == 519) {
                Calculator.a(n2, 521, calculatorArray, string);
                Calculator.a(n2, 520, calculatorArray, string);
            }
            if (n2 == 517) {
                Calculator.a(631, n3, calculatorArray, string);
            }
            if (n3 != 517) break;
            n3 = 631;
        }
    }

    public static Calculator getCalculator(int n2, int n3, int n4, boolean bl2) {
        Calculator[] calculatorArray = b.get(n2 = (n2 & 0xFFFF) << 16 | n3 & 0xFFFF);
        if (calculatorArray == null) {
            if (bl2) {
                return null;
            }
            return ANY_ANY[n4];
        }
        return calculatorArray[n4];
    }

    public static Calculator reconstructCalculator(String string) {
        int n2 = Calculator.a(string.charAt(0));
        int n3 = Calculator.a(string.charAt(2));
        int n4 = Calculator.operatorFromCode(string.charAt(1));
        return Calculator.getCalculator(n2, n3, n4, false);
    }

    private static int a(char c2) {
        switch (c2) {
            case 'a': {
                return 632;
            }
            case 'd': {
                return 517;
            }
            case 'i': {
                return 533;
            }
            case 'f': {
                return 516;
            }
            case 'c': {
                return 515;
            }
            case 'n': {
                return 635;
            }
            case 't': {
                return 519;
            }
            case 'u': {
                return 518;
            }
        }
        throw new AssertionError();
    }

    public static int operatorFromCode(char c2) {
        switch (c2) {
            case '+': {
                return 0;
            }
            case '-': {
                return 1;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '~': {
                return 5;
            }
            case '%': {
                return 4;
            }
        }
        throw new AssertionError();
    }

    public static String getCalculatorSetName(int n2, int n3) {
        n2 = (n2 & 0xFFFF) << 16 | n3 & 0xFFFF;
        return c.get(n2);
    }

    public abstract AtomicValue compute(AtomicValue var1, AtomicValue var2, XPathContext var3);

    public abstract AtomicType getResultType(AtomicType var1, AtomicType var2);

    public static BigDecimalValue decimalDivide(NumericValue comparable, NumericValue numericValue) {
        comparable = ((NumericValue)comparable).getDecimalValue();
        BigDecimal bigDecimal = numericValue.getDecimalValue();
        int n2 = Math.max(18, ((BigDecimal)comparable).scale() - bigDecimal.scale() + 18);
        try {
            comparable = ((BigDecimal)comparable).divide(bigDecimal, n2, RoundingMode.HALF_DOWN);
            return new BigDecimalValue((BigDecimal)comparable);
        }
        catch (ArithmeticException arithmeticException) {
            if (numericValue.compareTo(0L) == 0) {
                throw new XPathException("Decimal divide by zero", "FOAR0001");
            }
            throw arithmeticException;
        }
    }

    static {
        Calculator.a(517, 517, DOUBLE_DOUBLE, "DOUBLE_DOUBLE");
        Calculator.a(517, 516, DOUBLE_FLOAT, "DOUBLE_FLOAT");
        Calculator.a(517, 515, DOUBLE_DECIMAL, "DOUBLE_DECIMAL");
        Calculator.a(517, 533, DOUBLE_INTEGER, "DOUBLE_INTEGER");
        Calculator.a(516, 517, FLOAT_DOUBLE, "FLOAT_DOUBLE");
        Calculator.a(516, 516, FLOAT_FLOAT, "FLOAT_FLOAT");
        Calculator.a(516, 515, FLOAT_DECIMAL, "FLOAT_DECIMAL");
        Calculator.a(516, 533, FLOAT_INTEGER, "FLOAT_INTEGER");
        Calculator.a(515, 517, DECIMAL_DOUBLE, "DECIMAL_DOUBLE");
        Calculator.a(515, 516, DECIMAL_FLOAT, "DECIMAL_FLOAT");
        Calculator.a(515, 515, DECIMAL_DECIMAL, "DECIMAL_DECIMAL");
        Calculator.a(515, 533, DECIMAL_INTEGER, "DECIMAL_INTEGER");
        Calculator.a(533, 517, INTEGER_DOUBLE, "INTEGER_DOUBLE");
        Calculator.a(533, 516, INTEGER_FLOAT, "INTEGER_FLOAT");
        Calculator.a(533, 515, INTEGER_DECIMAL, "INTEGER_DECIMAL");
        Calculator.a(533, 533, INTEGER_INTEGER, "INTEGER_INTEGER");
        Calculator.a(519, 519, DATETIME_DATETIME, "DATETIME_DATETIME");
        Calculator.a(519, 518, DATETIME_DURATION, "DATETIME_DURATION");
        Calculator.a(518, 519, DURATION_DATETIME, "DURATION_DATETIME");
        Calculator.a(518, 518, DURATION_DURATION, "DURATION_DURATION");
        Calculator.a(518, 517, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.a(518, 516, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.a(518, 515, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.a(518, 533, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.a(517, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.a(516, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.a(515, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.a(533, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
    }

    private static final class f
    extends Calculator {
        private f() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            double d2 = 1.0 / ((NumericValue)atomicValue2).getDoubleValue();
            return ((DurationValue)atomicValue).multiply(d2);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ f(byte by) {
            this();
        }
    }

    private static final class k
    extends Calculator {
        private k() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            if (atomicValue instanceof Int64Value) {
                return ((DurationValue)atomicValue2).multiply(((NumericValue)((Int64Value)atomicValue)).longValue());
            }
            return ((DurationValue)atomicValue2).multiply(((NumericValue)atomicValue).getDoubleValue());
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType2;
        }

        /* synthetic */ k(byte by) {
            this();
        }
    }

    private static final class j
    extends Calculator {
        private j() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            if (atomicValue2 instanceof Int64Value) {
                return ((DurationValue)atomicValue).multiply(((NumericValue)((Int64Value)atomicValue2)).longValue());
            }
            return ((DurationValue)atomicValue).multiply(((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ j(byte by) {
            this();
        }
    }

    private static final class e
    extends Calculator {
        private e() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((DurationValue)atomicValue).divide((DurationValue)atomicValue2);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    private static final class g
    extends Calculator {
        private g() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((DurationValue)atomicValue).subtract((DurationValue)atomicValue2);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ g(byte by) {
            this();
        }
    }

    private static final class i
    extends Calculator {
        private i() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((DurationValue)atomicValue).add((DurationValue)atomicValue2);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ i(byte by) {
            this();
        }
    }

    private static final class h
    extends Calculator {
        private h() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((CalendarValue)atomicValue2).add((DurationValue)atomicValue);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType2;
        }

        /* synthetic */ h(byte by) {
            this();
        }
    }

    private static final class b
    extends Calculator {
        private b() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((CalendarValue)atomicValue).add(((DurationValue)atomicValue2).negate());
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private static final class c
    extends Calculator {
        private c() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((CalendarValue)atomicValue).add((DurationValue)atomicValue2);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private static final class a
    extends Calculator {
        private a() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((CalendarValue)atomicValue).subtract((CalendarValue)atomicValue2, xPathContext);
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DAY_TIME_DURATION;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    public static class IntegerIdivInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).idiv((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class IntegerModInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).mod((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class IntegerDivInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).div((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class IntegerTimesInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).times((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class IntegerMinusInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).minus((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class IntegerPlusInteger
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return ((IntegerValue)atomicValue).plus((IntegerValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class DecimalIdivDecimal
    extends Calculator {
        @Override
        public IntegerValue compute(AtomicValue object, AtomicValue object2, XPathContext xPathContext) {
            if (object instanceof IntegerValue && object2 instanceof IntegerValue) {
                return ((IntegerValue)object).idiv((IntegerValue)object2);
            }
            object = ((NumericValue)object).getDecimalValue();
            if (((BigDecimal)(object2 = ((NumericValue)object2).getDecimalValue())).signum() == 0) {
                throw new XPathException("Integer division by zero", "FOAR0001", xPathContext);
            }
            object = ((BigDecimal)object).divideToIntegralValue((BigDecimal)object2).toBigInteger();
            return BigIntegerValue.makeIntegerValue((BigInteger)object);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class DecimalModDecimal
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue object, AtomicValue atomicValue, XPathContext xPathContext) {
            if (object instanceof IntegerValue && atomicValue instanceof IntegerValue) {
                return ((IntegerValue)object).mod((IntegerValue)atomicValue);
            }
            object = ((NumericValue)object).getDecimalValue();
            BigDecimal bigDecimal = ((NumericValue)atomicValue).getDecimalValue();
            try {
                return new BigDecimalValue(((BigDecimal)object).remainder(bigDecimal));
            }
            catch (ArithmeticException arithmeticException) {
                if (((NumericValue)atomicValue).compareTo(0L) == 0) {
                    throw new XPathException("Decimal modulo zero", "FOAR0001", xPathContext);
                }
                throw arithmeticException;
            }
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class DecimalDivDecimal
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return DecimalDivDecimal.decimalDivide((NumericValue)atomicValue, (NumericValue)atomicValue2);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class DecimalTimesDecimal
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).times((IntegerValue)atomicValue2);
            }
            return new BigDecimalValue(((NumericValue)atomicValue).getDecimalValue().multiply(((NumericValue)atomicValue2).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class DecimalMinusDecimal
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).minus((IntegerValue)atomicValue2);
            }
            return new BigDecimalValue(((NumericValue)atomicValue).getDecimalValue().subtract(((NumericValue)atomicValue2).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class DecimalPlusDecimal
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).plus((IntegerValue)atomicValue2);
            }
            return new BigDecimalValue(((NumericValue)atomicValue).getDecimalValue().add(((NumericValue)atomicValue2).getDecimalValue()));
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class FloatIdivFloat
    extends Calculator {
        @Override
        public IntegerValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            float f2 = ((NumericValue)atomicValue).getFloatValue();
            float f3 = ((NumericValue)atomicValue2).getFloatValue();
            if ((double)f3 == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", xPathContext);
            }
            if (Float.isNaN(f2) || Float.isInfinite(f2)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", xPathContext);
            }
            if (Float.isNaN(f3)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", xPathContext);
            }
            if (Float.isInfinite(f2 /= f3)) {
                return new DecimalIdivDecimal().compute(new BigDecimalValue(((NumericValue)atomicValue).getDecimalValue()), new BigDecimalValue(((NumericValue)atomicValue2).getDecimalValue()), xPathContext);
            }
            return (IntegerValue)((Converter)Converter.FloatToInteger.INSTANCE).convert(new FloatValue(f2)).asAtomic();
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FloatModFloat
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() % ((NumericValue)atomicValue2).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FloatDivFloat
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() / ((NumericValue)atomicValue2).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FloatTimesFloat
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() * ((NumericValue)atomicValue2).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FloatMinusFloat
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() - ((NumericValue)atomicValue2).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FloatPlusFloat
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() + ((NumericValue)atomicValue2).getFloatValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static final class d
    extends Calculator {
        private d() {
        }

        @Override
        public final AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            double d2 = ((NumericValue)atomicValue).getDoubleValue();
            double d3 = ((NumericValue)atomicValue2).getDoubleValue();
            if (d3 == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", xPathContext);
            }
            if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", xPathContext);
            }
            if (Double.isNaN(d3)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", xPathContext);
            }
            return IntegerValue.makeIntegerValue(new DoubleValue(d2 / d3)).asAtomic();
        }

        @Override
        public final AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    public static class DoubleModDouble
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() % ((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class DoubleDivDouble
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() / ((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class DoubleTimesDouble
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() * ((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class DoubleMinusDouble
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() - ((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class DoublePlusDouble
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() + ((NumericValue)atomicValue2).getDoubleValue());
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class AnyIdivAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyIdivAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 5, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for idiv operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    public static class AnyModAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyModAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 4, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for mod operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    public static class AnyDivAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyDivAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 3, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for div operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    public static class AnyTimesAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyTimesAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 2, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for * operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    public static class AnyMinusAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyMinusAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 1, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for - operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    public static class AnyPlusAny
    extends Calculator {
        @Override
        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) {
            Calculator calculator = AnyPlusAny.getCalculator(atomicValue.getItemType().getPrimitiveType(), atomicValue2.getItemType().getPrimitiveType(), 0, true);
            if (calculator == null) {
                throw new XPathException("Unsuitable types for + operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        @Override
        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }
}

