/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int a = -1;
    private RoleDiagnostic b;

    private CardinalityChecker(Expression expression, int n2, RoleDiagnostic roleDiagnostic) {
        super(expression);
        this.a = n2;
        this.b = roleDiagnostic;
    }

    public static Expression makeCardinalityChecker(Expression expression, int n2, RoleDiagnostic roleDiagnostic) {
        UnaryExpression unaryExpression;
        if (expression instanceof Literal && Cardinality.subsumes(n2, SequenceTool.getCardinality(((Literal)expression).getValue()))) {
            return expression;
        }
        if (expression instanceof Atomizer && !Cardinality.allowsMany(n2)) {
            Expression expression2 = ((Atomizer)expression).getBaseExpression();
            unaryExpression = new SingletonAtomizer(expression2, roleDiagnostic, Cardinality.allowsZero(n2));
        } else {
            unaryExpression = new CardinalityChecker(expression, n2, roleDiagnostic);
        }
        ExpressionTool.copyLocationInfo(expression, unaryExpression);
        return unaryExpression;
    }

    @Override
    protected final OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public final int getRequiredCardinality() {
        return this.a;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        object = this.getBaseExpression();
        if (this.a == 57344 || Cardinality.subsumes(this.a, ((Expression)object).getCardinality())) {
            return object;
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getOperand().optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object = this.getBaseExpression();
        if (this.a == 57344 || Cardinality.subsumes(this.a, ((Expression)object).getCardinality())) {
            return object;
        }
        if ((((Expression)object).getCardinality() & this.a) == 0) {
            object = new XPathException("The " + this.b.getMessage() + " does not satisfy the cardinality constraints", this.b.getErrorCode());
            ((XPathException)object).setLocation(this.getLocation());
            ((XPathException)object).setIsTypeError(this.b.isTypeError());
            throw object;
        }
        if (object instanceof ItemChecker) {
            object = (ItemChecker)object;
            object2 = ((UnaryExpression)object).getBaseExpression();
            this.setBaseExpression((Expression)object2);
            ((UnaryExpression)object).setBaseExpression(this);
            ((Expression)object).setParentExpression(null);
            return object;
        }
        return this;
    }

    public final void setErrorCode(String string) {
        this.b.setErrorCode(string);
    }

    public final RoleDiagnostic getRoleLocator() {
        return this.b;
    }

    @Override
    public final int getImplementationMethod() {
        int n2 = 22;
        if (!Cardinality.allowsMany(this.a)) {
            n2 = 23;
        }
        return n2;
    }

    @Override
    public final IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate(xPathContext);
        if ((sequenceIterator.getProperties() & 2) != 0) {
            int n2 = ((LastPositionFinder)((Object)sequenceIterator)).getLength();
            if (n2 == 0 && !Cardinality.allowsZero(this.a)) {
                this.typeError("An empty sequence is not allowed as the " + this.b.getMessage(), this.b.getErrorCode(), xPathContext);
            } else if (n2 == 1 && this.a == 8192) {
                this.typeError("The only value allowed for the " + this.b.getMessage() + " is an empty sequence", this.b.getErrorCode(), xPathContext);
            } else if (n2 > 1 && !Cardinality.allowsMany(this.a)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.b.getMessage() + CardinalityChecker.depictSequenceStart(sequenceIterator, 2), this.b.getErrorCode(), xPathContext);
            }
            return sequenceIterator;
        }
        return new CardinalityCheckingIterator(sequenceIterator, this.a, this.b, this.getLocation());
    }

    public static String depictSequenceStart(SequenceIterator sequenceIterator, int n2) {
        try {
            Object t2;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            int n3 = 0;
            fastStringBuffer.append(" (");
            while ((t2 = sequenceIterator.next()) != null) {
                if (n3++ > 0) {
                    fastStringBuffer.append(", ");
                }
                if (n3 > n2) {
                    fastStringBuffer.append("...) ");
                    return fastStringBuffer.toString();
                }
                fastStringBuffer.append(Err.depict(t2));
            }
            fastStringBuffer.append(") ");
            return fastStringBuffer.toString();
        }
        catch (XPathException xPathException) {
            return "";
        }
    }

    public final Item evaluateItem(XPathContext xPathContext) {
        Object object = this.getBaseExpression().iterate(xPathContext);
        Object obj = object.next();
        if (obj == null) {
            if (!Cardinality.allowsZero(this.a)) {
                this.typeError("An empty sequence is not allowed as the " + this.b.getMessage(), this.b.getErrorCode(), xPathContext);
            }
            return null;
        }
        if (this.a == 8192) {
            this.typeError("An empty sequence is required as the " + this.b.getMessage(), this.b.getErrorCode(), xPathContext);
            return null;
        }
        if ((object = object.next()) != null) {
            object = new Item[]{obj, object};
            this.typeError("A sequence of more than one item is not allowed as the " + this.b.getMessage() + CardinalityChecker.depictSequenceStart(new ArrayIterator(object), 2), this.b.getErrorCode(), xPathContext);
            return null;
        }
        return obj;
    }

    @Override
    public final void process(XPathContext object) {
        Expression expression = this.getBaseExpression();
        ItemType itemType = Type.ITEM_TYPE;
        if (expression instanceof ItemChecker) {
            itemType = ((ItemChecker)expression).getRequiredType();
            expression = ((ItemChecker)expression).getBaseExpression();
        }
        if ((expression.getImplementationMethod() & 4) != 0 && !(itemType instanceof DocumentNodeTest)) {
            Receiver receiver = object.getReceiver();
            TypeCheckingFilter typeCheckingFilter = new TypeCheckingFilter(receiver);
            typeCheckingFilter.setRequiredType(itemType, this.a, this.b, this.getLocation());
            object.setReceiver(typeCheckingFilter);
            expression.process((XPathContext)object);
            try {
                ((ProxyReceiver)typeCheckingFilter).close();
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw object;
            }
            object.setReceiver(receiver);
            return;
        }
        super.process((XPathContext)object);
    }

    @Override
    public final ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public final int computeCardinality() {
        return this.a;
    }

    @Override
    public final int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new CardinalityChecker(this.getBaseExpression().copy((RebindingMap)object), this.a, this.b);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final boolean equals(Object object) {
        return super.equals(object) && this.a == ((CardinalityChecker)object).a;
    }

    @Override
    public final int computeHashCode() {
        return super.computeHashCode() ^ this.a;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("check", this);
        String string = Cardinality.getOccurrenceIndicator(this.a);
        if (string.equals("")) {
            string = "1";
        }
        expressionPresenter.emitAttribute("card", string);
        expressionPresenter.emitAttribute("diag", this.b.save());
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public final String toString() {
        Expression expression = this.getBaseExpression();
        switch (this.a) {
            case 16384: {
                return "exactly-one(" + expression + ")";
            }
            case 24576: {
                return "zero-or-one(" + expression + ")";
            }
            case 49152: {
                return "one-or-more(" + expression + ")";
            }
            case 8192: {
                return "must-be-empty(" + expression + ")";
            }
        }
        return "check(" + expression + ")";
    }

    @Override
    public final String getExpressionName() {
        return "CheckCardinality";
    }

    @Override
    public final String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    @Override
    public final String getStreamerName() {
        return "CardinalityChecker";
    }

    @Override
    public final void setLocation(Location location) {
        super.setLocation(location);
    }
}

