/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.Cardinality;

public final class CardinalityCheckingIterator<T extends Item<?>>
implements SequenceIterator<T> {
    private SequenceIterator<T> a;
    private Location b;
    private T c = null;
    private T d = null;
    private int e = 0;

    public CardinalityCheckingIterator(SequenceIterator<T> itemArray, int n2, RoleDiagnostic roleDiagnostic, Location location) {
        this.a = itemArray;
        this.b = location;
        this.c = itemArray.next();
        if (this.c == null) {
            if (!Cardinality.allowsZero(n2)) {
                this.a("An empty sequence is not allowed as the " + roleDiagnostic.getMessage(), roleDiagnostic.getErrorCode());
                return;
            }
        } else {
            if (n2 == 8192) {
                this.a("The only value allowed for the " + roleDiagnostic.getMessage() + " is an empty sequence", roleDiagnostic.getErrorCode());
            }
            this.d = itemArray.next();
            if (this.d != null && !Cardinality.allowsMany(n2)) {
                itemArray = new Item[]{this.c, this.d};
                this.a("A sequence of more than one item is not allowed as the " + roleDiagnostic.getMessage() + CardinalityChecker.depictSequenceStart(new ArrayIterator(itemArray), 2), roleDiagnostic.getErrorCode());
            }
        }
    }

    @Override
    public final T next() {
        if (this.e < 2) {
            if (this.e == 0) {
                T t2 = this.c;
                this.e = this.c == null ? -1 : 1;
                return t2;
            }
            if (this.e == 1) {
                T t3 = this.d;
                this.e = this.d == null ? -1 : 2;
                return t3;
            }
            return null;
        }
        T t4 = this.a.next();
        this.e = t4 == null ? -1 : ++this.e;
        return t4;
    }

    @Override
    public final void close() {
        this.a.close();
    }

    @Override
    public final int getProperties() {
        return 0;
    }

    private void a(String object, String string) {
        object = new XPathException((String)object, string, this.b);
        ((XPathException)object).setIsTypeError(!string.startsWith("FORG"));
        throw object;
    }
}

