/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.String_1;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class CastExpression
extends CastingExpression
implements Callable {
    public CastExpression(Expression expression, AtomicType atomicType, boolean bl2) {
        super(expression, atomicType, bl2);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        Object object3 = ((ExpressionVisitor)object).getConfiguration();
        TypeHierarchy typeHierarchy = ((Configuration)object3).getTypeHierarchy();
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(2, "cast as", 0);
        object3 = ((Configuration)object3).getTypeChecker(false);
        object3 = ((TypeChecker)object3).staticTypeCheck(this.getBaseExpression(), (SequenceType)object2, roleDiagnostic, (ExpressionVisitor)object);
        this.setBaseExpression((Expression)object3);
        object2 = ((Expression)object3).getItemType();
        if (object2 instanceof ErrorType) {
            if (this.allowsEmpty()) {
                return Literal.makeEmptySequence();
            }
            object2 = new XPathException("Cast does not allow an empty sequence as input");
            ((XPathException)object2).setErrorCode("XPTY0004");
            ((XPathException)object2).setLocation(this.getLocation());
            ((XPathException)object2).setIsTypeError(true);
            throw object2;
        }
        int n2 = typeHierarchy.relationship((ItemType)(object2 = (PlainType)object2), this.getTargetType());
        if (n2 == 0) {
            return object3;
        }
        if (n2 == 2) {
            this.converter = new Converter.UpCastingConverter(this.getTargetType());
        } else {
            object = ((ExpressionVisitor)object).getConfiguration().getConversionRules();
            if (object2.isAtomicType() && object2 != BuiltInAtomicType.ANY_ATOMIC) {
                this.converter = ((ConversionRules)object).getConverter((AtomicType)object2, this.getTargetType());
                if (this.converter == null) {
                    object = new XPathException("Casting from " + object2 + " to " + this.getTargetType() + " can never succeed");
                    ((XPathException)object).setErrorCode("XPTY0004");
                    ((XPathException)object).setLocation(this.getLocation());
                    ((XPathException)object).setIsTypeError(true);
                    throw object;
                }
                if (this.getTargetType().isNamespaceSensitive()) {
                    this.converter = this.converter.setNamespaceResolver(this.getRetainedStaticContext());
                }
            }
        }
        if (object3 instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Object object2;
        Object object3;
        TypeHierarchy typeHierarchy = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        Object object4 = super.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        if (object4 != this) {
            return object4;
        }
        object4 = this.getBaseExpression();
        if (this.getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
            if (((Expression)object4).isCallOn(String_1.class)) {
                object3 = ((SystemFunctionCall)object4).getArg(0);
                if (((Expression)object3).getItemType() instanceof AtomicType && ((Expression)object3).getCardinality() == 16384) {
                    object4 = object3;
                }
            } else if (object4 instanceof CastExpression) {
                if (((CastExpression)object4).getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return object4;
                }
                if (((CastExpression)object4).getTargetType() == BuiltInAtomicType.STRING) {
                    ((CastExpression)object4).setTargetType(BuiltInAtomicType.UNTYPED_ATOMIC);
                    return object4;
                }
            } else if (object4 instanceof AtomicSequenceConverter) {
                if (((Expression)object4).getItemType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return object4;
                }
                if (((Expression)object4).getItemType() == BuiltInAtomicType.STRING) {
                    AtomicSequenceConverter atomicSequenceConverter = (AtomicSequenceConverter)object4;
                    AtomicSequenceConverter atomicSequenceConverter2 = new AtomicSequenceConverter(atomicSequenceConverter.getBaseExpression(), BuiltInAtomicType.UNTYPED_ATOMIC);
                    return ((Expression)atomicSequenceConverter2).typeCheck((ExpressionVisitor)object, contextItemStaticInfo).optimize((ExpressionVisitor)object, contextItemStaticInfo);
                }
            }
        }
        if (((Expression)object4).isCallOn(String_1.class) && (object2 = ((Expression)(object3 = ((SystemFunctionCall)object4).getArg(0))).getItemType()) instanceof AtomicType && ((Expression)object3).getCardinality() == 16384 && typeHierarchy.isSubType((ItemType)object2, this.getTargetType())) {
            return object3;
        }
        if (object4 instanceof CastExpression && (typeHierarchy.isSubType((ItemType)(object3 = ((CastExpression)object4).getTargetType()), BuiltInAtomicType.STRING) || typeHierarchy.isSubType((ItemType)object3, BuiltInAtomicType.UNTYPED_ATOMIC)) && (object = ((Expression)(object2 = ((CastExpression)object4).getBaseExpression())).getItemType()) instanceof AtomicType && ((Expression)object2).getCardinality() == 16384 && typeHierarchy.isSubType((ItemType)object, this.getTargetType())) {
            return object2;
        }
        if (object4 instanceof AtomicSequenceConverter && (typeHierarchy.isSubType((ItemType)(object3 = ((Expression)object4).getItemType()), BuiltInAtomicType.STRING) || typeHierarchy.isSubType((ItemType)object3, BuiltInAtomicType.UNTYPED_ATOMIC)) && (object = ((Expression)(object2 = ((AtomicSequenceConverter)object4).getBaseExpression())).getItemType()) instanceof AtomicType && ((Expression)object2).getCardinality() == 16384 && typeHierarchy.isSubType((ItemType)object, this.getTargetType())) {
            return object2;
        }
        if (!Cardinality.allowsZero(((Expression)object4).getCardinality())) {
            this.setAllowEmpty(false);
            this.resetLocalStaticProperties();
        }
        if (object4 instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    protected Expression preEvaluate() {
        GroundedValue<?> groundedValue = ((Literal)this.getBaseExpression()).getValue();
        if (groundedValue instanceof AtomicValue && this.converter != null) {
            if ((groundedValue = this.converter.convert((AtomicValue)groundedValue)) instanceof ValidationFailure) {
                String string = ((ValidationFailure)((Object)(groundedValue = (ValidationFailure)((Object)groundedValue)))).getErrorCode();
                if (string == null) {
                    string = "FORG0001";
                }
                throw new XPathException(((ValidationFailure)((Object)groundedValue)).getMessage(), string, this.getLocation());
            }
            return Literal.makeLiteral((AtomicValue)groundedValue, this);
        }
        if (groundedValue.getLength() == 0) {
            if (this.allowsEmpty()) {
                return this.getBaseExpression();
            }
            groundedValue = new XPathException("Cast can never succeed: the operand must not be an empty sequence", "XPTY0004", this.getLocation());
            ((XPathException)((Object)groundedValue)).setIsTypeError(true);
            throw groundedValue;
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        if (this.allowsEmpty() && Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public ItemType getItemType() {
        return this.getTargetType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return this.getTargetType().getUType();
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        if (this.getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
            n2 &= 0xFBFFFFFF;
        }
        return n2;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.converter == Converter.BooleanToInteger.INSTANCE) {
            return new IntegerValue[]{Int64Value.ZERO, Int64Value.PLUS_ONE};
        }
        return null;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new CastExpression(this.getBaseExpression().copy((RebindingMap)object), this.getTargetType(), this.allowsEmpty());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((CastingExpression)object).converter = this.converter;
        ((Expression)object).setRetainedStaticContext(this.getRetainedStaticContext());
        ((CastingExpression)object).setOperandIsStringLiteral(this.isOperandIsStringLiteral());
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
        object = this.a((AtomicValue)sequenceArray[0].head(), (XPathContext)object);
        if (object == null) {
            return EmptySequence.getInstance();
        }
        return object;
    }

    private AtomicValue a(AtomicValue object, XPathContext xPathContext) {
        if (object == null) {
            if (this.allowsEmpty()) {
                return null;
            }
            XPathException xPathException = new XPathException("Cast does not allow an empty sequence");
            xPathException.setXPathContext(xPathContext);
            xPathException.setLocation(this.getLocation());
            xPathException.setErrorCode("XPTY0004");
            throw xPathException;
        }
        Object object2 = this.converter;
        if (object2 == null) {
            object2 = xPathContext.getConfiguration().getConversionRules();
            if ((object2 = ((ConversionRules)object2).getConverter(((AtomicValue)object).getPrimitiveType(), this.getTargetType())) == null) {
                object = new XPathException("Casting from " + ((AtomicValue)object).getPrimitiveType() + " to " + this.getTargetType() + " is not permitted");
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).setLocation(this.getLocation());
                ((XPathException)object).setErrorCode("XPTY0004");
                throw object;
            }
            if (this.getTargetType().isNamespaceSensitive()) {
                object2 = ((Converter)object2).setNamespaceResolver(this.getRetainedStaticContext());
            }
        }
        if ((object2 = ((Converter)object2).convert((AtomicValue)object)) instanceof ValidationFailure) {
            object = (ValidationFailure)object2;
            object = ((ValidationFailure)object).makeException();
            ((XPathException)object).maybeSetErrorCode("FORG0001");
            ((XPathException)object).maybeSetLocation(this.getLocation());
            throw object;
        }
        return (AtomicValue)object2;
    }

    public AtomicValue evaluateItem(XPathContext xPathContext) {
        try {
            AtomicValue atomicValue = (AtomicValue)this.getBaseExpression().evaluateItem(xPathContext);
            return this.a(atomicValue, xPathContext);
        }
        catch (ClassCastException classCastException) {
            ClassCastException classCastException2 = classCastException;
            classCastException.printStackTrace();
            throw classCastException2;
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CastExpression && this.getBaseExpression().isEqual(((CastExpression)object).getBaseExpression()) && this.getTargetType() == ((CastExpression)object).getTargetType() && this.allowsEmpty() == ((CastExpression)object).allowsEmpty();
    }

    @Override
    public int computeHashCode() {
        return super.computeHashCode() ^ this.getTargetType().hashCode();
    }

    @Override
    public String toString() {
        return this.getTargetType().getEQName() + "(" + this.getBaseExpression().toString() + ")";
    }

    @Override
    public String toShortString() {
        return this.getTargetType().getDisplayName() + "(" + this.getBaseExpression().toShortString() + ")";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("cast", this);
        expressionPresenter.emitAttribute("as", this.getTargetType().toExportString());
        expressionPresenter.emitAttribute("emptiable", this.allowsEmpty() ? "1" : "0");
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String getExpressionName() {
        return "cast";
    }
}

