/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public final class CastableExpression
extends CastingExpression {
    public CastableExpression(Expression expression, AtomicType atomicType, boolean bl2) {
        super(expression, atomicType, bl2);
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.getOperand().typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = this.getBaseExpression();
        ItemType itemType = ((Expression)object).getItemType();
        itemType = itemType.getAtomizedItemType().getPrimitiveItemType();
        if (itemType != BuiltInAtomicType.ANY_ATOMIC) {
            this.converter = expressionVisitor.getConfiguration().getConversionRules().getConverter((AtomicType)itemType, this.getTargetType());
            if (this.converter == null) {
                if (!this.allowsEmpty() || !Cardinality.allowsZero(((Expression)object).getCardinality())) {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
            } else {
                if (this.getTargetPrimitiveType().isNamespaceSensitive()) {
                    this.converter = this.converter.setNamespaceResolver(this.getRetainedStaticContext());
                }
                if (this.converter.isAlwaysSuccessful() && !this.allowsEmpty() && ((Expression)object).getCardinality() == 16384) {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
            }
        }
        this.setBaseExpression((Expression)object);
        if (object instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    protected final Expression preEvaluate() {
        GroundedValue<?> groundedValue = ((Literal)this.getBaseExpression()).getValue();
        if (groundedValue instanceof AtomicValue && this.converter != null) {
            return Literal.makeLiteral(BooleanValue.get(!((groundedValue = this.converter.convert((AtomicValue)groundedValue)) instanceof ValidationFailure)), this);
        }
        int n2 = groundedValue.getLength();
        if (n2 == 0) {
            return Literal.makeLiteral(BooleanValue.get(this.allowsEmpty()), this);
        }
        if (n2 > 1) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren(expressionVisitor, contextItemStaticInfo);
        if (this.getBaseExpression() instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    @Override
    public final int getImplementationMethod() {
        return 1;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof CastableExpression && this.getBaseExpression().isEqual(((CastableExpression)object).getBaseExpression()) && this.getTargetType() == ((CastableExpression)object).getTargetType() && this.allowsEmpty() == ((CastableExpression)object).allowsEmpty();
    }

    @Override
    public final int computeHashCode() {
        return super.computeHashCode() ^ 0x5555;
    }

    @Override
    public final ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new CastableExpression(this.getBaseExpression().copy((RebindingMap)object), this.getTargetType(), this.allowsEmpty());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((Expression)object).setRetainedStaticContext(this.getRetainedStaticContext());
        ((CastingExpression)object).converter = this.converter;
        return object;
    }

    public final BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext xPathContext) {
        Object object;
        int n2 = 0;
        SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate(xPathContext);
        while ((object = sequenceIterator.next()) != null) {
            if (object instanceof NodeInfo) {
                int n3 = SequenceTool.getLength(object = object.atomize());
                if ((n2 += n3) > 1) {
                    return false;
                }
                if (n3 == 0 || this.a((AtomicValue)(object = object.head()), this.getTargetType(), xPathContext)) continue;
                return false;
            }
            if (object instanceof AtomicValue) {
                object = (AtomicValue)object;
                if (++n2 > 1) {
                    return false;
                }
                if (this.a((AtomicValue)object, this.getTargetType(), xPathContext)) continue;
                return false;
            }
            throw new XPathException("Input to cast cannot be atomized", "XPTY0004");
        }
        return n2 != 0 || this.allowsEmpty();
    }

    private boolean a(AtomicValue atomicValue, AtomicType atomicType, XPathContext xPathContext) {
        Converter converter = this.converter;
        if (converter == null) {
            converter = xPathContext.getConfiguration().getConversionRules().getConverter(atomicValue.getPrimitiveType(), atomicType);
            if (converter == null) {
                return false;
            }
            if (converter.isAlwaysSuccessful()) {
                return true;
            }
            if (this.getTargetType().isNamespaceSensitive()) {
                converter = converter.setNamespaceResolver(this.getRetainedStaticContext());
            }
        }
        return !(converter.convert(atomicValue) instanceof ValidationFailure);
    }

    @Override
    public final String getExpressionName() {
        return "castable";
    }

    @Override
    public final String toString() {
        return this.getBaseExpression().toString() + " castable as " + this.getTargetType().getEQName();
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("castable", this);
        expressionPresenter.emitAttribute("as", this.getTargetType().toExportString());
        expressionPresenter.emitAttribute("emptiable", this.allowsEmpty() ? "1" : "0");
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

