/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class CompareToIntegerConstant
extends UnaryExpression
implements ComparisonExpression {
    private long a;
    private int b;

    public CompareToIntegerConstant(Expression expression, int n2, long l2) {
        super(expression);
        this.b = n2;
        this.a = l2;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    @Override
    public Expression getLhsExpression() {
        return this.getBaseExpression();
    }

    @Override
    public Operand getLhs() {
        return this.getOperand();
    }

    @Override
    public Expression getRhsExpression() {
        return new Literal(new Int64Value(this.a));
    }

    @Override
    public Operand getRhs() {
        CompareToIntegerConstant compareToIntegerConstant = this;
        return new Operand(compareToIntegerConstant, compareToIntegerConstant.getRhsExpression(), OperandRole.SINGLE_ATOMIC);
    }

    public long getComparand() {
        return this.a;
    }

    public int getComparisonOperator() {
        return this.b;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public int computeSpecialProperties() {
        return 0x800000;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new CompareToIntegerConstant(this.getLhsExpression().copy((RebindingMap)object), this.b, this.a);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CompareToIntegerConstant && ((CompareToIntegerConstant)object).getLhsExpression().isEqual(this.getLhsExpression()) && ((CompareToIntegerConstant)object).a == this.a && ((CompareToIntegerConstant)object).b == this.b;
    }

    @Override
    public int computeHashCode() {
        return -2090134880 + this.getLhsExpression().hashCode() ^ (int)this.a;
    }

    public BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext object) {
        object = (NumericValue)this.getLhsExpression().evaluateItem((XPathContext)object);
        if (((AtomicValue)object).isNaN()) {
            return this.b == 51;
        }
        int n2 = ((NumericValue)object).compareTo(this.a);
        switch (this.b) {
            case 50: {
                return n2 == 0;
            }
            case 51: {
                return n2 != 0;
            }
            case 52: {
                return n2 > 0;
            }
            case 53: {
                return n2 < 0;
            }
            case 54: {
                return n2 >= 0;
            }
            case 55: {
                return n2 <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.b);
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().optimize(expressionVisitor, contextItemStaticInfo);
        if (this.getLhsExpression() instanceof Literal) {
            return Literal.makeLiteral(BooleanValue.get(((Expression)this).effectiveBooleanValue(null)), this);
        }
        return this;
    }

    @Override
    public String getExpressionName() {
        return "compareToInt";
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("compareToInt", this);
        expressionPresenter.emitAttribute("op", Token.tokens[this.b]);
        expressionPresenter.emitAttribute("val", "" + this.a);
        this.getLhsExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getLhsExpression()) + " " + Token.tokens[this.b] + " " + this.a;
    }

    @Override
    public String toShortString() {
        return this.getLhsExpression().toShortString() + " " + Token.tokens[this.b] + " " + this.a;
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return DoubleSortComparer.getInstance();
    }

    @Override
    public int getSingletonOperator() {
        return this.b;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }
}

