/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.om.Function;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.tree.util.FastStringBuffer;

public class Component {
    protected Actor actor;
    private Visibility a;
    private List<ComponentBinding> b = new ArrayList<ComponentBinding>();
    private StylesheetPackage c;
    private StylesheetPackage d;
    private VisibilityProvenance e;
    private Component f;

    private Component() {
    }

    public static Component makeComponent(Actor actor, Visibility visibility, VisibilityProvenance visibilityProvenance, StylesheetPackage stylesheetPackage, StylesheetPackage stylesheetPackage2) {
        Component component = actor instanceof Mode ? new M() : new Component();
        component.actor = actor;
        component.a = visibility;
        component.e = visibilityProvenance;
        component.c = stylesheetPackage;
        component.d = stylesheetPackage2;
        return component;
    }

    public List<ComponentBinding> getComponentBindings() {
        return this.b;
    }

    public void setComponentBindings(List<ComponentBinding> list) {
        this.b = list;
    }

    public void setVisibility(Visibility visibility, VisibilityProvenance visibilityProvenance) {
        this.a = visibility;
        this.e = visibilityProvenance;
    }

    public Visibility getVisibility() {
        return this.a;
    }

    public VisibilityProvenance getVisibilityProvenance() {
        return this.e;
    }

    public boolean isHiddenAbstractComponent() {
        return this.a == Visibility.HIDDEN && this.f != null && this.f.getVisibility() == Visibility.ABSTRACT;
    }

    public Actor getActor() {
        return this.actor;
    }

    public int getComponentKind() {
        if (this.actor instanceof NamedTemplate) {
            return 200;
        }
        if (this.actor instanceof GlobalVariable) {
            return 206;
        }
        if (this.actor instanceof Function) {
            return 158;
        }
        if (this.actor instanceof AttributeSet) {
            return 136;
        }
        if (this.actor instanceof Mode) {
            return 174;
        }
        return -1;
    }

    public StylesheetPackage getDeclaringPackage() {
        return this.d;
    }

    public StylesheetPackage getContainingPackage() {
        return this.c;
    }

    public Component getBaseComponent() {
        return this.f;
    }

    public void setBaseComponent(Component component) {
        this.f = component;
    }

    public void export(ExpressionPresenter expressionPresenter, Map<Component, Integer> map, Map<StylesheetPackage, Integer> map2) {
        expressionPresenter.startElement("co");
        int n2 = Component.a(this, map);
        expressionPresenter.emitAttribute("id", "" + n2);
        if (this.getVisibilityProvenance() != VisibilityProvenance.DEFAULTED) {
            expressionPresenter.emitAttribute("vis", this.getVisibility().toString());
        }
        String string = this.listComponentReferences(map);
        expressionPresenter.emitAttribute("binds", string);
        if (this.f != null && this.getActor() == this.f.getActor()) {
            int n3 = Component.a(this.f, map);
            expressionPresenter.emitAttribute("base", "" + n3);
            expressionPresenter.emitAttribute("dpack", "" + map2.get(this.d));
        } else {
            this.actor.export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    public String listComponentReferences(Map<Component, Integer> map) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(128);
        for (ComponentBinding object : this.getComponentBindings()) {
            Component component = object.getTarget();
            int n2 = Component.a(component, map);
            if (fastStringBuffer.length() != 0) {
                fastStringBuffer.append(" ");
            }
            fastStringBuffer.append("" + n2);
        }
        return fastStringBuffer.toString();
    }

    private static int a(Component component, Map<Component, Integer> map) {
        Integer n2 = map.get(component);
        if (n2 == null) {
            n2 = map.size();
            map.put(component, n2);
        }
        return n2;
    }

    /* synthetic */ Component(byte by) {
        this();
    }

    public static class M
    extends Component {
        public M() {
            super((byte)0);
        }

        @Override
        public Mode getActor() {
            return (Mode)super.getActor();
        }

        public void setActor(Mode mode) {
            this.actor = mode;
        }
    }
}

