/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;

public class ConsumingOperand
extends UnaryExpression {
    public ConsumingOperand(Expression expression) {
        super(expression);
    }

    @Override
    protected OperandRole getOperandRole() {
        return new OperandRole(0, OperandUsage.ABSORPTION);
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.getBaseExpression().getIntrinsicDependencies();
    }

    @Override
    public int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ConsumingOperand(this.getBaseExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 3;
    }

    public Sequence<?> evaluate(XPathContext xPathContext) {
        if (xPathContext.getStackFrame().holdsDynamicValue()) {
            return xPathContext.getStackFrame().popDynamicValue();
        }
        return new LazySequence(this.getBaseExpression().iterate(xPathContext));
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return this.evaluate(xPathContext).iterate();
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.evaluate(xPathContext).head();
    }

    @Override
    public String getExpressionName() {
        return "consume";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("consume", this);
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return "consume(" + this.getBaseExpression().toString() + ")";
    }

    @Override
    public String toShortString() {
        return "consume(" + this.getBaseExpression().toShortString() + ")";
    }
}

