/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public class ContextItemExpression
extends Expression {
    private ContextItemStaticInfo a = ContextItemStaticInfo.DEFAULT;
    private String b = "XPDY0002";

    @Override
    public String getExpressionName() {
        return "dot";
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ContextItemExpression();
        new ContextItemExpression().a = this.a;
        ((ContextItemExpression)object).setErrorCodeForUndefinedContext(this.b);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    public void setErrorCodeForUndefinedContext(String string) {
        this.b = string;
    }

    public String getErrorCodeForUndefinedContext() {
        return this.b;
    }

    public void setStaticInfo(ContextItemStaticInfo contextItemStaticInfo) {
        this.a = contextItemStaticInfo;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if (contextItemStaticInfo.getItemType() == ErrorType.getInstance()) {
            ((ExpressionVisitor)object).issueWarning("Evaluation will always fail: there is no context item", this.getLocation());
            object = new ErrorExpression("There is no context item", this.getErrorCodeForUndefinedContext(), true);
            ((ErrorExpression)object).setOriginalExpression(this);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        this.a = contextItemStaticInfo;
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if (contextItemStaticInfo == null) {
            object = new XPathException("The context item is undefined at this point");
            ((XPathException)object).setErrorCode(this.getErrorCodeForUndefinedContext());
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return this.a.getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return uType;
    }

    public boolean isContextPossiblyUndefined() {
        return this.a.isPossiblyAbsent();
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x800000 | 0x10000;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ContextItemExpression;
    }

    @Override
    public int computeHashCode() {
        return "ContextItemExpression".hashCode();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        return pathMapNodeSet;
    }

    @Override
    public boolean isSubtreeExpression() {
        return true;
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        return AnchorPattern.getInstance();
    }

    @Override
    public String getStreamerName() {
        return "ContextItemExpr";
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Item<?> item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), xPathContext);
        }
        return SingletonIterator.makeIterator(item);
    }

    public Item evaluateItem(XPathContext xPathContext) {
        Item<?> item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), xPathContext);
        }
        return item;
    }

    @Override
    public String toString() {
        return ".";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("dot", this);
        ItemType itemType = ((Expression)this).getItemType();
        if (itemType != AnyItemType.getInstance()) {
            expressionPresenter.emitAttribute("type", itemType.toExportString());
        }
        if (this.a.isPossiblyAbsent()) {
            expressionPresenter.emitAttribute("flags", "a");
        }
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        return ".";
    }
}

