/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;

public class EquivalenceComparer
extends GenericAtomicComparer {
    protected EquivalenceComparer(StringCollator stringCollator, XPathContext xPathContext) {
        super(stringCollator, xPathContext);
    }

    @Override
    public EquivalenceComparer provideContext(XPathContext xPathContext) {
        return new EquivalenceComparer(this.getStringCollator(), xPathContext);
    }

    @Override
    public boolean comparesEqual(AtomicValue object, AtomicValue object2) {
        if (object instanceof StringValue && object2 instanceof StringValue) {
            return this.getStringCollator().comparesEqual(((AtomicValue)object).getStringValue(), ((AtomicValue)object2).getStringValue());
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.getContext().getImplicitTimezone()) == 0;
        }
        if (((AtomicValue)object).isNaN() && ((AtomicValue)object2).isNaN()) {
            return true;
        }
        int n2 = this.getContext().getImplicitTimezone();
        object = ((AtomicValue)object).getXPathComparable(false, this.getStringCollator(), n2);
        object2 = ((AtomicValue)object2).getXPathComparable(false, this.getStringCollator(), n2);
        return object.equals(object2);
    }

    @Override
    public String save() {
        return "EQUIV|" + super.save();
    }
}

