/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.EquivalenceComparer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class EquivalenceComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer a;
    private boolean b = false;

    public EquivalenceComparison(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        StaticContext staticContext = ((ExpressionVisitor)object).getStaticContext();
        Object object3 = staticContext.getDefaultCollationName();
        Object object4 = ((ExpressionVisitor)object).getConfiguration();
        object3 = ((Configuration)object4).getCollation((String)object3);
        if (object3 == null) {
            object3 = CodepointCollator.getInstance();
        }
        this.a = new EquivalenceComparer((StringCollator)object3, ((Configuration)object4).getConversionContext());
        object3 = this.getLhsExpression();
        Object object5 = this.getRhsExpression();
        this.getLhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        this.getRhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        EquivalenceComparison equivalenceComparison = this;
        equivalenceComparison.setLhsExpression(equivalenceComparison.getLhsExpression().unordered(false, false));
        EquivalenceComparison equivalenceComparison2 = this;
        equivalenceComparison2.setRhsExpression(equivalenceComparison2.getRhsExpression().unordered(false, false));
        object2 = SequenceType.OPTIONAL_ATOMIC;
        object4 = ((Configuration)object4).getTypeChecker(false);
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(1, "eq", 0);
        this.setLhsExpression(((TypeChecker)object4).staticTypeCheck(this.getLhsExpression(), (SequenceType)object2, roleDiagnostic, (ExpressionVisitor)object));
        roleDiagnostic = new RoleDiagnostic(1, "eq", 1);
        this.setRhsExpression(((TypeChecker)object4).staticTypeCheck(this.getRhsExpression(), (SequenceType)object2, roleDiagnostic, (ExpressionVisitor)object));
        if (this.getLhsExpression() != object3) {
            EquivalenceComparison equivalenceComparison3 = this;
            equivalenceComparison3.adoptChildExpression(equivalenceComparison3.getLhsExpression());
        }
        if (this.getRhsExpression() != object5) {
            EquivalenceComparison equivalenceComparison4 = this;
            equivalenceComparison4.adoptChildExpression(equivalenceComparison4.getRhsExpression());
        }
        object2 = this.getLhsExpression().getItemType();
        object3 = this.getRhsExpression().getItemType();
        if (object2 instanceof ErrorType) {
            object2 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (object3 instanceof ErrorType) {
            object3 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((AtomicType)object2).isExternalType() || ((AtomicType)object3).isExternalType()) {
            object4 = new XPathException("Cannot perform comparisons involving external objects");
            ((XPathException)object4).setIsTypeError(true);
            ((XPathException)object4).setErrorCode("XPTY0004");
            ((XPathException)object4).setLocation(this.getLocation());
            throw object4;
        }
        object4 = (BuiltInAtomicType)object2.getPrimitiveItemType();
        object5 = (BuiltInAtomicType)object3.getPrimitiveItemType();
        if (!(object2.equals(BuiltInAtomicType.ANY_ATOMIC) || object2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || object3.equals(BuiltInAtomicType.ANY_ATOMIC) || object3.equals(BuiltInAtomicType.UNTYPED_ATOMIC))) {
            if (Type.isGuaranteedComparable((BuiltInAtomicType)object4, (BuiltInAtomicType)object5, false)) {
                this.b = true;
            } else if (!Type.isPossiblyComparable((BuiltInAtomicType)object4, (BuiltInAtomicType)object5, false)) {
                staticContext.issueWarning("Cannot compare " + object2.toString() + " to " + object3.toString(), this.getLocation());
            }
        }
        try {
            if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
                object = this.evaluateItem(((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext()).materialize();
                return Literal.makeLiteral(object, this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return this.a;
    }

    @Override
    public int getSingletonOperator() {
        return this.operator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return false;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public boolean isKnownToBeComparable() {
        return this.b;
    }

    public AtomicComparer getComparer() {
        return this.a;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new EquivalenceComparison(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((EquivalenceComparison)object).a = this.a;
        ((EquivalenceComparison)object).b = this.b;
        return object;
    }

    public BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext object) {
        AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem((XPathContext)object);
        AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem((XPathContext)object);
        if (atomicValue == null || atomicValue2 == null) {
            return atomicValue == atomicValue2;
        }
        object = this.a.provideContext((XPathContext)object);
        return (this.b || Type.isGuaranteedComparable(atomicValue.getPrimitiveType(), atomicValue2.getPrimitiveType(), false)) && object.comparesEqual(atomicValue, atomicValue2);
    }

    @Override
    public String getExpressionName() {
        return "equivalent";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
        expressionPresenter.emitAttribute("cardinality", "singleton");
    }
}

