/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ExportAgent;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Locatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SuperId;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;

public abstract class Expression
implements ExportAgent,
Locatable,
IdentityComparable {
    public static final int EVALUATE_METHOD = 1;
    public static final int ITERATE_METHOD = 2;
    public static final int PROCESS_METHOD = 4;
    public static final int WATCH_METHOD = 8;
    public static final int ITEM_FEED_METHOD = 16;
    public static final int EFFECTIVE_BOOLEAN_VALUE = 32;
    public static final int UPDATE_METHOD = 64;
    protected int staticProperties = -1;
    private Location a = ExplicitLocation.UNKNOWN_LOCATION;
    private Expression b;
    private RetainedStaticContext c;
    private int[] d;
    private int e;
    private Map<String, Object> f;
    private double g = -1.0;
    private int h = -1;
    public static final double MAX_COST = 1.0E9;
    public static final IntegerValue UNBOUNDED_LOWER = (IntegerValue)IntegerValue.makeIntegerValue(new DoubleValue(-1.0E100));
    public static final IntegerValue UNBOUNDED_UPPER = (IntegerValue)IntegerValue.makeIntegerValue(new DoubleValue(1.0E100));
    public static final IntegerValue MAX_STRING_LENGTH = Int64Value.makeIntegerValue(Integer.MAX_VALUE);
    public static final IntegerValue MAX_SEQUENCE_LENGTH = Int64Value.makeIntegerValue(Integer.MAX_VALUE);

    public String getExpressionName() {
        return this.getClass().getSimpleName();
    }

    public Iterable<Operand> operands() {
        return Collections.emptyList();
    }

    public Expression getInterpretedExpression() {
        return this;
    }

    public final Iterable<Operand> checkedOperands() {
        Iterable<Operand> iterable = this.operands();
        for (Operand operand : iterable) {
            boolean bl2;
            Expression expression = operand.getChildExpression();
            boolean bl3 = operand.getParentExpression() != this;
            boolean bl4 = bl2 = expression.getParentExpression() != this;
            if (bl3 || bl2) {
                String string = "*** Bad parent pointer found in " + (bl3 ? "operand " : "expression ") + expression.toShortString() + " at " + expression.getLocation().getSystemId() + "#" + expression.getLocation().getLineNumber() + " ***";
                try {
                    Object object = this.getConfiguration();
                    if ((object = object == null ? null : ((Configuration)object).getLogger()) == null) {
                        throw new IllegalStateException(string);
                    }
                    ((Logger)object).warning(string);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(string);
                }
                expression.setParentExpression(this);
            }
            if (expression.getRetainedStaticContext() != null) continue;
            expression.setRetainedStaticContext(this.getRetainedStaticContext());
        }
        return iterable;
    }

    protected List<Operand> operandList(Operand ... operandArray) {
        return Arrays.asList(operandArray);
    }

    protected List<Operand> operandSparseList(Operand ... operandArray) {
        ArrayList<Operand> arrayList = new ArrayList<Operand>();
        for (Operand operand : operandArray) {
            if (operand == null) continue;
            arrayList.add(operand);
        }
        return arrayList;
    }

    public Expression getParentExpression() {
        return this.b;
    }

    public void setParentExpression(Expression expression) {
        this.b = expression;
    }

    public Expression verifyParentPointers() {
        for (Operand operand : this.operands()) {
            Expression expression = operand.getChildExpression().getParentExpression();
            if (expression != this) {
                throw new IllegalStateException("Invalid parent pointer in " + expression.toShortString() + " subexpression " + operand.getChildExpression().toShortString());
            }
            if (operand.getParentExpression() != this) {
                throw new IllegalStateException("Invalid parent pointer in operand object " + expression.toShortString() + " subexpression " + operand.getChildExpression().toShortString());
            }
            if (ExpressionTool.findOperand(expression, operand.getChildExpression()) == null) {
                throw new IllegalStateException("Incorrect parent pointer in " + expression.toShortString() + " subexpression " + operand.getChildExpression().toShortString());
            }
            operand.getChildExpression().verifyParentPointers();
        }
        return this;
    }

    public void restoreParentPointers() {
        for (Operand operand : this.operands()) {
            Expression object = operand.getChildExpression();
            object.setParentExpression(this);
            object.restoreParentPointers();
        }
    }

    public abstract int getImplementationMethod();

    public boolean implementsStaticTypeCheck() {
        return false;
    }

    public boolean hasVariableBinding(Binding binding) {
        return false;
    }

    public boolean isLiftable(boolean bl2) {
        int n2 = this.getSpecialProperties();
        int n3 = this.getDependencies();
        return (n2 & 0x800000) != 0 && (n2 & 0x2000000) == 0 && (n3 & 0x200) == 0 && (n3 & 4) == 0 && (n3 & 8) == 0;
    }

    public Expression getScopingExpression() {
        int n2 = this.getIntrinsicDependencies() & 0x1E;
        if (n2 != 0) {
            if (n2 == 16) {
                return ExpressionTool.getContextDocumentSettingContainer(this);
            }
            return ExpressionTool.getFocusSettingContainer(this);
        }
        return null;
    }

    public boolean isMultiThreaded(Configuration configuration) {
        return false;
    }

    public boolean allowExtractingCommonSubexpressions() {
        return true;
    }

    public Expression simplify() {
        this.simplifyChildren();
        return this;
    }

    protected final void simplifyChildren() {
        for (Operand operand : this.operands()) {
            Expression expression;
            if (operand == null || (expression = operand.getChildExpression()) == null) continue;
            expression = expression.simplify();
            operand.setChildExpression(expression);
        }
    }

    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        if (retainedStaticContext != null) {
            this.c = retainedStaticContext;
            for (Operand operand : this.operands()) {
                Expression expression;
                if (operand == null || (expression = operand.getChildExpression()) == null || expression.c != null) continue;
                expression.setRetainedStaticContext(retainedStaticContext);
            }
        }
    }

    public void setRetainedStaticContextThoroughly(RetainedStaticContext retainedStaticContext) {
        if (retainedStaticContext != null) {
            this.c = retainedStaticContext;
            for (Operand operand : this.operands()) {
                Expression expression;
                if (operand == null || (expression = operand.getChildExpression()) == null) continue;
                if (expression.getLocalRetainedStaticContext() == null) {
                    expression.setRetainedStaticContextThoroughly(retainedStaticContext);
                    continue;
                }
                retainedStaticContext = expression.getLocalRetainedStaticContext();
                for (Object object : expression.operands()) {
                    if ((object = ((Operand)object).getChildExpression()) == null) continue;
                    ((Expression)object).setRetainedStaticContextThoroughly(retainedStaticContext);
                }
            }
        }
    }

    public void setRetainedStaticContextLocally(RetainedStaticContext retainedStaticContext) {
        if (retainedStaticContext != null) {
            this.c = retainedStaticContext;
        }
    }

    public final RetainedStaticContext getRetainedStaticContext() {
        if (this.c == null) {
            Expression expression = this.getParentExpression();
            assert (expression != null);
            this.c = expression.getRetainedStaticContext();
            assert (this.c != null);
        }
        return this.c;
    }

    public RetainedStaticContext getLocalRetainedStaticContext() {
        return this.c;
    }

    public String getStaticBaseURIString() {
        return this.getRetainedStaticContext().getStaticBaseUriString();
    }

    public URI getStaticBaseURI() {
        return this.getRetainedStaticContext().getStaticBaseUri();
    }

    public boolean isCallOn(Class<? extends SystemFunction> clazz) {
        return false;
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    protected final void typeCheckChildren(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        for (Operand operand : this.operands()) {
            operand.typeCheck(expressionVisitor, contextItemStaticInfo);
        }
    }

    public Expression staticTypeCheck(SequenceType sequenceType, boolean bl2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        throw new UnsupportedOperationException("staticTypeCheck");
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        if (expressionVisitor.incrementAndTestDepth()) {
            this.optimizeChildren(expressionVisitor, contextItemStaticInfo);
            expressionVisitor.decrementDepth();
        }
        return this;
    }

    protected final void optimizeChildren(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        for (Operand operand : this.operands()) {
            operand.optimize(expressionVisitor, contextItemStaticInfo);
        }
    }

    public void prepareForStreaming() {
    }

    public double getCost() {
        if (this.g < 0.0) {
            double d2 = this.getNetCost();
            for (Operand operand : this.operands()) {
                if ((d2 += operand.getChildExpression().getCost()) > 1.0E9) break;
            }
            this.g = d2;
        }
        return this.g;
    }

    public int getNetCost() {
        return 1;
    }

    public Expression unordered(boolean bl2, boolean bl3) {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xFFF0000;
    }

    public boolean hasSpecialProperty(int n2) {
        return (this.getSpecialProperties() & n2) != 0;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xE000;
    }

    public abstract ItemType getItemType();

    public SequenceType getStaticType() {
        return SequenceType.makeSequenceType(this.getItemType(), this.getCardinality());
    }

    public UType getStaticUType(UType uType) {
        return UType.ANY;
    }

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x2000FFF;
    }

    public IntegerValue[] getIntegerBounds() {
        return null;
    }

    public void setFlattened(boolean bl2) {
    }

    public void setFiltered(boolean bl2) {
    }

    public Item<?> evaluateItem(XPathContext xPathContext) {
        return this.iterate(xPathContext).next();
    }

    public SequenceIterator<?> iterate(XPathContext object) {
        if ((object = this.evaluateItem((XPathContext)object)) == null) {
            return EmptyIterator.emptyIterator();
        }
        return SingletonIterator.rawIterator(object);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        try {
            return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetFailingExpression(this);
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public CharSequence evaluateAsString(XPathContext object) {
        object = this.evaluateItem((XPathContext)object);
        if ((object = (StringValue)object) == null) {
            return "";
        }
        return ((AtomicValue)object).getStringValueCS();
    }

    public void process(XPathContext xPathContext) {
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            Item<?> item = this.evaluateItem(xPathContext);
            if (item != null) {
                xPathContext.getReceiver().append(item, this.getLocation(), 524288);
            }
            return;
        }
        if ((n2 & 2) != 0) {
            Object object = xPathContext.getReceiver();
            try {
                this.iterate(xPathContext).forEachOrFail(arg_0 -> this.a((Receiver)object, arg_0));
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                ((XPathException)object).maybeSetContext(xPathContext);
                throw object;
            }
        } else {
            throw new AssertionError((Object)("process() is not implemented in the subclass " + this.getClass()));
        }
    }

    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        if (this.isVacuousExpression()) {
            this.iterate(xPathContext).next();
            return;
        }
        throw new UnsupportedOperationException("Expression " + this.getClass() + " is not an updating expression");
    }

    public String toString() {
        int n2;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        Object object = this.getClass().getName();
        while ((n2 = ((String)object).indexOf(46)) >= 0) {
            object = ((String)object).substring(n2 + 1);
        }
        fastStringBuffer.append((String)object);
        n2 = 1;
        for (Operand operand : this.operands()) {
            fastStringBuffer.append(n2 != 0 ? "(" : ", ");
            fastStringBuffer.append(operand.getChildExpression().toString());
            n2 = 0;
        }
        if (n2 == 0) {
            fastStringBuffer.append(")");
        }
        return fastStringBuffer.toString();
    }

    public String toShortString() {
        return this.getExpressionName();
    }

    @Override
    public abstract void export(ExpressionPresenter var1);

    public final void explain(Logger object) {
        object = new ExpressionPresenter(this.getConfiguration(), (Logger)object);
        ExpressionPresenter.ExportOptions exportOptions = new ExpressionPresenter.ExportOptions();
        new ExpressionPresenter.ExportOptions().explaining = true;
        ((ExpressionPresenter)object).setOptions(exportOptions);
        try {
            this.export((ExpressionPresenter)object);
        }
        catch (XPathException xPathException) {
            ((ExpressionPresenter)object).startElement("failure");
            ((ExpressionPresenter)object).emitAttribute("message", xPathException.getMessage());
            ((ExpressionPresenter)object).endElement();
        }
        ((ExpressionPresenter)object).close();
    }

    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
    }

    public void adoptChildExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        expression.setParentExpression(this);
        if (expression.c == null) {
            expression.c = this.c;
        }
        if (this.getLocation() == null || this.getLocation() == ExplicitLocation.UNKNOWN_LOCATION) {
            ExpressionTool.copyLocationInfo(expression, this);
        } else if (expression.getLocation() == null || expression.getLocation() == ExplicitLocation.UNKNOWN_LOCATION) {
            ExpressionTool.copyLocationInfo(this, expression);
        }
        this.resetLocalStaticProperties();
    }

    public void setLocation(Location location) {
        this.a = location;
    }

    @Override
    public final Location getLocation() {
        Expression expression = this;
        for (int i2 = 0; i2 < 10; ++i2) {
            if ((expression.a == null || expression.a == ExplicitLocation.UNKNOWN_LOCATION) && expression.getParentExpression() != null) {
                expression = expression.getParentExpression();
                continue;
            }
            return expression.a;
        }
        return expression.a;
    }

    public Configuration getConfiguration() {
        try {
            return this.getRetainedStaticContext().getConfiguration();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("Internal error: expression " + this.toShortString() + " has no retained static context");
        }
    }

    public PackageData getPackageData() {
        try {
            return this.getRetainedStaticContext().getPackageData();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("Internal error: expression " + this.toShortString() + " has no retained static context");
        }
    }

    public boolean isInstruction() {
        return false;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    public void resetLocalStaticProperties() {
        this.staticProperties = -1;
        this.h = -1;
    }

    public boolean isStaticPropertiesKnown() {
        return this.staticProperties != -1;
    }

    protected abstract int computeCardinality();

    protected int computeSpecialProperties() {
        return 0;
    }

    public int computeDependencies() {
        int n2 = this.getIntrinsicDependencies();
        for (Operand operand : this.operands()) {
            if (operand.hasSameFocus()) {
                n2 |= operand.getChildExpression().getDependencies();
                continue;
            }
            n2 |= operand.getChildExpression().getDependencies() & 0xFFFFFFE1;
        }
        return n2;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public void setStaticProperty(int n2) {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        this.staticProperties |= n2;
    }

    public void checkForUpdatingSubexpressions() {
        Object object = this.operands().iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if ((object2 = ((Operand)object2).getChildExpression()) == null) {
                throw new NullPointerException();
            }
            ((Expression)object2).checkForUpdatingSubexpressions();
            if (!((Expression)object2).isUpdatingExpression()) continue;
            object = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            ((XPathException)object).setLocation(((Expression)object2).getLocation());
            throw object;
        }
    }

    public boolean isUpdatingExpression() {
        for (Operand operand : this.operands()) {
            if (!operand.getChildExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    public boolean isVacuousExpression() {
        return false;
    }

    public abstract Expression copy(RebindingMap var1);

    public void suppressValidation(int n2) {
    }

    public int markTailFunctionCalls(StructuredQName structuredQName, int n2) {
        return 0;
    }

    public Pattern toPattern(Configuration object) {
        object = this.getItemType();
        if ((this.getDependencies() & 0xE) == 0 && (object instanceof NodeTest || this instanceof VariableReference)) {
            return new NodeSetPattern(this);
        }
        if (this.isCallOn(KeyFn.class) || this.isCallOn(SuperId.class)) {
            return new NodeSetPattern(this);
        }
        throw new XPathException("Cannot convert the expression {" + this + "} to a pattern");
    }

    public final synchronized int[] getSlotsUsed() {
        if (this.d != null) {
            return this.d;
        }
        Object object = new IntHashSet(10);
        Expression.a(this, (IntHashSet)object);
        this.d = new int[((IntHashSet)object).size()];
        int n2 = 0;
        object = ((IntHashSet)object).iterator();
        while (object.hasNext()) {
            this.d[n2++] = object.next();
        }
        Arrays.sort(this.d);
        return this.d;
    }

    private static void a(Expression object, IntHashSet intHashSet) {
        if ((object = ((Expression)object).getInterpretedExpression()) instanceof LocalVariableReference) {
            intHashSet.add(((LocalVariableReference)object).getSlotNumber());
            return;
        }
        if (object instanceof SuppliedParameterReference) {
            int n2 = ((SuppliedParameterReference)object).getSlotNumber();
            intHashSet.add(n2);
            return;
        }
        for (Operand operand : ((Expression)object).operands()) {
            Expression.a(operand.getChildExpression(), intHashSet);
        }
    }

    protected void dynamicError(String object, String string, XPathContext xPathContext) {
        object = new XPathException((String)object, string, this.getLocation());
        ((XPathException)object).setXPathContext(xPathContext);
        ((XPathException)object).setFailingExpression(this);
        throw object;
    }

    protected void typeError(String object, String string, XPathContext xPathContext) {
        object = new XPathException((String)object, string, this.getLocation());
        ((XPathException)object).setIsTypeError(true);
        ((XPathException)object).setXPathContext(xPathContext);
        ((XPathException)object).setFailingExpression(this);
        throw object;
    }

    public int getConstructType() {
        return 2098;
    }

    public StructuredQName getObjectName() {
        return null;
    }

    public Object getProperty(String string) {
        if (string.equals("expression")) {
            return this.getLocation();
        }
        return null;
    }

    public Iterator<String> getProperties() {
        return new MonoIterator<String>("expression");
    }

    /*
     * WARNING - void declaration
     */
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2;
        boolean bl2 = ExpressionTool.dependsOnFocus(this);
        if (pathMapNodeSet == null) {
            if (bl2) {
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                ExpressionTool.copyLocationInfo(this, contextItemExpression);
                pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(contextItemExpression));
            }
            pathMapNodeSet2 = pathMapNodeSet;
        } else {
            pathMapNodeSet2 = bl2 ? pathMapNodeSet : null;
        }
        pathMapNodeSet = pathMapNodeSet2;
        PathMap.PathMapNodeSet pathMapNodeSet3 = new PathMap.PathMapNodeSet();
        for (Operand operand : this.operands()) {
            void object;
            OperandUsage operandUsage = operand.getUsage();
            Expression expression = operand.getChildExpression();
            PathMap.PathMapNodeSet pathMapNodeSet4 = expression.addToPathMap(pathMap, pathMapNodeSet);
            if (operandUsage == OperandUsage.NAVIGATION) {
                PathMap.PathMapNodeSet pathMapNodeSet6 = pathMapNodeSet4.createArc((byte)1, NodeKindTest.ELEMENT);
                pathMapNodeSet6 = pathMapNodeSet6.createArc((byte)4, NodeKindTest.ELEMENT);
            }
            pathMapNodeSet3.addNodeSet((PathMap.PathMapNodeSet)object);
        }
        if (this.getItemType() instanceof AtomicType) {
            return null;
        }
        return pathMapNodeSet3;
    }

    public boolean isSubtreeExpression() {
        if (ExpressionTool.dependsOnFocus(this)) {
            if ((this.getIntrinsicDependencies() & 0x1E) != 0) {
                return false;
            }
            for (Operand operand : this.operands()) {
                if (operand.getChildExpression().isSubtreeExpression()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setEvaluationMethod(int n2) {
        this.e = n2;
    }

    public int getEvaluationMethod() {
        return this.e;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public final boolean isEqual(Expression expression) {
        return this == expression || this.hashCode() == expression.hashCode() && this.equals(expression);
    }

    public final int hashCode() {
        if (this.h == -1) {
            this.h = this.computeHashCode();
        }
        return this.h;
    }

    protected boolean hasCompatibleStaticContext(Expression expression) {
        boolean bl2;
        boolean bl3 = (this.getIntrinsicDependencies() & 0x800) != 0;
        boolean bl4 = bl2 = (expression.getIntrinsicDependencies() & 0x800) != 0;
        if (bl3 != bl2) {
            return false;
        }
        if (bl3) {
            return this.getRetainedStaticContext().equals(expression.getRetainedStaticContext());
        }
        return true;
    }

    protected int computeHashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isIdentical(IdentityComparable identityComparable) {
        return this == identityComparable;
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this.getLocation());
    }

    public void setExtraProperty(String string, Object object) {
        if (this.f == null) {
            if (object == null) {
                return;
            }
            this.f = new HashMap<String, Object>(4);
        }
        if (object == null) {
            this.f.remove(string);
            return;
        }
        this.f.put(string, object);
    }

    public Object getExtraProperty(String string) {
        if (this.f == null) {
            return null;
        }
        return this.f.get(string);
    }

    public String getStreamerName() {
        return null;
    }

    private /* synthetic */ void a(Receiver receiver, Item item) {
        receiver.append(item, this.getLocation(), 524288);
    }
}

