/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LastItemExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SubscriptExpression;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.GeneralNodePattern;
import net.sf.saxon.pattern.GeneralPositionalPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SimplePositionalPattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public final class FilterExpression
extends BinaryExpression
implements ContextSwitchingExpression {
    private boolean a;
    private boolean b;
    private boolean c;
    public static final int FILTERED = 10000;
    public static final OperandRole FILTER_PREDICATE = new OperandRole(6, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);

    public FilterExpression(Expression expression, Expression expression2) {
        super(expression, 4, expression2);
        expression.setFiltered(true);
    }

    @Override
    protected final OperandRole getOperandRole(int n2) {
        if (n2 == 0) {
            return OperandRole.SAME_FOCUS_ACTION;
        }
        return FILTER_PREDICATE;
    }

    public final Expression getBase() {
        return this.getLhsExpression();
    }

    public final void setBase(Expression expression) {
        this.setLhsExpression(expression);
    }

    public final Expression getFilter() {
        return this.getRhsExpression();
    }

    public final void setFilter(Expression expression) {
        this.setRhsExpression(expression);
    }

    @Override
    public final String getExpressionName() {
        return "filter";
    }

    @Override
    public final ItemType getItemType() {
        if (this.getFilter() instanceof InstanceOfExpression && ((InstanceOfExpression)this.getFilter()).getBaseExpression() instanceof ContextItemExpression) {
            return ((InstanceOfExpression)this.getFilter()).getRequiredItemType();
        }
        return this.getBase().getItemType();
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return this.getBase().getStaticUType(uType);
    }

    @Override
    public final Expression getSelectExpression() {
        return this.getBase();
    }

    public final boolean isFilterIsPositional() {
        return this.a;
    }

    @Override
    public final Expression getActionExpression() {
        return this.getFilter();
    }

    public final boolean isPositional(TypeHierarchy typeHierarchy) {
        return FilterExpression.isPositionalFilter(this.getFilter(), typeHierarchy);
    }

    public final boolean isSimpleBooleanFilter() {
        return this.b;
    }

    public final boolean isIndependentFilter() {
        return this.c;
    }

    @Override
    public final Expression simplify() {
        FilterExpression filterExpression = this;
        filterExpression.setBase(filterExpression.getBase().simplify());
        FilterExpression filterExpression2 = this;
        filterExpression2.setFilter(filterExpression2.getFilter().simplify());
        if (Literal.isEmptySequence(this.getBase())) {
            return this.getBase();
        }
        if (this.getFilter() instanceof Literal && !(((Literal)this.getFilter()).getValue() instanceof NumericValue)) {
            try {
                if (this.getFilter().effectiveBooleanValue(new EarlyEvaluationContext(this.getConfiguration()))) {
                    return this.getBase();
                }
                return Literal.makeEmptySequence();
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw xPathException2;
            }
        }
        if (this.getFilter().isCallOn(PositionAndLast.Last.class)) {
            this.setFilter(new IsLastExpression(true));
            FilterExpression filterExpression3 = this;
            filterExpression3.adoptChildExpression(filterExpression3.getFilter());
        }
        return this;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Configuration configuration = ((ExpressionVisitor)object).getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        this.getLhs().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        this.getBase().setFiltered(true);
        if (Literal.isEmptySequence(this.getBase())) {
            return this.getBase();
        }
        contextItemStaticInfo = configuration.makeContextItemStaticInfo(this.getSelectExpression().getItemType(), false);
        contextItemStaticInfo.setContextSettingExpression(this.getBase());
        this.getRhs().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        object = ExpressionTool.unsortedIfHomogeneous(this.getFilter(), ((ExpressionVisitor)object).isOptimizeForStreaming());
        if (object != this.getFilter()) {
            this.setFilter((Expression)object);
        }
        if (Literal.isConstantOne(this.getFilter())) {
            object = FirstItemExpression.makeFirstItemExpression(this.getBase());
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        this.a = FilterExpression.isPositionalFilter(this.getFilter(), typeHierarchy);
        this.b = this.getFilter().getCardinality() == 16384 && this.getFilter().getItemType().equals(BuiltInAtomicType.BOOLEAN);
        this.c = (this.getFilter().getDependencies() & 0x1E) == 0;
        ExpressionTool.resetStaticProperties(this);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        Optimizer optimizer;
        Object object4;
        block39: {
            block46: {
                Expression expression;
                boolean bl3;
                block42: {
                    int n2;
                    int n3;
                    Expression expression2;
                    block44: {
                        block45: {
                            Expression expression3;
                            block43: {
                                block41: {
                                    block40: {
                                        while (true) {
                                            Object object5;
                                            boolean bl4;
                                            int n4;
                                            object4 = expressionVisitor.getConfiguration();
                                            optimizer = expressionVisitor.obtainOptimizer();
                                            bl2 = ((Configuration)object4).getBooleanProperty(Feature.TRACE_OPTIMIZER_DECISIONS);
                                            object3 = ((Configuration)object4).getTypeHierarchy();
                                            ((BinaryExpression)object5).getLhs().optimize(expressionVisitor, contextItemStaticInfo);
                                            ((FilterExpression)object5).getBase().setFiltered(true);
                                            Object object6 = ((Configuration)object4).makeContextItemStaticInfo(((FilterExpression)object5).getSelectExpression().getItemType(), false);
                                            ((ContextItemStaticInfo)object6).setContextSettingExpression(((FilterExpression)object5).getBase());
                                            ((BinaryExpression)object5).getRhs().optimize(expressionVisitor, (ContextItemStaticInfo)object6);
                                            Object object7 = ExpressionTool.unsortedIfHomogeneous(((FilterExpression)object5).getFilter(), expressionVisitor.isOptimizeForStreaming());
                                            if (object7 != ((FilterExpression)object5).getFilter()) {
                                                ((FilterExpression)object5).setFilter((Expression)object7);
                                            }
                                            if (((FilterExpression)object5).getFilter() instanceof IsLastExpression && ((IsLastExpression)((FilterExpression)object5).getFilter()).getCondition() && ((FilterExpression)object5).getBase() instanceof AxisExpression && ((AxisExpression)((FilterExpression)object5).getBase()).getAxis() == 3) {
                                                object7 = ((AxisExpression)((FilterExpression)object5).getBase()).getNodeTest();
                                                object7 = new AxisExpression(7, (NodeTest)object7);
                                                ((FilterExpression)object5).setFilter(SystemFunction.makeCall("empty", ((Expression)object5).getRetainedStaticContext(), new Expression[]{object7}));
                                                if (bl2) {
                                                    Optimizer.trace((Configuration)object4, "Replaced [last()] predicate by test for following-sibling", (Expression)object5);
                                                }
                                            }
                                            if (!((TypeHierarchy)object3).isSubType((ItemType)(object7 = ((FilterExpression)object5).getFilter().getItemType()), BuiltInAtomicType.BOOLEAN) && ((TypeHierarchy)object3).relationship((ItemType)object7, NumericType.getInstance()) == 4) {
                                                object7 = SystemFunction.makeCall("boolean", ((Expression)object5).getRetainedStaticContext(), ((FilterExpression)object5).getFilter());
                                                ((FilterExpression)object5).setFilter(((Expression)object7).optimize(expressionVisitor, (ContextItemStaticInfo)object6));
                                            }
                                            if (((FilterExpression)object5).getFilter() instanceof Literal && ((Literal)((FilterExpression)object5).getFilter()).getValue() instanceof BooleanValue) {
                                                if (((BooleanValue)((Literal)((FilterExpression)object5).getFilter()).getValue()).getBooleanValue()) {
                                                    if (bl2) {
                                                        optimizer.trace("Redundant filter removed", ((FilterExpression)object5).getBase());
                                                    }
                                                    return ((FilterExpression)object5).getBase();
                                                }
                                                object7 = Literal.makeEmptySequence();
                                                ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object7);
                                                if (bl2) {
                                                    optimizer.trace("Filter expression eliminated because predicate is always false", (Expression)object7);
                                                }
                                                return object7;
                                            }
                                            ((FilterExpression)object5).a = FilterExpression.isPositionalFilter(((FilterExpression)object5).getFilter(), (TypeHierarchy)object3);
                                            boolean bl5 = ((FilterExpression)object5).b = ((FilterExpression)object5).getFilter().getCardinality() == 16384 && ((FilterExpression)object5).getFilter().getItemType().equals(BuiltInAtomicType.BOOLEAN);
                                            if (!((FilterExpression)object5).a && !expressionVisitor.isOptimizeForStreaming() && (n4 = optimizer.isIndexableFilter(((FilterExpression)object5).getFilter())) != 0 && (object3 = optimizer.tryIndexedFilter((FilterExpression)object5, expressionVisitor, n4 > 0, bl4 = contextItemStaticInfo != null && contextItemStaticInfo.getItemType() != ErrorType.getInstance() && ((TypeHierarchy)object3).isSubType(contextItemStaticInfo.getItemType(), NodeKindTest.DOCUMENT))) != object5) {
                                                return ((Expression)object3).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
                                            }
                                            if (!((FilterExpression)object5).a || !(((FilterExpression)object5).getFilter() instanceof BooleanExpression) || ((BooleanExpression)((FilterExpression)object5).getFilter()).operator != 10) break;
                                            object7 = (BooleanExpression)((FilterExpression)object5).getFilter();
                                            if (FilterExpression.b(((BinaryExpression)object7).getLhsExpression()) && !FilterExpression.b(((BinaryExpression)object7).getRhsExpression())) {
                                                object4 = FilterExpression.a(((BinaryExpression)object7).getLhsExpression());
                                                object3 = FilterExpression.a(((BinaryExpression)object7).getRhsExpression());
                                                object6 = new FilterExpression(((FilterExpression)object5).getBase(), (Expression)object4);
                                                ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object6);
                                                object4 = new FilterExpression((Expression)object6, (Expression)object3);
                                                ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object4);
                                                if (bl2) {
                                                    optimizer.trace("Composite filter replaced by nested filter expressions", (Expression)object4);
                                                }
                                                object5 = object4;
                                                continue;
                                            }
                                            if (!FilterExpression.b(((BinaryExpression)object7).getRhsExpression()) || FilterExpression.b(((BinaryExpression)object7).getLhsExpression())) break;
                                            object4 = FilterExpression.a(((BinaryExpression)object7).getLhsExpression());
                                            object3 = FilterExpression.a(((BinaryExpression)object7).getRhsExpression());
                                            object6 = new FilterExpression(((FilterExpression)object5).getBase(), (Expression)object3);
                                            ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object6);
                                            object4 = new FilterExpression((Expression)object6, (Expression)object4);
                                            ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object4);
                                            if (bl2) {
                                                optimizer.trace("Composite filter replaced by nested filter expressions", (Expression)object4);
                                            }
                                            object5 = object4;
                                        }
                                        if (((FilterExpression)object5).getFilter() instanceof IsLastExpression && ((IsLastExpression)((FilterExpression)object5).getFilter()).getCondition()) {
                                            if (!(((FilterExpression)object5).getBase() instanceof Literal)) {
                                                return new LastItemExpression(((FilterExpression)object5).getBase());
                                            }
                                            ((FilterExpression)object5).setFilter(Literal.makeLiteral(new Int64Value(((Literal)((FilterExpression)object5).getBase()).getValue().getLength()), (Expression)object5));
                                        }
                                        bl3 = bl2;
                                        object3 = expressionVisitor;
                                        object4 = object5;
                                        object3 = ((ExpressionVisitor)object3).getConfiguration();
                                        object2 = ((Configuration)object3).getTypeHierarchy();
                                        if (!(((FilterExpression)object4).getFilter() instanceof Literal)) break block40;
                                        GroundedValue<?> groundedValue = ((Literal)((FilterExpression)object4).getFilter()).getValue();
                                        if (groundedValue instanceof NumericValue) {
                                            void var10_24;
                                            int n5 = ((NumericValue)groundedValue).asSubscript();
                                            if (n5 != -1) {
                                                if (n5 == 1) {
                                                    Expression expression4 = FirstItemExpression.makeFirstItemExpression(((FilterExpression)object4).getBase());
                                                } else {
                                                    SubscriptExpression subscriptExpression = new SubscriptExpression(((FilterExpression)object4).getBase(), ((FilterExpression)object4).getFilter());
                                                }
                                            } else {
                                                Literal literal = Literal.makeEmptySequence();
                                            }
                                            if (bl3) {
                                                Optimizer.trace((Configuration)object3, "Rewriting numeric filter expression with constant subscript", (Expression)var10_24);
                                            }
                                            object = var10_24;
                                            break block39;
                                        } else {
                                            Expression expression5;
                                            Expression expression6 = expression5 = ExpressionTool.effectiveBooleanValue(groundedValue.iterate()) ? ((FilterExpression)object4).getBase() : Literal.makeEmptySequence();
                                            if (bl3) {
                                                Optimizer.trace((Configuration)object3, "Rewriting boolean filter expression with constant subscript", expression5);
                                            }
                                            object = expression5;
                                        }
                                        break block39;
                                    }
                                    if (!((TypeHierarchy)object2).isSubType(((FilterExpression)object4).getFilter().getItemType(), NumericType.getInstance()) || Cardinality.allowsMany(((FilterExpression)object4).getFilter().getCardinality()) || (((FilterExpression)object4).getFilter().getDependencies() & 0x1E) != 0) break block41;
                                    SubscriptExpression subscriptExpression = new SubscriptExpression(((FilterExpression)object4).getBase(), ((FilterExpression)object4).getFilter());
                                    if (bl3) {
                                        Optimizer.trace((Configuration)object3, "Rewriting numeric filter expression with focus-independent subscript", subscriptExpression);
                                    }
                                    object = subscriptExpression;
                                    break block39;
                                }
                                if (!(((FilterExpression)object4).getFilter() instanceof ComparisonExpression)) break block42;
                                expression2 = ((ComparisonExpression)((Object)((FilterExpression)object4).getFilter())).getLhsExpression();
                                expression3 = ((ComparisonExpression)((Object)((FilterExpression)object4).getFilter())).getRhsExpression();
                                n3 = ((ComparisonExpression)((Object)((FilterExpression)object4).getFilter())).getSingletonOperator();
                                if (!expression2.isCallOn(PositionAndLast.Position.class) || !((TypeHierarchy)object2).isSubType(expression3.getItemType(), NumericType.getInstance())) break block43;
                                expression2 = expression3;
                                break block44;
                            }
                            if (expression3.isCallOn(PositionAndLast.Position.class) && ((TypeHierarchy)object2).isSubType(expression2.getItemType(), NumericType.getInstance())) break block45;
                            object = null;
                            break block39;
                        }
                        n3 = Token.inverse(n3);
                    }
                    if (ExpressionTool.dependsOnFocus(expression2) || Cardinality.allowsMany(n2 = expression2.getCardinality())) break block46;
                    if (Cardinality.allowsZero(n2)) {
                        LetExpression letExpression = new LetExpression();
                        letExpression.setRequiredType(SequenceType.makeSequenceType(expression2.getItemType(), n2));
                        letExpression.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + letExpression.hashCode()));
                        letExpression.setSequence(expression2);
                        expression2 = new LocalVariableReference(letExpression);
                        LocalVariableReference localVariableReference = new LocalVariableReference(letExpression);
                        Expression expression7 = SystemFunction.makeCall("exists", ((Expression)object4).getRetainedStaticContext(), localVariableReference);
                        object3 = FilterExpression.a(((FilterExpression)object4).getBase(), expression2, n3, (TypeHierarchy)object2);
                        if (object3 == null) {
                            object = object4;
                            break block39;
                        } else {
                            object4 = Choose.makeConditional(expression7, (Expression)object3);
                            letExpression.setAction((Expression)object4);
                            object = letExpression;
                        }
                        break block39;
                    } else {
                        object = FilterExpression.a(((FilterExpression)object4).getBase(), expression2, n3, (TypeHierarchy)object2);
                    }
                    break block39;
                }
                if (!(((FilterExpression)object4).getFilter() instanceof IntegerRangeTest) || !(expression = ((IntegerRangeTest)((FilterExpression)object4).getFilter()).getValue()).isCallOn(PositionAndLast.class)) break block46;
                Expression expression8 = ((IntegerRangeTest)((FilterExpression)object4).getFilter()).getMin();
                Expression expression9 = ((IntegerRangeTest)((FilterExpression)object4).getFilter()).getMax();
                if (ExpressionTool.dependsOnFocus(expression8)) break block46;
                if (ExpressionTool.dependsOnFocus(expression9)) {
                    if (expression9.isCallOn(PositionAndLast.Last.class)) {
                        expression = SystemFunction.makeCall("subsequence", ((Expression)object4).getRetainedStaticContext(), ((FilterExpression)object4).getBase(), expression8);
                        if (bl3) {
                            Optimizer.trace(object3, "Rewriting numeric range filter expression using subsequence()", expression);
                        }
                        object = expression;
                        break block39;
                    } else {
                        object = null;
                    }
                    break block39;
                } else {
                    expression = new LetExpression();
                    ((Assignation)expression).setRequiredType(SequenceType.SINGLE_INTEGER);
                    ((Assignation)expression).setVariableQName(new StructuredQName("nn", "http://saxon.sf.net/", "nn" + expression.hashCode()));
                    ((Assignation)expression).setSequence(expression8);
                    LocalVariableReference localVariableReference = new LocalVariableReference((LocalBinding)((Object)expression));
                    LocalVariableReference localVariableReference2 = new LocalVariableReference((LocalBinding)((Object)expression));
                    ArithmeticExpression arithmeticExpression = new ArithmeticExpression(localVariableReference2, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), (Expression)object4));
                    ArithmeticExpression arithmeticExpression2 = new ArithmeticExpression(expression9, 16, arithmeticExpression);
                    Expression expression10 = SystemFunction.makeCall("subsequence", ((Expression)object4).getRetainedStaticContext(), ((FilterExpression)object4).getBase(), localVariableReference, arithmeticExpression2);
                    ((Assignation)expression).setAction(expression10);
                    if (bl3) {
                        Optimizer.trace((Configuration)object3, "Rewriting numeric range filter expression using subsequence()", expression10);
                    }
                    object = expression;
                }
                break block39;
            }
            object = object2 = null;
        }
        if (object != null) {
            if (bl2) {
                ((Expression)object2).setRetainedStaticContext(((Expression)object5).getRetainedStaticContext());
                optimizer.trace("Rewrote Filter Expression as:", (Expression)object2);
            }
            ExpressionTool.copyLocationInfo((Expression)object5, (Expression)object2);
            return ((Expression)object2).simplify().typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (!((FilterExpression)object5).a && ((BinaryExpression)object5).getLhsExpression() instanceof FilterExpression && !((FilterExpression)((BinaryExpression)object5).getLhsExpression()).isFilterIsPositional() && (object4 = optimizer.reorderPredicates((FilterExpression)object5, expressionVisitor, contextItemStaticInfo)) != object5) {
            return object4;
        }
        object4 = object5.a(expressionVisitor);
        if (object4 != null) {
            object3 = object4.materialize();
            return Literal.makeLiteral(object3, (Expression)object5);
        }
        return object5;
    }

    @Override
    public final double getCost() {
        return Math.max(this.getLhsExpression().getCost() + 5.0 * this.getRhsExpression().getCost(), 1.0E9);
    }

    @Override
    public final int getImplementationMethod() {
        return 2;
    }

    @Override
    public final IntegerValue[] getIntegerBounds() {
        return this.getBase().getIntegerBounds();
    }

    private Sequence<?> a(ExpressionVisitor object) {
        try {
            if (this.getBase() instanceof Literal && !ExpressionTool.refersToVariableOrFunction(this.getFilter()) && (this.getFilter().getDependencies() & 0xFFFFFFE1) == 0) {
                object = ((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext();
                return ((Expression)this).iterate((XPathContext)object).materialize();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @Override
    public final PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = this.getBase().addToPathMap(pathMap, pathMapNodeSet);
        this.getFilter().addToPathMap(pathMap, pathMapNodeSet);
        return pathMapNodeSet;
    }

    private static Expression a(Expression expression) {
        if (expression.getItemType().getPrimitiveType() == 514) {
            return expression;
        }
        return SystemFunction.makeCall("boolean", expression.getRetainedStaticContext(), expression);
    }

    private static Expression a(Expression expression, Expression expression2, int n2, TypeHierarchy object) {
        if (((TypeHierarchy)object).isSubType(expression2.getItemType(), BuiltInAtomicType.INTEGER)) {
            switch (n2) {
                case 50: {
                    if (Literal.isConstantOne(expression2)) {
                        return FirstItemExpression.makeFirstItemExpression(expression);
                    }
                    if (expression2 instanceof Literal && ((IntegerValue)((Literal)expression2).getValue()).asBigInteger().compareTo(BigInteger.ZERO) <= 0) {
                        return Literal.makeEmptySequence();
                    }
                    return new SubscriptExpression(expression, expression2);
                }
                case 53: {
                    Expression[] expressionArray = new Expression[3];
                    Expression[] expressionArray2 = expressionArray;
                    expressionArray[0] = expression;
                    expressionArray2[1] = Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression);
                    if (Literal.isAtomic(expression2)) {
                        long l2 = ((NumericValue)((Literal)expression2).getValue()).longValue();
                        expressionArray2[2] = Literal.makeLiteral(Int64Value.makeIntegerValue(l2 - 1L), expression);
                    } else {
                        ArithmeticExpression arithmeticExpression = new ArithmeticExpression(expression2, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression));
                        arithmeticExpression.setCalculator(Calculator.getCalculator(533, 533, 1, true));
                        expressionArray2[2] = arithmeticExpression;
                    }
                    return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expressionArray2);
                }
                case 55: {
                    Expression[] expressionArray = new Expression[3];
                    Expression[] expressionArray3 = expressionArray;
                    expressionArray[0] = expression;
                    expressionArray3[1] = Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression);
                    expressionArray3[2] = expression2;
                    return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expressionArray3);
                }
                case 51: {
                    return SystemFunction.makeCall("remove", expression.getRetainedStaticContext(), expression, expression2);
                }
                case 52: {
                    Expression[] expressionArray = new Expression[2];
                    Expression[] expressionArray4 = expressionArray;
                    expressionArray[0] = expression;
                    if (Literal.isAtomic(expression2)) {
                        long l3 = ((NumericValue)((Literal)expression2).getValue()).longValue();
                        expressionArray4[1] = Literal.makeLiteral(Int64Value.makeIntegerValue(l3 + 1L), expression);
                    } else {
                        expressionArray4[1] = new ArithmeticExpression(expression2, 15, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression));
                    }
                    return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expressionArray4);
                }
                case 54: {
                    return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expression, expression2);
                }
            }
            throw new IllegalArgumentException("operator");
        }
        switch (n2) {
            case 50: {
                return new SubscriptExpression(expression, expression2);
            }
            case 53: {
                LetExpression letExpression = new LetExpression();
                letExpression.setRequiredType(SequenceType.makeSequenceType(expression2.getItemType(), 16384));
                letExpression.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + letExpression.hashCode()));
                letExpression.setSequence(expression2);
                LocalVariableReference localVariableReference = new LocalVariableReference(letExpression);
                LocalVariableReference localVariableReference2 = new LocalVariableReference(letExpression);
                expression2 = new LocalVariableReference(letExpression);
                object = VendorFunctionSetHE.getInstance().makeFunction("is-whole-number", 1).makeFunctionCall(localVariableReference);
                ArithmeticExpression arithmeticExpression = new ArithmeticExpression(localVariableReference2, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression));
                expression2 = SystemFunction.makeCall("floor", expression.getRetainedStaticContext(), expression2);
                expression2 = Choose.makeConditional((Expression)object, arithmeticExpression, expression2);
                expression = SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expression, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression), expression2);
                letExpression.setAction(expression);
                return letExpression;
            }
            case 55: {
                Expression expression3 = SystemFunction.makeCall("floor", expression.getRetainedStaticContext(), expression2);
                return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expression, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression), expression3);
            }
            case 51: {
                LetExpression letExpression = new LetExpression();
                ExpressionTool.copyLocationInfo(expression, letExpression);
                letExpression.setRequiredType(SequenceType.makeSequenceType(expression2.getItemType(), 16384));
                letExpression.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + letExpression.hashCode()));
                letExpression.setSequence(expression2);
                LocalVariableReference localVariableReference = new LocalVariableReference(letExpression);
                LocalVariableReference localVariableReference3 = new LocalVariableReference(letExpression);
                expression2 = VendorFunctionSetHE.getInstance().makeFunction("is-whole-number", 1).makeFunctionCall(localVariableReference);
                ExpressionTool.copyLocationInfo(expression, expression2);
                object = new CastExpression(localVariableReference3, BuiltInAtomicType.INTEGER, false);
                ExpressionTool.copyLocationInfo(expression, (Expression)object);
                Expression expression4 = Choose.makeConditional(expression2, (Expression)object, Literal.makeLiteral(Int64Value.makeIntegerValue(0L), expression));
                expression2 = SystemFunction.makeCall("remove", expression.getRetainedStaticContext(), expression, expression4);
                letExpression.setAction(expression2);
                return letExpression;
            }
            case 52: {
                LetExpression letExpression = new LetExpression();
                letExpression.setRequiredType(SequenceType.makeSequenceType(expression2.getItemType(), 16384));
                letExpression.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + letExpression.hashCode()));
                letExpression.setSequence(expression2);
                LocalVariableReference localVariableReference = new LocalVariableReference(letExpression);
                LocalVariableReference localVariableReference4 = new LocalVariableReference(letExpression);
                expression2 = new LocalVariableReference(letExpression);
                object = VendorFunctionSetHE.getInstance().makeFunction("is-whole-number", 1).makeFunctionCall(localVariableReference);
                ArithmeticExpression arithmeticExpression = new ArithmeticExpression(localVariableReference4, 15, Literal.makeLiteral(Int64Value.makeIntegerValue(1L), expression));
                expression2 = SystemFunction.makeCall("ceiling", expression.getRetainedStaticContext(), expression2);
                expression2 = Choose.makeConditional((Expression)object, arithmeticExpression, expression2);
                expression = SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expression, expression2);
                letExpression.setAction(expression);
                return letExpression;
            }
            case 54: {
                Expression expression5 = SystemFunction.makeCall("ceiling", expression.getRetainedStaticContext(), expression2);
                return SystemFunction.makeCall("subsequence", expression.getRetainedStaticContext(), expression, expression5);
            }
        }
        throw new IllegalArgumentException("operator");
    }

    @Override
    public final Expression unordered(boolean bl2, boolean bl3) {
        if (!this.a) {
            FilterExpression filterExpression = this;
            filterExpression.setBase(filterExpression.getBase().unordered(bl2, bl3));
        }
        return this;
    }

    public static boolean isPositionalFilter(Expression expression, TypeHierarchy typeHierarchy) {
        ItemType itemType = expression.getItemType();
        if (itemType.equals(BuiltInAtomicType.BOOLEAN)) {
            return FilterExpression.b(expression);
        }
        return itemType.equals(BuiltInAtomicType.ANY_ATOMIC) || itemType instanceof AnyItemType || itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(NumericType.getInstance()) || typeHierarchy.isSubType(itemType, NumericType.getInstance()) || FilterExpression.b(expression);
    }

    private static boolean b(Expression expression) {
        return (expression.getDependencies() & 0xC) != 0;
    }

    @Override
    public final int computeCardinality() {
        if (this.getFilter() instanceof Literal && ((Literal)this.getFilter()).getValue() instanceof NumericValue) {
            if (((NumericValue)((Literal)this.getFilter()).getValue()).compareTo(1L) == 0 && !Cardinality.allowsZero(this.getBase().getCardinality())) {
                return 16384;
            }
            return 24576;
        }
        if (this.c) {
            ItemType itemType = this.getFilter().getItemType().getPrimitiveItemType();
            if (itemType == BuiltInAtomicType.INTEGER || itemType == BuiltInAtomicType.DOUBLE || itemType == BuiltInAtomicType.DECIMAL || itemType == BuiltInAtomicType.FLOAT) {
                return 24576;
            }
            if (this.getFilter() instanceof ArithmeticExpression) {
                return 24576;
            }
        }
        if (this.getFilter() instanceof IsLastExpression && ((IsLastExpression)this.getFilter()).getCondition()) {
            return 24576;
        }
        if (!Cardinality.allowsMany(this.getBase().getCardinality())) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public final int computeSpecialProperties() {
        return this.getBase().getSpecialProperties();
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof FilterExpression) {
            object = (FilterExpression)object;
            return this.getBase().isEqual(((FilterExpression)object).getBase()) && this.getFilter().isEqual(((FilterExpression)object).getFilter());
        }
        return false;
    }

    @Override
    public final int computeHashCode() {
        return "FilterExpression".hashCode() + this.getBase().hashCode() + this.getFilter().hashCode();
    }

    @Override
    public final Pattern toPattern(Configuration object) {
        Expression expression = this.getSelectExpression();
        Expression expression2 = this.getFilter();
        TypeHierarchy typeHierarchy = ((Configuration)object).getTypeHierarchy();
        object = expression.toPattern((Configuration)object);
        if (!this.isPositional(typeHierarchy)) {
            return new BasePatternWithPredicate((Pattern)object, expression2);
        }
        if (object instanceof NodeTestPattern && ((Expression)object).getItemType() instanceof NodeTest && this.a && expression instanceof AxisExpression && ((AxisExpression)expression).getAxis() == 3 && (expression2.getDependencies() & 8) == 0) {
            if (expression2 instanceof Literal && ((Literal)expression2).getValue() instanceof IntegerValue) {
                return new SimplePositionalPattern((NodeTest)((Expression)object).getItemType(), (int)((IntegerValue)((Literal)expression2).getValue()).longValue());
            }
            return new GeneralPositionalPattern((NodeTest)((Expression)object).getItemType(), expression2);
        }
        if (expression.getItemType() instanceof NodeTest) {
            return new GeneralNodePattern(this, (NodeTest)expression.getItemType());
        }
        throw new XPathException("The filtered expression in an XSLT 2.0 pattern must be a simple step");
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext sequence) {
        SequenceIterator<?> sequenceIterator;
        if (this.c) {
            try {
                sequenceIterator = this.getFilter().iterate((XPathContext)((Object)sequence));
                Object obj = sequenceIterator.next();
                if (obj == null) {
                    return EmptyIterator.emptyIterator();
                }
                if (obj instanceof NumericValue) {
                    if (sequenceIterator.next() == null) {
                        int n2 = ((NumericValue)obj).asSubscript();
                        if (n2 != -1) {
                            if (this.getBase() instanceof VariableReference) {
                                sequence = ((VariableReference)this.getBase()).evaluateVariable((XPathContext)((Object)sequence));
                                if (sequence instanceof MemoClosure) {
                                    if ((sequence = ((MemoClosure)sequence).itemAt(n2 - 1)) == null) {
                                        return EmptyIterator.emptyIterator();
                                    }
                                    return sequence.iterate();
                                }
                                if ((sequence = sequence.materialize().itemAt(n2 - 1)) == null) {
                                    return EmptyIterator.emptyIterator();
                                }
                                return sequence.iterate();
                            }
                            if (this.getBase() instanceof Literal) {
                                sequence = ((Literal)this.getBase()).getValue().itemAt(n2 - 1);
                                if (sequence == null) {
                                    return EmptyIterator.emptyIterator();
                                }
                                return sequence.iterate();
                            }
                            sequence = this.getBase().iterate((XPathContext)((Object)sequence));
                            int n3 = n2;
                            return SubsequenceIterator.make(sequence, n3, n3);
                        }
                        return EmptyIterator.emptyIterator();
                    }
                } else {
                    boolean bl2 = false;
                    if (obj instanceof NodeInfo) {
                        bl2 = true;
                    } else if (obj instanceof BooleanValue) {
                        bl2 = ((BooleanValue)obj).getBooleanValue();
                        if (sequenceIterator.next() != null) {
                            ExpressionTool.ebvError("sequence of two or more items starting with a boolean value", this.getFilter());
                        }
                    } else if (obj instanceof StringValue) {
                        boolean bl3 = bl2 = !((StringValue)obj).isZeroLength();
                        if (sequenceIterator.next() != null) {
                            ExpressionTool.ebvError("sequence of two or more items starting with a boolean value", this.getFilter());
                        }
                    } else {
                        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string", this.getFilter());
                    }
                    if (bl2) {
                        return this.getBase().iterate((XPathContext)((Object)sequence));
                    }
                    return EmptyIterator.emptyIterator();
                }
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value", this.getFilter());
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw xPathException2;
            }
        }
        if ((sequenceIterator = this.getBase().iterate((XPathContext)((Object)sequence))) instanceof EmptyIterator) {
            return sequenceIterator;
        }
        if (this.a && !this.b) {
            return new FilterIterator(sequenceIterator, this.getFilter(), (XPathContext)((Object)sequence));
        }
        return new FilterIterator.NonNumeric(sequenceIterator, this.getFilter(), (XPathContext)((Object)sequence));
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new FilterExpression(this.getBase().copy((RebindingMap)object), this.getFilter().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((FilterExpression)object).c = this.c;
        ((FilterExpression)object).a = this.a;
        ((FilterExpression)object).b = this.b;
        return object;
    }

    @Override
    public final String getStreamerName() {
        return "FilterExpression";
    }

    @Override
    public final String toString() {
        return ExpressionTool.parenthesize(this.getBase()) + "[" + this.getFilter() + "]";
    }

    @Override
    public final String toShortString() {
        return this.getBase().toShortString() + "[" + this.getFilter().toShortString() + "]";
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("filter", this);
        String string = "";
        if (this.c) {
            string = string + "i";
        }
        if (this.a) {
            string = string + "p";
        }
        if (this.b) {
            string = string + "b";
        }
        expressionPresenter.emitAttribute("flags", string);
        this.getBase().export(expressionPresenter);
        this.getFilter().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public final void setFlags(String string) {
        this.c = string.contains("i");
        this.a = string.contains("p");
        this.b = string.contains("b");
    }
}

