/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FilterIterator<T extends Item<?>>
implements SequenceIterator<T> {
    protected FocusIterator<T> base;
    protected Expression filter;
    protected XPathContext filterContext;

    public FilterIterator(SequenceIterator<T> sequenceIterator, Expression expression, XPathContext xPathContext) {
        this.filter = expression;
        this.filterContext = xPathContext.newMinorContext();
        this.base = this.filterContext.trackFocus(sequenceIterator);
    }

    public void setSequence(SequenceIterator<?> sequenceIterator, XPathContext xPathContext) {
        this.filterContext = xPathContext.newMinorContext();
        this.base = this.filterContext.trackFocus(sequenceIterator);
    }

    @Override
    public T next() {
        return this.getNextMatchingItem();
    }

    protected T getNextMatchingItem() {
        Object t2;
        while ((t2 = this.base.next()) != null) {
            if (!this.matches()) continue;
            return t2;
        }
        return null;
    }

    protected boolean matches() {
        SequenceIterator<?> sequenceIterator = this.filter.iterate(this.filterContext);
        return FilterIterator.testPredicateValue(sequenceIterator, this.base.position(), this.filter);
    }

    public static boolean testPredicateValue(SequenceIterator sequenceIterator, long l2, Expression expression) {
        Object t2 = sequenceIterator.next();
        if (t2 == null) {
            return false;
        }
        if (t2 instanceof NodeInfo) {
            return true;
        }
        if (t2 instanceof BooleanValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("a sequence of two or more items starting with a boolean", expression);
            }
            return ((BooleanValue)t2).getBooleanValue();
        }
        if (t2 instanceof StringValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("a sequence of two or more items starting with a string", expression);
            }
            return t2.getStringValueCS().length() != 0;
        }
        if (t2 instanceof Int64Value) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("a sequence of two or more items starting with a numeric value", expression);
            }
            return ((NumericValue)((Int64Value)t2)).longValue() == l2;
        }
        if (t2 instanceof NumericValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("a sequence of two or more items starting with a numeric value", expression);
            }
            return ((NumericValue)t2).compareTo(l2) == 0;
        }
        if (t2 instanceof AtomicValue) {
            ExpressionTool.ebvError("a sequence starting with an atomic value of type " + ((AtomicValue)t2).getPrimitiveType().getDisplayName() + " (" + t2.toShortString() + ")", expression);
            return false;
        }
        ExpressionTool.ebvError("a sequence starting with " + t2.getGenre().getDescription() + " (" + t2.toShortString() + ")", expression);
        return false;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public int getProperties() {
        return 0;
    }

    public static final class NonNumeric<T extends Item<?>>
    extends FilterIterator<T> {
        public NonNumeric(SequenceIterator<T> sequenceIterator, Expression expression, XPathContext xPathContext) {
            super(sequenceIterator, expression, xPathContext);
        }

        @Override
        protected final boolean matches() {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }
    }
}

