/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OuterForExpression;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ForExpression
extends Assignation {
    private int a = 32768;

    @Override
    public String getExpressionName() {
        return "for";
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getSequenceOp().typeCheck(expressionVisitor, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getSequence()) && !(this instanceof OuterForExpression)) {
            return this.getSequence();
        }
        if (this.requiredType != null) {
            expressionVisitor.getConfiguration().getTypeHierarchy();
            Object object = this.requiredType;
            object = SequenceType.makeSequenceType(((SequenceType)object).getPrimaryType(), 57344);
            RoleDiagnostic roleDiagnostic = new RoleDiagnostic(3, this.variableName.getDisplayName(), 0);
            ForExpression forExpression = this;
            forExpression.setSequence(TypeChecker.strictTypeCheck(forExpression.getSequence(), (SequenceType)object, roleDiagnostic, expressionVisitor.getStaticContext()));
            object = this.getSequence().getItemType();
            this.refineTypeInformation((ItemType)object, this.getRangeVariableCardinality(), null, this.getSequence().getSpecialProperties(), this);
        }
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        this.getActionOp().typeCheck(expressionVisitor, contextItemStaticInfo);
        this.a = this.getAction().getCardinality();
        return this;
    }

    protected int getRangeVariableCardinality() {
        return 16384;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression;
        Configuration configuration = expressionVisitor.getConfiguration();
        Optimizer optimizer = expressionVisitor.obtainOptimizer();
        boolean bl2 = configuration.getBooleanProperty(Feature.TRACE_OPTIMIZER_DECISIONS);
        if (Choose.isSingleBranchChoice(this.getAction())) {
            this.getActionOp().optimize(expressionVisitor, contextItemStaticInfo);
        }
        if ((expression = this.promoteWhereClause()) != null) {
            if (bl2) {
                optimizer.trace("Promoted where clause in for $" + this.getVariableName(), expression);
            }
            return expression.optimize(expressionVisitor, contextItemStaticInfo);
        }
        expression = this.getSequence();
        this.getSequenceOp().optimize(expressionVisitor, contextItemStaticInfo);
        if (expression != this.getSequence()) {
            return ((Expression)this).optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (Literal.isEmptySequence(this.getSequence()) && !(this instanceof OuterForExpression)) {
            return this.getSequence();
        }
        expression = this.getAction();
        this.getActionOp().optimize(expressionVisitor, contextItemStaticInfo);
        if (expression != this.getAction()) {
            return ((Expression)this).optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        if (this.getSequence() instanceof SlashExpression && this.getAction() instanceof SlashExpression) {
            expression = (SlashExpression)this.getAction();
            Expression expression2 = ((SlashExpression)expression).getSelectExpression();
            Expression expression3 = ((SlashExpression)expression).getActionExpression();
            if (expression2 instanceof VariableReference && ((VariableReference)expression2).getBinding() == this && ExpressionTool.getReferenceCount(this.getAction(), this, false) == 1 && (expression3.getDependencies() & 0xC) == 0) {
                expression = new SlashExpression(this.getSequence(), ((SlashExpression)expression).getActionExpression());
                ExpressionTool.copyLocationInfo(this, expression);
                expression = expression.simplify().typeCheck(expressionVisitor, contextItemStaticInfo);
                if (expression instanceof SlashExpression) {
                    if (bl2) {
                        optimizer.trace("Collapsed return clause of for $" + this.getVariableName() + " into path expression", expression);
                    }
                    return expression.optimize(expressionVisitor, contextItemStaticInfo);
                }
            }
        }
        if (this.getAction() instanceof VariableReference && ((VariableReference)this.getAction()).getBinding() == this) {
            if (bl2) {
                optimizer.trace("Collapsed redundant for expression $" + this.getVariableName(), this.getSequence());
            }
            return this.getSequence();
        }
        if (this.getSequence().getCardinality() == 16384) {
            expression = new LetExpression();
            ((Assignation)expression).setVariableQName(this.variableName);
            ((Assignation)expression).setRequiredType(SequenceType.makeSequenceType(this.getSequence().getItemType(), 16384));
            ((Assignation)expression).setSequence(this.getSequence());
            ((Assignation)expression).setAction(this.getAction());
            ((Assignation)expression).setSlotNumber(this.slotNumber);
            expression.setRetainedStaticContextLocally(this.getRetainedStaticContext());
            ExpressionTool.rebindVariableReferences(this.getAction(), this, (Binding)((Object)expression));
            return expression.typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
        }
        return this;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        ForExpression forExpression = this;
        forExpression.setSequence(forExpression.getSequence().unordered(bl2, bl3));
        ForExpression forExpression2 = this;
        forExpression2.setAction(forExpression2.getAction().unordered(bl2, bl3));
        return this;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    protected Expression promoteWhereClause() {
        if (Choose.isSingleBranchChoice(this.getAction())) {
            Expression expression = ((Choose)this.getAction()).getCondition(0);
            Binding[] bindingArray = new Binding[]{this};
            ArrayList<Expression> arrayList = new ArrayList<Expression>(5);
            Expression expression2 = null;
            BooleanExpression.listAndComponents(expression, arrayList);
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                Expression expression3 = (Expression)arrayList.get(i2);
                if (ExpressionTool.dependsOnVariable(expression3, bindingArray)) continue;
                expression2 = expression2 == null ? expression3 : new AndExpression(expression3, expression2);
                arrayList.remove(i2);
            }
            if (expression2 != null) {
                if (arrayList.isEmpty()) {
                    Expression expression4 = ((Choose)this.getAction()).getAction(0);
                    this.setAction(expression4);
                    return Choose.makeConditional(expression2, this);
                }
                Expression expression5 = (Expression)arrayList.get(0);
                for (int i3 = 1; i3 < arrayList.size(); ++i3) {
                    expression5 = new AndExpression(expression5, (Expression)arrayList.get(i3));
                }
                ((Choose)this.getAction()).setCondition(0, expression5);
                Expression expression6 = Choose.makeConditional(expression2, this, Literal.makeEmptySequence());
                ExpressionTool.copyLocationInfo(this, expression6);
                return expression6;
            }
        }
        return null;
    }

    @Override
    public Expression copy(RebindingMap object) {
        ForExpression forExpression = new ForExpression();
        ExpressionTool.copyLocationInfo(this, forExpression);
        forExpression.setRequiredType(this.requiredType);
        forExpression.setVariableQName(this.variableName);
        forExpression.setSequence(this.getSequence().copy((RebindingMap)object));
        ((RebindingMap)object).put(this, forExpression);
        object = this.getAction().copy((RebindingMap)object);
        forExpression.setAction((Expression)object);
        forExpression.variableName = this.variableName;
        forExpression.slotNumber = this.slotNumber;
        return forExpression;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName structuredQName, int n2) {
        if (!Cardinality.allowsMany(this.getSequence().getCardinality())) {
            return ExpressionTool.markTailFunctionCalls(this.getAction(), structuredQName, n2);
        }
        return 0;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getAction().checkPermittedContents(schemaType, false);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        SequenceIterator<?> sequenceIterator = this.getSequence().iterate((XPathContext)object);
        object = new MappingAction((XPathContext)object, this.getLocalSlotNumber(), this.getAction());
        switch (this.a) {
            case 16384: {
                return new ItemMappingIterator(sequenceIterator, object, true);
            }
            case 24576: {
                return new ItemMappingIterator(sequenceIterator, object, false);
            }
        }
        return new MappingIterator(sequenceIterator, object);
    }

    @Override
    public void process(XPathContext xPathContext) {
        int n2 = this.getLocalSlotNumber();
        this.getSequence().iterate(xPathContext).forEachOrFail(item -> {
            xPathContext.setLocalVariable(n2, item);
            this.getAction().process(xPathContext);
        });
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        int n2 = this.getLocalSlotNumber();
        this.getSequence().iterate(xPathContext).forEachOrFail(item -> {
            xPathContext.setLocalVariable(n2, item);
            this.getAction().evaluatePendingUpdates(xPathContext, pendingUpdateList);
        });
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return this.getAction().getStaticUType(uType);
    }

    @Override
    public int computeCardinality() {
        int n2 = this.getSequence().getCardinality();
        int n3 = this.getAction().getCardinality();
        return Cardinality.multiply(n2, n3);
    }

    @Override
    public String toString() {
        return "for $" + this.getVariableEQName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toString()) + " return " + (this.getAction() == null ? "(...)" : ExpressionTool.parenthesize(this.getAction()));
    }

    @Override
    public String toShortString() {
        return "for $" + this.getVariableQName().getDisplayName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toShortString()) + " return " + (this.getAction() == null ? "(...)" : this.getAction().toShortString());
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("for", this);
        this.explainSpecializedAttributes(expressionPresenter);
        expressionPresenter.emitAttribute("var", this.getVariableQName());
        expressionPresenter.emitAttribute("as", this.getSequence().getItemType().toExportString());
        expressionPresenter.emitAttribute("slot", "" + this.getLocalSlotNumber());
        expressionPresenter.setChildRole("in");
        this.getSequence().export(expressionPresenter);
        expressionPresenter.setChildRole("return");
        this.getAction().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    protected void explainSpecializedAttributes(ExpressionPresenter expressionPresenter) {
    }

    @Override
    public int getConstructType() {
        return 2012;
    }

    @Override
    public String getStreamerName() {
        return "ForExpression";
    }

    public static class MappingAction
    implements ItemMappingFunction<Item<?>, Item<?>>,
    MappingFunction<Item<?>, Item<?>> {
        protected XPathContext context;
        private int a;
        private Expression b;

        public MappingAction(XPathContext xPathContext, int n2, Expression expression) {
            this.context = xPathContext;
            this.a = n2;
            this.b = expression;
        }

        @Override
        public SequenceIterator<?> map(Item<?> item) {
            this.context.setLocalVariable(this.a, item);
            return this.b.iterate(this.context);
        }

        @Override
        public Item<?> mapItem(Item<?> item) {
            this.context.setLocalVariable(this.a, item);
            return this.b.evaluateItem(this.context);
        }
    }
}

