/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Collections;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.SequenceType;

public abstract class FunctionCall
extends Expression {
    private OperandArray a;

    protected void setOperanda(OperandArray operandArray) {
        this.a = operandArray;
    }

    public OperandArray getOperanda() {
        return this.a;
    }

    @Override
    public Iterable<Operand> operands() {
        if (this.a != null) {
            return this.a.operands();
        }
        return Collections.emptyList();
    }

    public abstract Function getTargetFunction(XPathContext var1);

    public abstract StructuredQName getFunctionName();

    public final int getArity() {
        return this.getOperanda().getNumberOfOperands();
    }

    public void setArguments(Expression[] expressionArray) {
        this.setOperanda(new OperandArray(this, expressionArray));
    }

    protected void setOperanda(Expression[] expressionArray, OperandRole[] operandRoleArray) {
        this.setOperanda(new OperandArray((Expression)this, expressionArray, operandRoleArray));
    }

    public Expression[] getArguments() {
        Expression[] expressionArray = new Expression[this.getArity()];
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            expressionArray[n2++] = operand.getChildExpression();
        }
        return expressionArray;
    }

    public Expression getArg(int n2) {
        return this.getOperanda().getOperandExpression(n2);
    }

    public void setArg(int n2, Expression expression) {
        this.getOperanda().setOperand(n2, expression);
        this.adoptChildExpression(expression);
    }

    protected final Expression simplifyArguments(StaticContext staticContext) {
        for (int i2 = 0; i2 < this.getArguments().length; ++i2) {
            Expression expression = this.getArg(i2).simplify();
            if (expression == this.getArg(i2)) continue;
            this.adoptChildExpression(expression);
            this.setArg(i2, expression);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        this.checkArguments(expressionVisitor);
        return this.preEvaluateIfConstant(expressionVisitor);
    }

    protected Expression preEvaluateIfConstant(ExpressionVisitor expressionVisitor) {
        boolean bl2 = true;
        for (Operand operand : ((Expression)this).operands()) {
            if (operand.getChildExpression() instanceof Literal) continue;
            bl2 = false;
        }
        if (bl2) {
            try {
                return this.preEvaluate(expressionVisitor);
            }
            catch (NoDynamicContextException noDynamicContextException) {
                return this;
            }
        }
        return this;
    }

    public void checkFunctionCall(Function function, ExpressionVisitor expressionVisitor) {
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(expressionVisitor.getStaticContext().isInBackwardsCompatibleMode());
        SequenceType[] sequenceTypeArray = function.getFunctionItemType().getArgumentTypes();
        int n2 = function.getArity();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getFunctionName() == null ? "" : this.getFunctionName().getDisplayName();
            object = new RoleDiagnostic(0, (String)object, i2);
            this.setArg(i2, typeChecker.staticTypeCheck(this.getArg(i2), sequenceTypeArray[i2], (RoleDiagnostic)object, expressionVisitor));
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren(expressionVisitor, contextItemStaticInfo);
        boolean bl2 = true;
        for (Operand operand : ((Expression)this).operands()) {
            if (operand.getChildExpression() instanceof Literal) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return this.preEvaluate(expressionVisitor);
        }
        return this;
    }

    @Override
    public int getNetCost() {
        return 5;
    }

    public Expression preEvaluate(ExpressionVisitor expressionVisitor) {
        if ((this.getIntrinsicDependencies() & 0xFFFFF7FF) != 0) {
            return this;
        }
        try {
            Literal literal = Literal.makeLiteral(((Expression)this).iterate(expressionVisitor.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
            Optimizer.trace(expressionVisitor.getConfiguration(), "Pre-evaluated function call " + ((Expression)this).toShortString(), literal);
            return literal;
        }
        catch (NoDynamicContextException noDynamicContextException) {
            return this;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
            if (unsupportedOperationException.getCause() instanceof NoDynamicContextException) {
                return this;
            }
            throw unsupportedOperationException2;
        }
    }

    protected void checkArguments(ExpressionVisitor expressionVisitor) {
    }

    protected int checkArgumentCount(int n2, int n3) {
        int n4 = this.getArity();
        String string = null;
        if (n2 == n3 && n4 != n2) {
            string = "Function " + this.getDisplayName() + " must have " + FunctionCall.pluralArguments(n2);
        } else if (n4 < n2) {
            string = "Function " + this.getDisplayName() + " must have at least " + FunctionCall.pluralArguments(n2);
        } else if (n4 > n3) {
            string = "Function " + this.getDisplayName() + " must have no more than " + FunctionCall.pluralArguments(n3);
        }
        if (string != null) {
            XPathException xPathException = new XPathException(string, "XPST0017");
            xPathException.setIsStaticError(true);
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        return n4;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    public static String pluralArguments(int n2) {
        if (n2 == 1) {
            return "one argument";
        }
        return n2 + " arguments";
    }

    public PathMap.PathMapNodeSet addExternalFunctionCallToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = new PathMap.PathMapNodeSet();
        for (Operand operand : ((Expression)this).operands()) {
            pathMapNodeSet2.addNodeSet(operand.getChildExpression().addToPathMap(pathMap, pathMapNodeSet));
        }
        pathMapNodeSet2.setHasUnknownDependencies();
        return pathMapNodeSet2;
    }

    @Override
    public String getExpressionName() {
        return "functionCall";
    }

    public final String getDisplayName() {
        StructuredQName structuredQName = this.getFunctionName();
        if (structuredQName == null) {
            return "(anonymous)";
        }
        return structuredQName.getDisplayName();
    }

    @Override
    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        Object object = this.getFunctionName();
        object = object == null ? "$anonymousFunction" : (((StructuredQName)object).hasURI("http://www.w3.org/2005/xpath-functions") ? ((StructuredQName)object).getLocalPart() : ((StructuredQName)object).getEQName());
        fastStringBuffer.append((String)object);
        boolean bl2 = true;
        for (Operand operand : ((Expression)this).operands()) {
            fastStringBuffer.append(bl2 ? "(" : ", ");
            fastStringBuffer.append(operand.getChildExpression().toString());
            bl2 = false;
        }
        fastStringBuffer.append(bl2 ? "()" : ")");
        return fastStringBuffer.toString();
    }

    @Override
    public String toShortString() {
        StructuredQName structuredQName = this.getFunctionName();
        return (structuredQName == null ? "$anonFn" : structuredQName.getDisplayName()) + "(" + (this.getArity() == 0 ? "" : "...") + ")";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("functionCall", this);
        if (this.getFunctionName() == null) {
            throw new AssertionError((Object)"Exporting call to anonymous function");
        }
        expressionPresenter.emitAttribute("name", this.getFunctionName().getDisplayName());
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FunctionCall)) {
            return false;
        }
        if (this.getFunctionName() == null) {
            return this == object;
        }
        object = (FunctionCall)object;
        if (!this.getFunctionName().equals(((FunctionCall)object).getFunctionName())) {
            return false;
        }
        if (this.getArity() != ((FunctionCall)object).getArity()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            if (this.getArg(i2).isEqual(((FunctionCall)object).getArg(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeHashCode() {
        if (this.getFunctionName() == null) {
            return super.computeHashCode();
        }
        int n2 = this.getFunctionName().hashCode();
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            n2 ^= this.getArg(i2).hashCode();
        }
        return n2;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Object object = this.getTargetFunction(xPathContext);
        Sequence[] sequenceArray = this.evaluateArguments(xPathContext);
        try {
            return object.call(xPathContext, sequenceArray).iterate();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object).maybeSetContext(xPathContext);
            ((XPathException)object).maybeSetFailingExpression(this);
            throw object;
        }
    }

    public Sequence[] evaluateArguments(XPathContext xPathContext) {
        int n2 = this.getArity();
        Sequence[] sequenceArray = new Sequence[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sequenceArray[i2] = ExpressionTool.lazyEvaluate(this.getArg(i2), xPathContext, false);
        }
        return sequenceArray;
    }

    public boolean adjustRequiredType(JavaExternalObjectType javaExternalObjectType) {
        return false;
    }
}

