/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.UntypedNumericComparer;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class GeneralComparison
extends BinaryExpression
implements Callable,
ComparisonExpression {
    public static final int ONE_TO_ONE = 0;
    public static final int MANY_TO_ONE = 1;
    public static final int MANY_TO_MANY = 2;
    protected int singletonOperator;
    protected AtomicComparer comparer;
    protected boolean needsRuntimeCheck = true;
    protected int comparisonCardinality = 2;
    protected boolean doneWarnings = false;

    public GeneralComparison(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
        this.singletonOperator = GeneralComparison.getCorrespondingSingletonOperator(n2);
    }

    public boolean needsRuntimeCheck() {
        return this.needsRuntimeCheck;
    }

    public void setNeedsRuntimeCheck(boolean bl2) {
        this.needsRuntimeCheck = bl2;
    }

    public int getComparisonCardinality() {
        return this.comparisonCardinality;
    }

    public void setComparisonCardinality(int n2) {
        this.comparisonCardinality = n2;
    }

    public void setAtomicComparer(AtomicComparer atomicComparer) {
        this.comparer = atomicComparer;
    }

    @Override
    public String getExpressionName() {
        return "GeneralComparison";
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    @Override
    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object;
        Object object2;
        Configuration configuration = expressionVisitor.getConfiguration();
        Object object3 = configuration.getTypeHierarchy();
        Object object4 = this.getLhsExpression();
        Object object5 = this.getRhsExpression();
        this.getLhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        this.getRhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        GeneralComparison generalComparison = this;
        generalComparison.setLhsExpression(generalComparison.getLhsExpression().unordered(false, false));
        GeneralComparison generalComparison2 = this;
        generalComparison2.setRhsExpression(generalComparison2.getRhsExpression().unordered(false, false));
        Object object6 = SequenceType.ATOMIC_SEQUENCE;
        Object object7 = configuration.getTypeChecker(false);
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(((TypeChecker)object7).staticTypeCheck(this.getLhsExpression(), (SequenceType)object6, roleDiagnostic, expressionVisitor));
        roleDiagnostic = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(((TypeChecker)object7).staticTypeCheck(this.getRhsExpression(), (SequenceType)object6, roleDiagnostic, expressionVisitor));
        if (this.getLhsExpression() != object4) {
            GeneralComparison generalComparison3 = this;
            generalComparison3.adoptChildExpression(generalComparison3.getLhsExpression());
        }
        if (this.getRhsExpression() != object5) {
            GeneralComparison generalComparison4 = this;
            generalComparison4.adoptChildExpression(generalComparison4.getRhsExpression());
        }
        object4 = this.getLhsExpression().getItemType();
        object5 = this.getRhsExpression().getItemType();
        if (object4 instanceof ErrorType || object5 instanceof ErrorType) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (((PlainType)object4).isExternalType() || ((PlainType)object5).isExternalType()) {
            object6 = new XPathException("Cannot perform comparisons involving external objects");
            ((XPathException)object6).setIsTypeError(true);
            ((XPathException)object6).setErrorCode("XPTY0004");
            ((TransformerException)object6).setLocator(this.getLocation());
            throw object6;
        }
        object6 = (BuiltInAtomicType)object4.getPrimitiveItemType();
        object7 = (BuiltInAtomicType)object5.getPrimitiveItemType();
        int n2 = this.getLhsExpression().getCardinality();
        int n3 = this.getRhsExpression().getCardinality();
        if (n2 == 8192 || n3 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (!(object4.equals(BuiltInAtomicType.ANY_ATOMIC) || object4.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || object5.equals(BuiltInAtomicType.ANY_ATOMIC) || object5.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isPossiblyComparable((BuiltInAtomicType)object6, (BuiltInAtomicType)object7, Token.isOrderedOperator(this.singletonOperator)))) {
            object2 = "In {" + ((Expression)this).toShortString() + "}: cannot compare " + object4 + " to " + object5;
            if (Cardinality.allowsZero(n2) || Cardinality.allowsZero(n3)) {
                if (!this.doneWarnings) {
                    this.doneWarnings = true;
                    object = "one";
                    if (Cardinality.allowsZero(n2) && !Cardinality.allowsZero(n3)) {
                        object = "the first";
                    } else if (Cardinality.allowsZero(n3) && !Cardinality.allowsZero(n2)) {
                        object = "the second";
                    }
                    expressionVisitor.getStaticContext().issueWarning((String)object2 + ". The comparison can succeed only if " + (String)object + " operand is empty, and in that case will always be false", this.getLocation());
                }
            } else {
                XPathException xPathException = new XPathException((String)object2);
                xPathException.setErrorCode("XPTY0004");
                xPathException.setIsTypeError(true);
                xPathException.setLocator(this.getLocation());
                throw xPathException;
            }
        }
        boolean bl2 = this.needsRuntimeCheck = !Type.isGuaranteedGenerallyComparable((BuiltInAtomicType)object6, (BuiltInAtomicType)object7, Token.isOrderedOperator(this.singletonOperator));
        if (!(Cardinality.allowsMany(n2) || Cardinality.allowsMany(n3) || object4.equals(BuiltInAtomicType.ANY_ATOMIC) || object5.equals(BuiltInAtomicType.ANY_ATOMIC))) {
            object2 = this.getLhsExpression();
            object = this.getRhsExpression();
            if (object4.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (object5.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    object2 = new CastExpression(this.getLhsExpression(), BuiltInAtomicType.STRING, Cardinality.allowsZero(n2));
                    this.adoptChildExpression((Expression)object2);
                    object = new CastExpression(this.getRhsExpression(), BuiltInAtomicType.STRING, Cardinality.allowsZero(n3));
                    this.adoptChildExpression((Expression)object);
                } else {
                    if (((TypeHierarchy)object3).isSubType((ItemType)object5, NumericType.getInstance())) {
                        GeneralComparison generalComparison5 = this;
                        object3 = generalComparison5.a(generalComparison5.getLhsExpression(), this.getRhsExpression(), this.singletonOperator);
                        return ((Expression)object3).typeCheck(expressionVisitor, contextItemStaticInfo);
                    }
                    object2 = new CastExpression(this.getLhsExpression(), (AtomicType)object7, Cardinality.allowsZero(n2));
                    this.adoptChildExpression((Expression)object2);
                }
            } else if (object5.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (((TypeHierarchy)object3).isSubType((ItemType)object4, NumericType.getInstance())) {
                    GeneralComparison generalComparison6 = this;
                    object3 = generalComparison6.a(generalComparison6.getRhsExpression(), this.getLhsExpression(), Token.inverse(this.singletonOperator));
                    return ((Expression)object3).typeCheck(expressionVisitor, contextItemStaticInfo);
                }
                object = new CastExpression(this.getRhsExpression(), (AtomicType)object6, Cardinality.allowsZero(n3));
                this.adoptChildExpression((Expression)object);
            }
            object3 = new ValueComparison((Expression)object2, this.singletonOperator, (Expression)object);
            ((ValueComparison)object3).setAtomicComparer(this.comparer);
            ((ValueComparison)object3).setResultWhenEmpty(BooleanValue.FALSE);
            ExpressionTool.copyLocationInfo(this, (Expression)object3);
            Optimizer.trace(configuration, "Replaced general comparison by value comparison", (Expression)object3);
            return ((Expression)object3).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        object2 = expressionVisitor.getStaticContext();
        if (this.comparer == null) {
            object = object2.getDefaultCollationName();
            object3 = configuration.getCollation((String)object);
            if (object3 == null) {
                object3 = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)object6, (BuiltInAtomicType)object7, (StringCollator)object3, configuration.getConversionContext());
        }
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(object2.makeEarlyEvaluationContext()), this);
        }
        return this;
    }

    private ValueComparison a(Expression expression, Expression expression2, int n2) {
        expression = new ValueComparison(expression, n2, expression2);
        ((ValueComparison)expression).setAtomicComparer(new UntypedNumericComparer());
        ExpressionTool.copyLocationInfo(this, expression);
        Optimizer.trace(this.getConfiguration(), "Replaced general comparison by untyped-numeric value comparison", expression);
        return expression;
    }

    private static Expression a(Expression expression, String string) {
        if (Cardinality.allowsMany(expression.getCardinality())) {
            expression = SystemFunction.makeCall(string, expression.getRetainedStaticContext(), expression);
            assert (expression != null);
            ((Minimax)((SystemFunctionCall)expression).getTargetFunction()).setIgnoreNaN(true);
            return expression;
        }
        return expression;
    }

    @Override
    public int getIntrinsicDependencies() {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        if (GeneralComparison.a(typeHierarchy, this.getLhsExpression(), this.getRhsExpression()) || GeneralComparison.a(typeHierarchy, this.getRhsExpression(), this.getLhsExpression())) {
            return 2048;
        }
        return 0;
    }

    private static boolean a(TypeHierarchy typeHierarchy, Expression object, Expression expression) {
        return ((object = (SimpleType)((Object)((Expression)object).getItemType().getAtomizedItemType())) == BuiltInAtomicType.ANY_ATOMIC || object.isNamespaceSensitive()) && typeHierarchy.relationship(expression.getItemType().getAtomizedItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4 && (expression.getSpecialProperties() & 0x4000000) == 0;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GeneralComparison && super.equals(object) && this.comparer.equals(((GeneralComparison)object).comparer);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Expression optimize(ExpressionVisitor var1_1, ContextItemStaticInfo var2_2) {
        block26: {
            block27: {
                var3_3 = var1_1.getConfiguration().getTypeHierarchy();
                var4_4 = var1_1.getStaticContext();
                this.getLhs().optimize((ExpressionVisitor)var1_1, var2_2);
                this.getRhs().optimize((ExpressionVisitor)var1_1, var2_2);
                if (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression())) {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
                v0 = this;
                v0.setLhsExpression(v0.getLhsExpression().unordered(false, false));
                v1 = this;
                v1.setRhsExpression(v1.getRhsExpression().unordered(false, false));
                if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
                    return Literal.makeLiteral(this.evaluateItem(var1_1.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
                }
                var5_5 = this.getLhsExpression().getItemType();
                var6_6 = this.getRhsExpression().getItemType();
                var7_7 = this.getLhsExpression().getCardinality();
                var8_15 = this.getRhsExpression().getCardinality();
                var7_7 = (int)Cardinality.allowsMany(var7_7);
                var8_15 = (int)Cardinality.allowsMany(var8_15);
                if (var7_7 != 0) {
                    this.comparisonCardinality = var8_15 != 0 ? 2 : 1;
                } else {
                    if (var8_15 != 0) {
                        var7_8 = this.getInverseComparison();
                        this.getInverseComparison().comparisonCardinality = 1;
                        ExpressionTool.copyLocationInfo(this, var7_8);
                        var7_8.comparer = this.comparer;
                        var7_8.needsRuntimeCheck = this.needsRuntimeCheck;
                        return var7_8.optimize((ExpressionVisitor)var1_1, var2_2);
                    }
                    this.comparisonCardinality = 0;
                }
                if (this.operator == 6) {
                    if (this.getLhsExpression() instanceof RangeExpression) {
                        var7_9 = ((RangeExpression)this.getLhsExpression()).getLhsExpression();
                        var12_17 = ((RangeExpression)this.getLhsExpression()).getRhsExpression();
                        var13_21 = new IntegerRangeTest(this.getRhsExpression(), var7_9, var12_17);
                        ExpressionTool.copyLocationInfo(this, var13_21);
                        return var13_21;
                    }
                    if (this.getRhsExpression() instanceof RangeExpression) {
                        var7_10 = ((RangeExpression)this.getRhsExpression()).getLhsExpression();
                        var12_18 = ((RangeExpression)this.getRhsExpression()).getRhsExpression();
                        var13_22 = new IntegerRangeTest(this.getLhsExpression(), var7_10, var12_18);
                        ExpressionTool.copyLocationInfo(this, var13_22);
                        return var13_22;
                    }
                    if (this.getLhsExpression() instanceof Literal && (var7_11 = ((Literal)this.getLhsExpression()).getValue()) instanceof IntegerRange) {
                        var12_19 = ((IntegerRange)var7_11).getStart();
                        var14_23 = ((IntegerRange)var7_11).getEnd();
                        var1_1 = new IntegerRangeTest(this.getRhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(var12_19), this), Literal.makeLiteral(Int64Value.makeIntegerValue(var14_23), this));
                        ExpressionTool.copyLocationInfo(this, (Expression)var1_1);
                        return var1_1;
                    }
                    if (this.getRhsExpression() instanceof Literal && (var7_12 = ((Literal)this.getRhsExpression()).getValue()) instanceof IntegerRange) {
                        var12_20 = ((IntegerRange)var7_12).getStart();
                        var14_24 = ((IntegerRange)var7_12).getEnd();
                        var1_1 = new IntegerRangeTest(this.getLhsExpression(), Literal.makeLiteral(Int64Value.makeIntegerValue(var12_20), this), Literal.makeLiteral(Int64Value.makeIntegerValue(var14_24), this));
                        ExpressionTool.copyLocationInfo(this, (Expression)var1_1);
                        return var1_1;
                    }
                }
                if (this.operator == 6 || this.operator == 22) break block26;
                if (this.comparisonCardinality == 2) break block27;
                if (this.comparisonCardinality != 1) break block26;
                var7_13 = this;
                if (var7_13.getParentExpression() instanceof ContextSwitchingExpression && ((ContextSwitchingExpression)var7_13.getParentExpression()).getActionExpression() == var7_13) {
                    for (Operand var8_16 : var7_13.operands()) {
                        if (!Cardinality.allowsMany(var8_16.getChildExpression().getCardinality()) || !ExpressionTool.dependsOnFocus(var8_16.getChildExpression())) {
                            continue;
                        }
                        ** break block25
                    }
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) break block26;
            }
            if (var3_3.isSubType(var5_5, NumericType.getInstance()) || var3_3.isSubType(var6_6, NumericType.getInstance())) {
                switch (this.operator) {
                    case 12: 
                    case 14: {
                        var7_14 = new ValueComparison(GeneralComparison.a(this.getLhsExpression(), "min"), this.singletonOperator, GeneralComparison.a(this.getRhsExpression(), "max"));
                        var7_14.setResultWhenEmpty(BooleanValue.FALSE);
                        var7_14.setAtomicComparer(this.comparer);
                        break;
                    }
                    case 11: 
                    case 13: {
                        var7_14 = new ValueComparison(GeneralComparison.a(this.getLhsExpression(), "max"), this.singletonOperator, GeneralComparison.a(this.getRhsExpression(), "min"));
                        var7_14.setResultWhenEmpty(BooleanValue.FALSE);
                        var7_14.setAtomicComparer(this.comparer);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown operator " + this.operator);
                    }
                }
                ExpressionTool.copyLocationInfo(this, var7_14);
                var7_14.setRetainedStaticContext(this.getRetainedStaticContext());
                return var7_14.typeCheck((ExpressionVisitor)var1_1, var2_2);
            }
        }
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(var4_4.makeEarlyEvaluationContext()), this);
        }
        return var1_1.obtainOptimizer().optimizeGeneralComparison((ExpressionVisitor)var1_1, this, false, var2_2);
    }

    public BooleanValue evaluateItem(XPathContext xPathContext) {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
                AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
                return BooleanValue.get(this.a(atomicValue, atomicValue2, xPathContext));
            }
            case 1: {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate(xPathContext);
                AtomicValue atomicValue = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
                return BooleanValue.get(this.a(sequenceIterator, atomicValue, xPathContext));
            }
            case 2: {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate(xPathContext);
                SequenceIterator<?> sequenceIterator2 = this.getRhsExpression().iterate(xPathContext);
                return BooleanValue.get(this.evaluateManyToMany(sequenceIterator, sequenceIterator2, xPathContext));
            }
        }
        return null;
    }

    public BooleanValue call(XPathContext xPathContext, Sequence[] object) {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue atomicValue = (AtomicValue)object[0].head();
                object = (AtomicValue)object[1].head();
                return BooleanValue.get(this.a(atomicValue, (AtomicValue)object, xPathContext));
            }
            case 1: {
                SequenceIterator sequenceIterator = object[0].iterate();
                object = (AtomicValue)object[1].head();
                return BooleanValue.get(this.a(sequenceIterator, (AtomicValue)object, xPathContext));
            }
            case 2: {
                SequenceIterator sequenceIterator = object[0].iterate();
                object = object[1].iterate();
                return BooleanValue.get(this.evaluateManyToMany(sequenceIterator, (SequenceIterator)object, xPathContext));
            }
        }
        return null;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        switch (this.comparisonCardinality) {
            case 0: {
                AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
                AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
                return this.a(atomicValue, atomicValue2, xPathContext);
            }
            case 1: {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate(xPathContext);
                AtomicValue atomicValue = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
                return this.a(sequenceIterator, atomicValue, xPathContext);
            }
            case 2: {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate(xPathContext);
                SequenceIterator<?> sequenceIterator2 = this.getRhsExpression().iterate(xPathContext);
                return this.evaluateManyToMany(sequenceIterator, sequenceIterator2, xPathContext);
            }
        }
        return false;
    }

    private boolean a(AtomicValue object, AtomicValue atomicValue, XPathContext xPathContext) {
        try {
            return object != null && atomicValue != null && GeneralComparison.compare((AtomicValue)object, this.singletonOperator, atomicValue, this.comparer.provideContext(xPathContext), this.needsRuntimeCheck, xPathContext, this.getRetainedStaticContext());
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object).maybeSetContext(xPathContext);
            throw object;
        }
    }

    private boolean a(SequenceIterator sequenceIterator, AtomicValue atomicValue, XPathContext xPathContext) {
        if (atomicValue == null) {
            return false;
        }
        try {
            AtomicValue atomicValue2;
            AtomicComparer atomicComparer = this.comparer.provideContext(xPathContext);
            while ((atomicValue2 = (AtomicValue)sequenceIterator.next()) != null) {
                if (!GeneralComparison.compare(atomicValue2, this.singletonOperator, atomicValue, atomicComparer, this.needsRuntimeCheck, xPathContext, this.getRetainedStaticContext())) continue;
                sequenceIterator.close();
                return true;
            }
            return false;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public boolean evaluateManyToMany(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, XPathContext xPathContext) {
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            ArrayList<AtomicValue> arrayList = new ArrayList<AtomicValue>();
            ArrayList<AtomicValue> arrayList2 = new ArrayList<AtomicValue>();
            AtomicComparer atomicComparer = this.comparer.provideContext(xPathContext);
            while (true) {
                AtomicValue atomicValue;
                if (!bl2) {
                    atomicValue = (AtomicValue)sequenceIterator.next();
                    if (atomicValue == null) {
                        if (bl3) {
                            return false;
                        }
                        bl2 = true;
                    } else {
                        for (AtomicValue atomicValue2 : arrayList2) {
                            if (!GeneralComparison.compare(atomicValue, this.singletonOperator, atomicValue2, atomicComparer, this.needsRuntimeCheck, xPathContext, this.getRetainedStaticContext())) continue;
                            sequenceIterator.close();
                            sequenceIterator2.close();
                            return true;
                        }
                        if (!bl3) {
                            arrayList.add(atomicValue);
                        }
                    }
                }
                if (bl3) continue;
                atomicValue = (AtomicValue)sequenceIterator2.next();
                if (atomicValue == null) {
                    if (bl2) {
                        return false;
                    }
                    bl3 = true;
                    continue;
                }
                for (AtomicValue atomicValue2 : arrayList) {
                    if (!GeneralComparison.compare(atomicValue2, this.singletonOperator, atomicValue, atomicComparer, this.needsRuntimeCheck, xPathContext, this.getRetainedStaticContext())) continue;
                    sequenceIterator.close();
                    sequenceIterator2.close();
                    return true;
                }
                if (bl2) continue;
                arrayList2.add(atomicValue);
            }
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public static boolean compare(AtomicValue atomicValue, int n2, AtomicValue atomicValue2, AtomicComparer atomicComparer, boolean bl2, XPathContext xPathContext, NamespaceResolver namespaceResolver) {
        boolean bl3 = atomicValue instanceof UntypedAtomicValue;
        boolean bl4 = atomicValue2 instanceof UntypedAtomicValue;
        if (bl3 != bl4) {
            Object object = xPathContext.getConfiguration().getConversionRules();
            if (bl3) {
                if (atomicValue2 instanceof NumericValue) {
                    return UntypedNumericComparer.quickCompare((UntypedAtomicValue)atomicValue, (NumericValue)atomicValue2, n2, (ConversionRules)object);
                }
                if (!(atomicValue2 instanceof StringValue)) {
                    object = atomicValue2.getItemType().getPrimitiveItemType().getStringConverter((ConversionRules)object);
                    if (atomicValue2 instanceof QualifiedNameValue) {
                        object = (StringConverter)((Converter)object).setNamespaceResolver(namespaceResolver);
                        atomicValue = ((StringConverter)object).convertString(atomicValue.getStringValueCS()).asAtomic();
                    } else {
                        atomicValue = ((UntypedAtomicValue)atomicValue).obtainConversionResult(atomicValue2.getItemType().getPrimitiveType(), (StringConverter)object).asAtomic();
                    }
                }
            } else {
                if (atomicValue instanceof NumericValue) {
                    return UntypedNumericComparer.quickCompare((UntypedAtomicValue)atomicValue2, (NumericValue)atomicValue, Token.inverse(n2), (ConversionRules)object);
                }
                if (!(atomicValue instanceof StringValue)) {
                    object = atomicValue.getItemType().getPrimitiveItemType().getStringConverter((ConversionRules)object);
                    if (atomicValue instanceof QualifiedNameValue) {
                        object = (StringConverter)((Converter)object).setNamespaceResolver(namespaceResolver);
                        atomicValue2 = ((StringConverter)object).convertString(atomicValue2.getStringValueCS()).asAtomic();
                    } else {
                        atomicValue2 = ((UntypedAtomicValue)atomicValue2).obtainConversionResult(atomicValue.getItemType().getPrimitiveType(), (StringConverter)object).asAtomic();
                    }
                }
            }
            bl2 = false;
        }
        return ValueComparison.compare(atomicValue, n2, atomicValue2, atomicComparer, bl2);
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    public static int getCorrespondingSingletonOperator(int n2) {
        switch (n2) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return n2;
    }

    protected GeneralComparison getInverseComparison() {
        GeneralComparison20 generalComparison20 = new GeneralComparison20(this.getRhsExpression(), Token.inverse(this.operator), this.getLhsExpression());
        generalComparison20.setRetainedStaticContext(this.getRetainedStaticContext());
        return generalComparison20;
    }

    @Override
    public String getStreamerName() {
        return "GeneralComparison";
    }

    @Override
    public String tag() {
        return "gc";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
        String string = "";
        switch (this.comparisonCardinality) {
            case 0: {
                string = "1:1";
                break;
            }
            case 1: {
                string = "N:1";
                break;
            }
            case 2: {
                string = "M:N";
            }
        }
        expressionPresenter.emitAttribute("card", string);
        expressionPresenter.emitAttribute("comp", this.comparer.save());
    }
}

