/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;

public class GlobalVariableReference
extends VariableReference
implements ComponentInvocation {
    private int a = -1;

    public GlobalVariableReference(StructuredQName structuredQName) {
        super(structuredQName);
    }

    public GlobalVariableReference(GlobalVariable globalVariable) {
        super(globalVariable);
    }

    @Override
    public Expression copy(RebindingMap object) {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        object = new GlobalVariableReference(this.getVariableName());
        ((VariableReference)object).copyFrom(this);
        return object;
    }

    @Override
    public void setBindingSlot(int n2) {
        if (this.a != -1) {
            throw new AssertionError((Object)"Duplicate binding slot assignment");
        }
        this.a = n2;
    }

    @Override
    public int getBindingSlot() {
        return this.a;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, this.getVariableName());
    }

    public void setTarget(Component component) {
        this.binding = (GlobalVariable)component.getActor();
    }

    public Component getTarget() {
        return ((GlobalVariable)this.binding).getDeclaringComponent();
    }

    @Override
    public Component getFixedTarget() {
        Component component = this.getTarget();
        Visibility visibility = component.getVisibility();
        if (visibility == Visibility.PRIVATE || visibility == Visibility.FINAL) {
            return component;
        }
        return null;
    }

    @Override
    public Sequence<?> evaluateVariable(XPathContext xPathContext) {
        if (this.a >= 0) {
            if (xPathContext.getCurrentComponent() == null) {
                throw new AssertionError((Object)"No current component");
            }
            Component component = xPathContext.getTargetComponent(this.a);
            if (component.isHiddenAbstractComponent()) {
                XPathException xPathException = new XPathException("Cannot evaluate an abstract variable (" + this.getVariableName().getDisplayName() + ") with no overriding declaration", "XTDE3052");
                xPathException.setLocation(this.getLocation());
                throw xPathException;
            }
            GlobalVariable globalVariable = (GlobalVariable)component.getActor();
            return globalVariable.evaluateVariable(xPathContext, component);
        }
        GlobalVariable globalVariable = (GlobalVariable)this.binding;
        return globalVariable.evaluateVariable(xPathContext, globalVariable.getDeclaringComponent());
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("gVarRef", this);
        expressionPresenter.emitAttribute("name", this.getVariableName());
        expressionPresenter.emitAttribute("bSlot", "" + this.getBindingSlot());
        expressionPresenter.endElement();
    }

    public Set<Expression> getPreconditions() {
        HashSet<Expression> hashSet = new HashSet<Expression>();
        return hashSet;
    }
}

