/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.tree.iter.HomogeneityCheckerIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class HomogeneityChecker
extends UnaryExpression {
    public HomogeneityChecker(Expression expression) {
        super(expression);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.INSPECT;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if (this.getBaseExpression() instanceof HomogeneityChecker) {
            return this.getBaseExpression().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        }
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        object2 = this.getBaseExpression().getItemType();
        if (object2.equals(ErrorType.getInstance())) {
            return Literal.makeEmptySequence();
        }
        int n2 = ((TypeHierarchy)object).relationship((ItemType)object2, AnyNodeTest.getInstance());
        if (n2 == 4) {
            return this.getBaseExpression();
        }
        if (n2 == 0 || n2 == 2) {
            Expression expression = this.getBaseExpression();
            object2 = this.getParentExpression();
            this.getOperand().detachChild();
            expression = new DocumentSorter(expression);
            ExpressionTool.copyLocationInfo(this, expression);
            expression.setParentExpression((Expression)object2);
            return expression;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        if (this.getBaseExpression() instanceof HomogeneityChecker) {
            return this.getBaseExpression().optimize(expressionVisitor, contextItemStaticInfo);
        }
        return super.optimize(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new HomogeneityChecker(this.getBaseExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        object = this.getBaseExpression().iterate((XPathContext)object);
        return new HomogeneityCheckerIterator((SequenceIterator<?>)object, this.getLocation());
    }

    @Override
    public String getExpressionName() {
        return "homCheck";
    }
}

