/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class IdentityComparison
extends BinaryExpression {
    private boolean a = false;

    public IdentityComparison(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    public final void setGenerateIdEmulation(boolean bl2) {
        this.a = bl2;
    }

    public final boolean isGenerateIdEmulation() {
        return this.a;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.getLhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.getRhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        if (!this.a && (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression()))) {
            return Literal.makeEmptySequence();
        }
        object = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(false);
        this.setLhsExpression(typeChecker.staticTypeCheck(this.getLhsExpression(), SequenceType.OPTIONAL_NODE, (RoleDiagnostic)object, expressionVisitor));
        object = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(typeChecker.staticTypeCheck(this.getRhsExpression(), SequenceType.OPTIONAL_NODE, (RoleDiagnostic)object, expressionVisitor));
        if (!Cardinality.allowsZero(this.getLhsExpression().getCardinality()) && !Cardinality.allowsZero(this.getRhsExpression().getCardinality())) {
            this.a = false;
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if ((object = super.optimize((ExpressionVisitor)object, contextItemStaticInfo)) != this && !this.a && (Literal.isEmptySequence(this.getLhsExpression()) || Literal.isEmptySequence(this.getRhsExpression()))) {
            return Literal.makeEmptySequence();
        }
        return object;
    }

    @Override
    protected final OperandRole getOperandRole(int n2) {
        return OperandRole.INSPECT;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new IdentityComparison(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((IdentityComparison)object).a = this.a;
        return object;
    }

    @Override
    protected final String tag() {
        switch (this.operator) {
            case 20: {
                return "is";
            }
            case 38: {
                return "precedes";
            }
            case 39: {
                return "follows";
            }
        }
        return "?";
    }

    public final BooleanValue evaluateItem(XPathContext object) {
        NodeInfo nodeInfo = IdentityComparison.a(this.getLhsExpression(), (XPathContext)object);
        if (nodeInfo == null) {
            if (this.a) {
                return BooleanValue.get(IdentityComparison.a(this.getRhsExpression(), (XPathContext)object) == null);
            }
            return null;
        }
        object = IdentityComparison.a(this.getRhsExpression(), (XPathContext)object);
        if (object == null) {
            if (this.a) {
                return BooleanValue.FALSE;
            }
            return null;
        }
        return BooleanValue.get(this.a(nodeInfo, (NodeInfo)object));
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext object) {
        NodeInfo nodeInfo = IdentityComparison.a(this.getLhsExpression(), (XPathContext)object);
        if (nodeInfo == null) {
            return this.a && IdentityComparison.a(this.getRhsExpression(), (XPathContext)object) == null;
        }
        object = IdentityComparison.a(this.getRhsExpression(), (XPathContext)object);
        return object != null && this.a(nodeInfo, (NodeInfo)object);
    }

    private boolean a(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        switch (this.operator) {
            case 20: {
                return nodeInfo.equals(nodeInfo2);
            }
            case 38: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) < 0;
            }
            case 39: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) > 0;
            }
        }
        throw new UnsupportedOperationException("Unknown node identity test");
    }

    private static NodeInfo a(Expression expression, XPathContext xPathContext) {
        return (NodeInfo)expression.evaluateItem(xPathContext);
    }

    @Override
    public final ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    @Override
    public final String getExpressionName() {
        return "nodeComparison";
    }
}

