/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class InstanceOfExpression
extends UnaryExpression {
    private ItemType a;
    private int b;

    public InstanceOfExpression(Expression expression, SequenceType sequenceType) {
        super(expression);
        this.a = sequenceType.getPrimaryType();
        if (this.a == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.b = sequenceType.getCardinality();
    }

    @Override
    protected final OperandRole getOperandRole() {
        if (this.a instanceof DocumentNodeTest) {
            return OperandRole.ABSORB;
        }
        return OperandRole.INSPECT;
    }

    public final ItemType getRequiredItemType() {
        return this.a;
    }

    public final int getRequiredCardinality() {
        return this.b;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = this.getBaseExpression();
        if (object2 instanceof Literal) {
            object = Literal.makeLiteral(this.evaluateItem(((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext()), this);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        if (Cardinality.subsumes(this.b, ((Expression)object2).getCardinality())) {
            int n2 = ((TypeHierarchy)(object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())).relationship(((Expression)object2).getItemType(), this.a);
            if (n2 == 0 || n2 == 2) {
                Literal literal = Literal.makeLiteral(BooleanValue.TRUE, this);
                ExpressionTool.copyLocationInfo(this, literal);
                return literal;
            }
            if (!(n2 != 4 || Cardinality.allowsZero(this.b) && Cardinality.allowsZero(((Expression)object2).getCardinality()))) {
                Literal literal = Literal.makeLiteral(BooleanValue.FALSE, this);
                ExpressionTool.copyLocationInfo(this, literal);
                return literal;
            }
        } else if ((this.b & ((Expression)object2).getCardinality()) == 0) {
            object = Literal.makeLiteral(BooleanValue.FALSE, this);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != this) {
            return object2;
        }
        if (Cardinality.subsumes(this.b, this.getBaseExpression().getCardinality())) {
            int n2 = ((TypeHierarchy)(object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())).relationship(this.getBaseExpression().getItemType(), this.a);
            if (n2 == 0 || n2 == 2) {
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (!(n2 != 4 || Cardinality.allowsZero(this.b) && Cardinality.allowsZero(this.getBaseExpression().getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE, this);
            }
        }
        return this;
    }

    @Override
    public final int getImplementationMethod() {
        return 1;
    }

    @Override
    public final boolean equals(Object object) {
        return super.equals(object) && this.a == ((InstanceOfExpression)object).a && this.b == ((InstanceOfExpression)object).b;
    }

    @Override
    public final int computeHashCode() {
        return super.computeHashCode() ^ this.a.hashCode() ^ this.b;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new InstanceOfExpression(this.getBaseExpression().copy((RebindingMap)object), SequenceType.makeSequenceType(this.a, this.b));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    public final BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext object) {
        block4: {
            Object obj;
            SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate((XPathContext)object);
            XPathContext xPathContext = object;
            object = this;
            int n2 = 0;
            while ((obj = sequenceIterator.next()) != null) {
                ++n2;
                if (!((InstanceOfExpression)object).a.matches((Item)obj, xPathContext.getConfiguration().getTypeHierarchy())) {
                    sequenceIterator.close();
                } else {
                    if (n2 != 2 || Cardinality.allowsMany(((InstanceOfExpression)object).b)) continue;
                    sequenceIterator.close();
                }
                break block4;
            }
            if (n2 != 0 || (((InstanceOfExpression)object).b & 0x2000) != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final String getExpressionName() {
        return "instance";
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("instance", this);
        if (this.b == 8192) {
            expressionPresenter.emitAttribute("of", "empty-sequence()");
        } else {
            expressionPresenter.emitAttribute("of", this.a.toExportString() + Cardinality.getOccurrenceIndicator(this.b));
        }
        if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
            int n2 = ((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).targetVersion;
            expressionPresenter.emitAttribute("jsTest", this.a.generateJavaScriptItemTypeTest(this.getBaseExpression().getItemType(), n2));
        }
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public final String toString() {
        String string = Cardinality.getOccurrenceIndicator(this.b);
        return "(" + this.getBaseExpression().toString() + " instance of " + this.a.toString() + string + ")";
    }

    @Override
    public final String toShortString() {
        String string = Cardinality.getOccurrenceIndicator(this.b);
        return this.getBaseExpression().toShortString() + " instance of " + this.a.toString() + string;
    }

    @Override
    public final String getStreamerName() {
        return "InstanceOf";
    }
}

