/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class IntegerRangeTest
extends Expression {
    private Operand a;
    private Operand b;
    private Operand c;

    public IntegerRangeTest(Expression expression, Expression expression2, Expression expression3) {
        this.a = new Operand(this, expression, OperandRole.ATOMIC_SEQUENCE);
        this.b = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
        this.c = new Operand(this, expression3, OperandRole.SINGLE_ATOMIC);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.a, this.b, this.c);
    }

    public Expression getValue() {
        return this.a.getChildExpression();
    }

    public void setValue(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Expression getMin() {
        return this.b.getChildExpression();
    }

    public void setMin(Expression expression) {
        this.b.setChildExpression(expression);
    }

    public Expression getMax() {
        return this.c.getChildExpression();
    }

    public void setMax(Expression expression) {
        this.c.setChildExpression(expression);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if (Literal.isEmptySequence(this.getMin()) || Literal.isEmptySequence(this.getMax()) || Literal.isEmptySequence(this.getValue())) {
            return new Literal(BooleanValue.FALSE);
        }
        if (this.getMin() instanceof Literal && this.getMax() instanceof Literal && this.getValue() instanceof Literal) {
            object = this.evaluateItem(((ExpressionVisitor)object).makeDynamicContext());
            return new Literal((GroundedValue<?>)object);
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new IntegerRangeTest(this.getValue().copy((RebindingMap)object), this.getMin().copy((RebindingMap)object), this.getMax().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntegerRangeTest && ((IntegerRangeTest)object).getValue().isEqual(this.getValue()) && ((IntegerRangeTest)object).getMin().isEqual(this.getMin()) && ((IntegerRangeTest)object).getMax().isEqual(this.getMax());
    }

    @Override
    public int computeHashCode() {
        int n2 = this.getValue().hashCode() + 77;
        return n2 ^= this.getMin().hashCode() ^ this.getMax().hashCode();
    }

    public BooleanValue evaluateItem(XPathContext object) {
        AtomicValue atomicValue;
        IntegerValue integerValue = null;
        IntegerValue integerValue2 = null;
        StringConverter stringConverter = null;
        SequenceIterator<?> sequenceIterator = this.getValue().iterate((XPathContext)object);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            Object object2;
            if (integerValue == null) {
                integerValue = (IntegerValue)this.getMin().evaluateItem((XPathContext)object);
                if (integerValue == null) {
                    return BooleanValue.FALSE;
                }
                integerValue2 = (IntegerValue)this.getMax().evaluateItem((XPathContext)object);
                if (integerValue2 == null || integerValue2.compareTo(integerValue) < 0) {
                    return BooleanValue.FALSE;
                }
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                if (stringConverter == null) {
                    stringConverter = BuiltInAtomicType.DOUBLE.getStringConverter(object.getConfiguration().getConversionRules());
                }
                if ((object2 = stringConverter.convertString(atomicValue.getStringValueCS())) instanceof ValidationFailure) {
                    object = new XPathException("Failed to convert untypedAtomic value {" + atomicValue.getStringValueCS() + "}  to xs:integer", "FORG0001");
                    ((XPathException)object).setLocation(this.getLocation());
                    throw object;
                }
                atomicValue = (DoubleValue)object2.asAtomic();
            } else if (atomicValue instanceof NumericValue) {
                atomicValue = (NumericValue)atomicValue;
            } else {
                object2 = new XPathException("Cannot compare value of type " + atomicValue.getUType() + " to xs:integer", "XPTY0004");
                ((XPathException)object2).setIsTypeError(true);
                ((XPathException)object2).setLocation(this.getLocation());
                throw object2;
            }
            if (!((NumericValue)atomicValue).isWholeNumber() || ((NumericValue)atomicValue).compareTo(integerValue) < 0 || ((NumericValue)atomicValue).compareTo(integerValue2) > 0) continue;
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public String getExpressionName() {
        return "intRangeTest";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("intRangeTest", this);
        this.getValue().export(expressionPresenter);
        this.getMin().export(expressionPresenter);
        this.getMax().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getValue()) + " = (" + ExpressionTool.parenthesize(this.getMin()) + " to " + ExpressionTool.parenthesize(this.getMax()) + ")";
    }
}

