/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public final class ItemChecker
extends UnaryExpression {
    private ItemType a;
    private RoleDiagnostic b;

    public ItemChecker(Expression expression, ItemType itemType, RoleDiagnostic roleDiagnostic) {
        super(expression);
        this.a = itemType;
        this.b = roleDiagnostic;
    }

    public final ItemType getRequiredType() {
        return this.a;
    }

    @Override
    protected final OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public final RoleDiagnostic getRoleLocator() {
        return this.b;
    }

    @Override
    public final Expression simplify() {
        Expression expression = this.getBaseExpression().simplify();
        if (this.a instanceof AnyItemType) {
            return expression;
        }
        this.setBaseExpression(expression);
        return this;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        Object object2 = this.getBaseExpression();
        if (object2 instanceof Block) {
            Block block = (Block)object2;
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (Operand operand : ((Expression)block).operands()) {
                object2 = new ItemChecker(operand.getChildExpression(), this.a, this.b);
                arrayList.add((Expression)object2);
            }
            Block block2 = new Block(arrayList.toArray(new Expression[0]));
            ExpressionTool.copyLocationInfo(this, block2);
            return ((Expression)block2).typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        int n2 = ((Expression)object2).getCardinality();
        if (n2 == 8192) {
            return object2;
        }
        ItemType itemType = ((Expression)object2).getItemType();
        int n3 = typeHierarchy.relationship(this.a, itemType);
        if (n3 == 0 || n3 == 1) {
            return object2;
        }
        if (n3 == 4) {
            if (this.a.equals(BuiltInAtomicType.STRING) && typeHierarchy.isSubType(itemType, BuiltInAtomicType.ANY_URI)) {
                return object2;
            }
            if (Cardinality.allowsZero(n2)) {
                if (!(object2 instanceof Literal)) {
                    object2 = this.b.composeErrorMessage(this.a, (Expression)object2, typeHierarchy);
                    ((ExpressionVisitor)object).getStaticContext().issueWarning("The only value that can pass type-checking is an empty sequence. " + (String)object2, this.getLocation());
                }
            } else {
                object2 = this.b.composeErrorMessage(this.a, (Expression)object2, typeHierarchy);
                object = new XPathException((String)object2);
                ((XPathException)object).setErrorCode(this.b.getErrorCode());
                ((XPathException)object).setLocation(this.getLocation());
                ((XPathException)object).setIsTypeError(this.b.isTypeError());
                throw object;
            }
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().optimize((ExpressionVisitor)object, contextItemStaticInfo);
        object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        int n2 = ((TypeHierarchy)object).relationship(this.a, this.getBaseExpression().getItemType());
        if (n2 == 0 || n2 == 1) {
            return this.getBaseExpression();
        }
        return this;
    }

    @Override
    public final int getImplementationMethod() {
        int n2 = 22;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            n2 = 23;
        }
        return n2;
    }

    @Override
    public final String getStreamerName() {
        return "ItemChecker";
    }

    @Override
    public final IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate(xPathContext);
        return new ItemMappingIterator(sequenceIterator, this.getMappingFunction(xPathContext), true);
    }

    public final ItemMappingFunction<Item<?>, Item<?>> getMappingFunction(XPathContext xPathContext) {
        return new ItemTypeCheckingFunction(this.a, this.b, this.getBaseExpression(), xPathContext.getConfiguration());
    }

    public final Item evaluateItem(XPathContext xPathContext) {
        Object object = xPathContext.getConfiguration().getTypeHierarchy();
        Object object2 = this.getBaseExpression().evaluateItem(xPathContext);
        if (object2 == null) {
            return null;
        }
        if (this.a.matches((Item)object2, (TypeHierarchy)object)) {
            return object2;
        }
        if (this.a.getUType().subsumes(UType.STRING) && BuiltInAtomicType.ANY_URI.matches((Item)object2, (TypeHierarchy)object)) {
            return object2;
        }
        object = this.b.composeErrorMessage(this.a, (Item)object2, (TypeHierarchy)object);
        object2 = this.b.getErrorCode();
        if ("XPDY0050".equals(object2)) {
            this.dynamicError((String)object, (String)object2, xPathContext);
        } else {
            this.typeError((String)object, (String)object2, xPathContext);
        }
        return null;
    }

    @Override
    public final void process(XPathContext xPathContext) {
        Expression expression = this.getBaseExpression();
        int n2 = 57344;
        if (expression instanceof CardinalityChecker) {
            n2 = ((CardinalityChecker)expression).getRequiredCardinality();
            expression = ((CardinalityChecker)expression).getBaseExpression();
        }
        if ((expression.getImplementationMethod() & 4) != 0 && !(this.a instanceof DocumentNodeTest)) {
            Receiver receiver = xPathContext.getReceiver();
            TypeCheckingFilter typeCheckingFilter = new TypeCheckingFilter(receiver);
            typeCheckingFilter.setRequiredType(this.a, n2, this.b, this.getLocation());
            xPathContext.setReceiver(typeCheckingFilter);
            expression.process(xPathContext);
            ((ProxyReceiver)typeCheckingFilter).close();
            xPathContext.setReceiver(receiver);
            return;
        }
        super.process(xPathContext);
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new ItemChecker(this.getBaseExpression().copy((RebindingMap)object), this.a, this.b);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final ItemType getItemType() {
        ItemType itemType = this.getBaseExpression().getItemType();
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        int n2 = typeHierarchy.relationship(this.a, itemType);
        switch (n2) {
            case 3: {
                if (this.a instanceof NodeTest && itemType instanceof NodeTest) {
                    return new CombinedNodeTest((NodeTest)this.a, 23, (NodeTest)itemType);
                }
                return this.a;
            }
            case 0: 
            case 1: {
                return itemType;
            }
        }
        return this.a;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return UType.fromTypeCode(this.a.getPrimitiveType());
    }

    @Override
    public final boolean equals(Object object) {
        return super.equals(object) && this.a == ((ItemChecker)object).a;
    }

    @Override
    public final int computeHashCode() {
        return super.computeHashCode() ^ this.a.hashCode();
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("treat", this);
        expressionPresenter.emitAttribute("as", this.a.toExportString());
        ExpressionPresenter.ExportOptions exportOptions = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if ("JS".equals(exportOptions.target)) {
            int n2 = exportOptions.targetVersion;
            expressionPresenter.emitAttribute("jsTest", this.a.generateJavaScriptItemTypeTest(this.getBaseExpression().getItemType(), n2));
            if (n2 == 2) {
                SequenceType sequenceType = SequenceType.makeSequenceType(this.a, 16384);
                expressionPresenter.emitAttribute("asJ", sequenceType.toExportString2());
            }
        }
        expressionPresenter.emitAttribute("diag", this.b.save());
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public final String getExpressionName() {
        return "treatAs";
    }

    @Override
    public final String toString() {
        String string = this.a.toString();
        return "(" + this.getBaseExpression() + ") treat as " + string;
    }

    @Override
    public final String toShortString() {
        return this.getBaseExpression().toShortString();
    }
}

