/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.OneOrMore;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class JPConverter {
    private static HashMap<Class<?>, JPConverter> a = new HashMap<Class<XdmValue>, FromXdmValue>();
    private static Map<Class<?>, ItemType> b;
    private static Map<Class<?>, Integer> c;

    public static JPConverter allocate(Class clazz, Type object, Configuration configuration) {
        if (QName.class.isAssignableFrom(clazz)) {
            return FromQName.INSTANCE;
        }
        if (Sequence.class.isAssignableFrom(clazz)) {
            if (object instanceof ParameterizedType) {
                if (((Type[])(object = ((ParameterizedType)object).getActualTypeArguments())).length == 1 && object[0] instanceof Class && Item.class.isAssignableFrom((Class)object[0])) {
                    object = b.get((Class)object[0]);
                    Integer object22 = c.get(clazz);
                    if (object != null && object22 != null) {
                        return new FromSequence((ItemType)object, object22);
                    }
                }
            } else {
                object = b.get(clazz);
                if (object != null) {
                    return new FromSequence((ItemType)object, 24576);
                }
            }
        }
        if ((object = a.get(clazz)) != null) {
            return object;
        }
        if (clazz.equals(Object.class)) {
            return FromObject.INSTANCE;
        }
        if (NodeInfo.class.isAssignableFrom(clazz)) {
            return new FromSequence(AnyNodeTest.getInstance(), 24576);
        }
        if (Source.class.isAssignableFrom(clazz) && !DOMSource.class.isAssignableFrom(clazz)) {
            return FromSource.INSTANCE;
        }
        for (Map.Entry entry : a.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            return (JPConverter)entry.getValue();
        }
        object = configuration.getExternalObjectModels();
        Iterator<ExternalObjectModel> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if ((object = object.getJPConverter(clazz, configuration)) == null) continue;
            return object;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            return new FromObjectArray(JPConverter.allocate(clazz2, null, configuration));
        }
        if (clazz.equals(Void.TYPE)) {
            return VoidConverter.INSTANCE;
        }
        return new ExternalObjectWrapper(configuration.getJavaExternalObjectType(clazz));
    }

    public abstract Sequence<?> convert(Object var1, XPathContext var2);

    public abstract ItemType getItemType();

    public int getCardinality() {
        return 16384;
    }

    static {
        a.put(XdmValue.class, new FromXdmValue(AnyItemType.getInstance(), 57344));
        a.put(XdmItem.class, new FromXdmValue(AnyItemType.getInstance(), 16384));
        a.put(XdmAtomicValue.class, new FromXdmValue(BuiltInAtomicType.ANY_ATOMIC, 16384));
        a.put(XdmNode.class, new FromXdmValue(AnyNodeTest.getInstance(), 16384));
        a.put(XdmFunctionItem.class, new FromXdmValue(AnyFunctionType.getInstance(), 16384));
        a.put(XdmMap.class, new FromXdmValue(MapType.ANY_MAP_TYPE, 16384));
        a.put(XdmArray.class, new FromXdmValue(ArrayItemType.getInstance(), 16384));
        a.put(XdmEmptySequence.class, new FromXdmValue(ErrorType.getInstance(), 8192));
        a.put(SequenceIterator.class, FromSequenceIterator.INSTANCE);
        a.put(Sequence.class, FromSequence.INSTANCE);
        a.put(OneOrMore.class, FromSequence.INSTANCE);
        a.put(One.class, FromSequence.INSTANCE);
        a.put(ZeroOrOne.class, FromSequence.INSTANCE);
        a.put(ZeroOrMore.class, FromSequence.INSTANCE);
        a.put(String.class, FromString.INSTANCE);
        a.put(Boolean.class, FromBoolean.INSTANCE);
        a.put(Boolean.TYPE, FromBoolean.INSTANCE);
        a.put(Double.class, FromDouble.INSTANCE);
        a.put(Double.TYPE, FromDouble.INSTANCE);
        a.put(Float.class, FromFloat.INSTANCE);
        a.put(Float.TYPE, FromFloat.INSTANCE);
        a.put(BigDecimal.class, FromBigDecimal.INSTANCE);
        a.put(BigInteger.class, FromBigInteger.INSTANCE);
        a.put(Long.class, FromLong.INSTANCE);
        a.put(Long.TYPE, FromLong.INSTANCE);
        a.put(Integer.class, FromInt.INSTANCE);
        a.put(Integer.TYPE, FromInt.INSTANCE);
        a.put(Short.class, FromShort.INSTANCE);
        a.put(Short.TYPE, FromShort.INSTANCE);
        a.put(Byte.class, FromByte.INSTANCE);
        a.put(Byte.TYPE, FromByte.INSTANCE);
        a.put(Character.class, FromCharacter.INSTANCE);
        a.put(Character.TYPE, FromCharacter.INSTANCE);
        a.put(URI.class, FromURI.INSTANCE);
        a.put(URL.class, FromURI.INSTANCE);
        a.put(Date.class, FromDate.INSTANCE);
        a.put(long[].class, FromLongArray.INSTANCE);
        a.put(int[].class, FromIntArray.INSTANCE);
        a.put(short[].class, FromShortArray.INSTANCE);
        a.put(byte[].class, FromByteArray.INSTANCE);
        a.put(char[].class, FromCharArray.INSTANCE);
        a.put(double[].class, FromDoubleArray.INSTANCE);
        a.put(float[].class, FromFloatArray.INSTANCE);
        a.put(boolean[].class, FromBooleanArray.INSTANCE);
        a.put(Collection.class, FromCollection.INSTANCE);
        b = new HashMap();
        b.put(BooleanValue.class, BuiltInAtomicType.BOOLEAN);
        b.put(StringValue.class, BuiltInAtomicType.STRING);
        b.put(DoubleValue.class, BuiltInAtomicType.DOUBLE);
        b.put(FloatValue.class, BuiltInAtomicType.FLOAT);
        b.put(BigDecimalValue.class, BuiltInAtomicType.DECIMAL);
        b.put(IntegerValue.class, BuiltInAtomicType.INTEGER);
        b.put(DurationValue.class, BuiltInAtomicType.DURATION);
        b.put(DayTimeDurationValue.class, BuiltInAtomicType.DAY_TIME_DURATION);
        b.put(YearMonthDurationValue.class, BuiltInAtomicType.YEAR_MONTH_DURATION);
        b.put(DateTimeValue.class, BuiltInAtomicType.DATE_TIME);
        b.put(DateValue.class, BuiltInAtomicType.DATE);
        b.put(TimeValue.class, BuiltInAtomicType.TIME);
        b.put(GYearValue.class, BuiltInAtomicType.G_YEAR);
        b.put(GYearMonthValue.class, BuiltInAtomicType.G_YEAR_MONTH);
        b.put(GMonthValue.class, BuiltInAtomicType.G_MONTH);
        b.put(GMonthDayValue.class, BuiltInAtomicType.G_MONTH_DAY);
        b.put(GDayValue.class, BuiltInAtomicType.G_DAY);
        b.put(AnyURIValue.class, BuiltInAtomicType.ANY_URI);
        b.put(QNameValue.class, BuiltInAtomicType.QNAME);
        b.put(NotationValue.class, BuiltInAtomicType.NOTATION);
        b.put(HexBinaryValue.class, BuiltInAtomicType.HEX_BINARY);
        b.put(Base64BinaryValue.class, BuiltInAtomicType.BASE64_BINARY);
        b.put(NodeInfo.class, AnyNodeTest.getInstance());
        b.put(TreeInfo.class, NodeKindTest.DOCUMENT);
        b.put(MapItem.class, MapType.getInstance());
        b.put(ArrayItem.class, ArrayItemType.getInstance());
        b.put(Function.class, AnyFunctionType.getInstance());
        b.put(AtomicValue.class, BuiltInAtomicType.ANY_ATOMIC);
        b.put(UntypedAtomicValue.class, BuiltInAtomicType.UNTYPED_ATOMIC);
        c = new HashMap();
        c.put(Sequence.class, 57344);
        c.put(ZeroOrMore.class, 57344);
        c.put(OneOrMore.class, 49152);
        c.put(One.class, 16384);
        c.put(ZeroOrOne.class, 24576);
        c.put(XdmValue.class, 57344);
        c.put(XdmItem.class, 57344);
        c.put(XdmEmptySequence.class, 8192);
    }

    public static class FromObjectArray
    extends JPConverter {
        private JPConverter a;

        public FromObjectArray(JPConverter jPConverter) {
            this.a = jPConverter;
        }

        @Override
        public Sequence<?> convert(Object objectArray, XPathContext xPathContext) {
            objectArray = objectArray;
            ArrayList arrayList = new ArrayList(objectArray.length);
            for (Object object : objectArray) {
                if (object != null) {
                    try {
                        Object obj = SequenceTool.asItem(this.a.convert(object, xPathContext));
                        if (obj == null) continue;
                        arrayList.add(obj);
                        continue;
                    }
                    catch (XPathException xPathException) {
                        throw new XPathException("Returned array contains an object that cannot be converted to an Item (" + object.getClass() + "): " + xPathException.getMessage(), "SXJE0051");
                    }
                }
                throw new XPathException("Returned array contains null values: cannot convert to items", "SXJE0051");
            }
            return new SequenceExtent(arrayList);
        }

        @Override
        public ItemType getItemType() {
            return this.a.getItemType();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromBooleanArray
    extends JPConverter {
        public static final FromBooleanArray INSTANCE = new FromBooleanArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((boolean[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = BooleanValue.get(((boolean[])object)[i2]);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromFloatArray
    extends JPConverter {
        public static final FromFloatArray INSTANCE = new FromFloatArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((float[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = new DoubleValue(((float[])object)[i2]);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromDoubleArray
    extends JPConverter {
        public static final FromDoubleArray INSTANCE = new FromDoubleArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((double[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = new DoubleValue(((double[])object)[i2]);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromCharArray
    extends JPConverter {
        public static final FromCharArray INSTANCE = new FromCharArray();

        public StringValue convert(Object object, XPathContext xPathContext) {
            return StringValue.makeStringValue(new String((char[])object));
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromByteArray
    extends JPConverter {
        public static final FromByteArray INSTANCE = new FromByteArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((byte[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = Int64Value.makeDerived(0xFF & ((byte[])object)[i2], BuiltInAtomicType.UNSIGNED_BYTE);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.UNSIGNED_BYTE;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromShortArray
    extends JPConverter {
        public static final FromShortArray INSTANCE = new FromShortArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((short[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = Int64Value.makeDerived(((short[])object)[i2], BuiltInAtomicType.SHORT);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.SHORT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromIntArray
    extends JPConverter {
        public static final FromIntArray INSTANCE = new FromIntArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((int[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = Int64Value.makeDerived(((int[])object)[i2], BuiltInAtomicType.INT);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromLongArray
    extends JPConverter {
        public static final FromLongArray INSTANCE = new FromLongArray();

        @Override
        public Sequence<?> convert(Object object, XPathContext itemArray) {
            itemArray = new Item[((long[])object).length];
            for (int i2 = 0; i2 < itemArray.length; ++i2) {
                itemArray[i2] = Int64Value.makeDerived(((long[])object)[i2], BuiltInAtomicType.LONG);
            }
            return new SequenceExtent(itemArray);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.LONG;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromSource
    extends JPConverter {
        public static final FromSource INSTANCE = new FromSource();

        public NodeInfo convert(Object object, XPathContext xPathContext) {
            ParseOptions parseOptions = new ParseOptions();
            Controller controller = xPathContext.getController();
            if (controller != null) {
                parseOptions.setSchemaValidationMode(controller.getSchemaValidationMode());
            }
            return xPathContext.getConfiguration().buildDocumentTree((Source)object, parseOptions).getRootNode();
        }

        @Override
        public ItemType getItemType() {
            return AnyNodeTest.getInstance();
        }
    }

    public static class FromCollection
    extends JPConverter {
        public static final FromCollection INSTANCE = new FromCollection();

        @Override
        public Sequence<?> convert(Object iterator, XPathContext xPathContext) {
            ArrayList<JPConverter> arrayList = new ArrayList<JPConverter>(((Collection)((Object)iterator)).size());
            for (Object e2 : (Collection)((Object)iterator)) {
                JPConverter jPConverter = FromCollection.allocate(e2.getClass(), null, xPathContext.getConfiguration());
                try {
                    if ((jPConverter = SequenceTool.asItem(jPConverter.convert(e2, xPathContext))) == null) continue;
                    arrayList.add(jPConverter);
                }
                catch (XPathException xPathException) {
                    throw new XPathException("Returned Collection contains an object that cannot be converted to an Item (" + e2.getClass() + "): " + xPathException.getMessage(), "SXJE0051");
                }
            }
            return new SequenceExtent(arrayList);
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class VoidConverter
    extends JPConverter {
        public static final VoidConverter INSTANCE = new VoidConverter();

        public EmptySequence<Item<?>> convert(Object object, XPathContext xPathContext) {
            return EmptySequence.getInstance();
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }
    }

    public static class ExternalObjectWrapper
    extends JPConverter {
        private JavaExternalObjectType a;

        public ExternalObjectWrapper(JavaExternalObjectType javaExternalObjectType) {
            this.a = javaExternalObjectType;
        }

        public ExternalObject<Object> convert(Object object, XPathContext xPathContext) {
            if (object == null) {
                return null;
            }
            if (this.a.getJavaClass().isInstance(object)) {
                return new ObjectValue<Object>(object);
            }
            throw new XPathException("Java external object of type " + object.getClass().getName() + " is not an instance of the required type " + this.a.getJavaClass().getName(), "XPTY0004");
        }

        @Override
        public JavaExternalObjectType getItemType() {
            return this.a;
        }
    }

    public static class FromDate
    extends JPConverter {
        public static final FromDate INSTANCE = new FromDate();

        public DateTimeValue convert(Object object, XPathContext xPathContext) {
            return DateTimeValue.fromJavaDate((Date)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DATE_TIME;
        }
    }

    public static class FromURI
    extends JPConverter {
        public static final FromURI INSTANCE = new FromURI();

        public AnyURIValue convert(Object object, XPathContext xPathContext) {
            return new AnyURIValue(object.toString());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.ANY_URI;
        }
    }

    public static class FromQName
    extends JPConverter {
        public static final FromQName INSTANCE = new FromQName();

        public QNameValue convert(Object object, XPathContext xPathContext) {
            object = (QName)object;
            return new QNameValue(((QName)object).getPrefix(), ((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.QNAME;
        }
    }

    public static class FromCharacter
    extends JPConverter {
        public static final FromCharacter INSTANCE = new FromCharacter();

        public StringValue convert(Object object, XPathContext xPathContext) {
            return new StringValue(object.toString());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromByte
    extends JPConverter {
        public static final FromByte INSTANCE = new FromByte();

        public Int64Value convert(Object object, XPathContext xPathContext) {
            return new Int64Value(((Byte)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromShort
    extends JPConverter {
        public static final FromShort INSTANCE = new FromShort();

        public Int64Value convert(Object object, XPathContext xPathContext) {
            return new Int64Value(((Short)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromInt
    extends JPConverter {
        public static final FromInt INSTANCE = new FromInt();

        public Int64Value convert(Object object, XPathContext xPathContext) {
            return new Int64Value(((Integer)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromLong
    extends JPConverter {
        public static final FromLong INSTANCE = new FromLong();

        public Int64Value convert(Object object, XPathContext xPathContext) {
            return new Int64Value((Long)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromBigInteger
    extends JPConverter {
        public static final FromBigInteger INSTANCE = new FromBigInteger();

        public IntegerValue convert(Object object, XPathContext xPathContext) {
            return IntegerValue.makeIntegerValue((BigInteger)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromBigDecimal
    extends JPConverter {
        public static final FromBigDecimal INSTANCE = new FromBigDecimal();

        public BigDecimalValue convert(Object object, XPathContext xPathContext) {
            return new BigDecimalValue((BigDecimal)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class FromFloat
    extends JPConverter {
        public static final FromFloat INSTANCE = new FromFloat();

        public FloatValue convert(Object object, XPathContext xPathContext) {
            return new FloatValue(((Float)object).floatValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FromDouble
    extends JPConverter {
        public static final FromDouble INSTANCE = new FromDouble();

        public DoubleValue convert(Object object, XPathContext xPathContext) {
            return new DoubleValue((Double)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class FromBoolean
    extends JPConverter {
        public static final FromBoolean INSTANCE = new FromBoolean();

        public BooleanValue convert(Object object, XPathContext xPathContext) {
            return BooleanValue.get((Boolean)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }
    }

    public static class FromString
    extends JPConverter {
        public static final FromString INSTANCE = new FromString();

        public StringValue convert(Object object, XPathContext xPathContext) {
            return new StringValue((String)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromSequence
    extends JPConverter {
        public static final FromSequence INSTANCE = new FromSequence(AnyItemType.getInstance(), 57344);
        private ItemType a;
        private int b;

        public FromSequence(ItemType itemType, int n2) {
            this.a = itemType;
            this.b = n2;
        }

        @Override
        public Sequence<?> convert(Object object, XPathContext xPathContext) {
            if (object instanceof Closure) {
                return ((Closure)object).iterate().materialize();
            }
            return (Sequence)object;
        }

        @Override
        public ItemType getItemType() {
            return this.a;
        }

        @Override
        public int getCardinality() {
            return this.b;
        }
    }

    public static class FromXdmValue
    extends JPConverter {
        private ItemType a;
        private int b;

        public FromXdmValue(ItemType itemType, int n2) {
            this.a = itemType;
            this.b = n2;
        }

        @Override
        public Sequence<?> convert(Object object, XPathContext xPathContext) {
            return ((XdmValue)object).getUnderlyingValue();
        }

        @Override
        public ItemType getItemType() {
            return this.a;
        }

        @Override
        public int getCardinality() {
            return this.b;
        }
    }

    public static class FromSequenceIterator
    extends JPConverter {
        public static final FromSequenceIterator INSTANCE = new FromSequenceIterator();

        @Override
        public Sequence<?> convert(Object object, XPathContext xPathContext) {
            return ((SequenceIterator)object).materialize();
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromObject
    extends JPConverter {
        public static final FromObject INSTANCE = new FromObject();

        @Override
        public Sequence<?> convert(Object object, XPathContext xPathContext) {
            Class<?> clazz = object.getClass();
            JPConverter jPConverter = FromObject.allocate(clazz, null, xPathContext.getConfiguration());
            if (jPConverter instanceof FromObject) {
                jPConverter = new ExternalObjectWrapper(xPathContext.getConfiguration().getJavaExternalObjectType(clazz));
            }
            return jPConverter.convert(object, xPathContext);
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }
}

