/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class LetExpression
extends Assignation
implements TailCallReturner {
    private Evaluator a = null;
    private boolean b = false;
    private boolean c = false;
    private boolean d;

    public void setInstruction(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public boolean isInstruction() {
        return this.d;
    }

    @Override
    public String getExpressionName() {
        return "let";
    }

    public void setNeedsEagerEvaluation(boolean bl2) {
        if (bl2) {
        }
        this.b = bl2;
    }

    public void setNeedsLazyEvaluation(boolean bl2) {
        if (bl2 && this.b) {
            this.b = false;
        }
        this.c = bl2;
    }

    public boolean isNeedsLazyEvaluation() {
        return this.c;
    }

    @Override
    public boolean isLiftable(boolean bl2) {
        return super.isLiftable(bl2) && !this.b;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.references = new ArrayList<VariableReference>();
        if (this.a == Evaluator.VARIABLE && !(this.getSequence() instanceof VariableReference)) {
            this.a = null;
            this.setEvaluator();
        }
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getSequenceOp().typeCheck(expressionVisitor, contextItemStaticInfo);
        Object object = new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
        LetExpression letExpression = this;
        letExpression.setSequence(TypeChecker.strictTypeCheck(letExpression.getSequence(), this.requiredType, (RoleDiagnostic)object, expressionVisitor.getStaticContext()));
        object = this.getSequence().getItemType();
        this.refineTypeInformation((ItemType)object, this.getSequence().getCardinality(), this.getSequence() instanceof Literal ? ((Literal)this.getSequence()).getValue() : null, this.getSequence().getSpecialProperties(), this);
        this.getActionOp().typeCheck(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType sequenceType, boolean bl2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(bl2);
        this.setAction(typeChecker.staticTypeCheck(this.getAction(), sequenceType, roleDiagnostic, expressionVisitor));
        return this;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Expression optimize(ExpressionVisitor var1_1, ContextItemStaticInfo var2_2) {
        var3_3 = var1_1.obtainOptimizer();
        if (this.getAction() instanceof VariableReference && ((VariableReference)this.getAction()).getBinding() == this && !ExpressionTool.changesXsltContext(this.getSequence())) {
            this.getSequenceOp().optimize(var1_1, var2_2);
            var3_3.trace("Eliminated trivial variable " + this.getVariableName(), this.getSequence());
            return this.getSequence();
        }
        if (this.getSequence() instanceof Literal && var3_3.isOptionSet(4)) {
            var3_3.trace("Inlined constant variable " + this.getVariableName(), this.getSequence());
            v0 = this;
            v0.replaceVariable(v0.getSequence());
            return this.getAction().optimize(var1_1, var2_2);
        }
        if (this.getSequence() instanceof DocumentInstr && ((DocumentInstr)this.getSequence()).isTextOnly()) {
            this.verifyReferences();
            var4_4 /* !! */  = this;
            if (var4_4 /* !! */ .references != null) {
                for (Object var6_9 : var4_4 /* !! */ .references) {
                    if (var6_9.isFlattened()) {
                        continue;
                    }
                    ** break block30
                }
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v1) {
                var4_4 /* !! */  = ((DocumentInstr)this.getSequence()).getStringValueExpression();
                var4_4 /* !! */  = var4_4 /* !! */ .typeCheck(var1_1, var2_2);
                this.setSequence(var4_4 /* !! */ );
                this.requiredType = SequenceType.SINGLE_UNTYPED_ATOMIC;
                v2 = this;
                v2.adoptChildExpression(v2.getSequence());
                v3 = this;
                v3.refineTypeInformation(v3.requiredType.getPrimaryType(), this.requiredType.getCardinality(), null, 0, this);
            }
        }
        if (this.getSequence().hasSpecialProperty(0x2000000)) {
            this.b = true;
        }
        this.hasLoopingReference |= this.removeDeadReferences();
        if (!this.b) {
            var4_5 = (this.references != null && this.references.size() < 2 || this.getSequence() instanceof VariableReference != false) && this.isIndexedVariable == false && this.hasLoopingReference == false && this.b == false;
            if (var4_5) {
                this.verifyReferences();
                v4 = var4_5 = this.references != null;
            }
            if (var4_5 && this.references.isEmpty()) {
                this.getActionOp().optimize(var1_1, var2_2);
                var3_3.trace("Eliminated unused variable " + this.getVariableName(), this.getAction());
                return this.getAction();
            }
            if (var4_5 && this.references.size() == 1 && ExpressionTool.dependsOnFocus(this.getSequence())) {
                if (var1_1.isOptimizeForStreaming()) {
                    var4_5 = false;
                }
                var5_8 = this.references.get(0);
                var6_9 = var5_8.getParentExpression();
                while (var6_9 != null && var6_9 != this) {
                    var5_8 = ExpressionTool.findOperand((Expression)var6_9, var5_8);
                    if (!LetExpression.e && var5_8 == null) {
                        throw new AssertionError();
                    }
                    if (!var5_8.hasSameFocus()) {
                        var4_5 = false;
                        break;
                    }
                    var5_8 = var6_9;
                    var6_9 = var5_8.getParentExpression();
                }
            }
            if (var4_5 && this.references.size() == 1) {
                if (ExpressionTool.changesXsltContext(this.getSequence())) {
                    var4_5 = false;
                } else if ((this.getSequence().getDependencies() & 32) != 0) {
                    var4_5 = false;
                } else if (this.references.get(0).isInLoop()) {
                    var4_5 = false;
                }
            }
            if (var4_5 && (this.references.size() == 1 || this.getSequence() instanceof Literal || this.getSequence() instanceof VariableReference) && var3_3.isOptionSet(4)) {
                var4_6 = this;
                for (Object var6_9 : var4_6.references) {
                    var7_10 = var6_9.getParentExpression();
                    if (var7_10 == null) continue;
                    if ((var6_9 = ExpressionTool.findOperand(var7_10, (Expression)var6_9)) != null) {
                        var6_9.setChildExpression(var4_6.getSequence().copy(new RebindingMap()));
                    }
                    ExpressionTool.resetStaticProperties(var7_10);
                }
                var3_3.trace("Inlined references to $" + this.getVariableName(), this.getAction());
                this.references = null;
                return this.getAction().optimize(var1_1, var2_2);
            }
        }
        var4_7 = 0;
        while (var4_7++ < 5) {
            var5_8 = this.getSequence();
            this.getSequenceOp().optimize(var1_1, var2_2);
            if (this.getSequence() instanceof Literal && !this.isIndexedVariable) {
                return this.optimize(var1_1, var2_2);
            }
            if (var5_8 != this.getSequence()) continue;
        }
        var4_7 = 0;
        while (var4_7++ < 5) {
            var5_8 = this.getAction();
            this.getActionOp().optimize(var1_1, var2_2);
            if (var5_8 == this.getAction()) break;
            if (this.isIndexedVariable || this.b) continue;
            this.verifyReferences();
            if (this.references == null || this.references.size() >= 2) continue;
            if (this.references.isEmpty()) {
                this.hasLoopingReference = false;
                return this.optimize(var1_1, var2_2);
            }
            if (this.references.get(0).isInLoop()) continue;
            return this.optimize(var1_1, var2_2);
        }
        this.setEvaluator();
        return this;
    }

    public void setEvaluator() {
        if (this.b) {
            LetExpression letExpression = this;
            letExpression.setEvaluator(ExpressionTool.eagerEvaluator(letExpression.getSequence()));
            return;
        }
        if (this.isIndexedVariable()) {
            this.setEvaluator(Evaluator.MAKE_INDEXED_VARIABLE);
            return;
        }
        if (this.a == null) {
            LetExpression letExpression = this;
            letExpression.setEvaluator(ExpressionTool.lazyEvaluator(letExpression.getSequence(), this.getNominalReferenceCount() > 1));
        }
    }

    @Override
    public double getCost() {
        return this.getSequence().getCost() + this.getAction().getCost();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getAction().checkPermittedContents(schemaType, bl2);
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    @Override
    public int getImplementationMethod() {
        return this.getAction().getImplementationMethod();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        return letExpression.getAction().iterate(xPathContext);
    }

    public Sequence<?> eval(XPathContext xPathContext) {
        if (this.a == null) {
            LetExpression letExpression = this;
            letExpression.setEvaluator(ExpressionTool.lazyEvaluator(letExpression.getSequence(), this.getNominalReferenceCount() > 1));
        }
        try {
            int n2 = xPathContext.getTemporaryOutputState();
            xPathContext.setTemporaryOutputState(206);
            Sequence<?> sequence = this.a.evaluate(this.getSequence(), xPathContext);
            xPathContext.setTemporaryOutputState(n2);
            return sequence;
        }
        catch (ClassCastException classCastException) {
            assert (false);
            int n3 = xPathContext.getTemporaryOutputState();
            xPathContext.setTemporaryOutputState(206);
            Sequence<?> sequence = Evaluator.EAGER_SEQUENCE.evaluate(this.getSequence(), xPathContext);
            xPathContext.setTemporaryOutputState(n3);
            return sequence;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        return letExpression.getAction().evaluateItem(xPathContext);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        return letExpression.getAction().effectiveBooleanValue(xPathContext);
    }

    @Override
    public void process(XPathContext xPathContext) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        letExpression.getAction().process(xPathContext);
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (((Expression)this).isInstruction()) {
            return UType.ANY;
        }
        return this.getAction().getStaticUType(uType);
    }

    @Override
    public int computeCardinality() {
        return this.getAction().getCardinality();
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = this.getAction().getSpecialProperties();
        int n3 = this.getSequence().getSpecialProperties();
        if ((n3 & 0x800000) == 0) {
            n2 &= 0xFF7FFFFF;
        }
        return n2;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName structuredQName, int n2) {
        return ExpressionTool.markTailFunctionCalls(this.getAction(), structuredQName, n2);
    }

    @Override
    public Expression copy(RebindingMap object) {
        LetExpression letExpression = new LetExpression();
        ExpressionTool.copyLocationInfo(this, letExpression);
        letExpression.isIndexedVariable = this.isIndexedVariable;
        letExpression.hasLoopingReference = this.hasLoopingReference;
        letExpression.setNeedsEagerEvaluation(this.b);
        letExpression.setNeedsLazyEvaluation(this.c);
        letExpression.setVariableQName(this.variableName);
        letExpression.setRequiredType(this.requiredType);
        letExpression.setSequence(this.getSequence().copy((RebindingMap)object));
        letExpression.setInstruction(((Expression)this).isInstruction());
        ((RebindingMap)object).put(this, letExpression);
        object = this.getAction().copy((RebindingMap)object);
        letExpression.setAction((Expression)object);
        return letExpression;
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        if (letExpression.getAction() instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)letExpression.getAction())).processLeavingTail(xPathContext);
        }
        letExpression.getAction().process(xPathContext);
        return null;
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        LetExpression letExpression = this;
        while (true) {
            Sequence<?> sequence = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.getLocalSlotNumber(), sequence);
            if (!(letExpression.getAction() instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.getAction();
        }
        letExpression.getAction().evaluatePendingUpdates(xPathContext, pendingUpdateList);
    }

    @Override
    public String toString() {
        return "let $" + this.getVariableEQName() + " := " + this.getSequence() + " return " + ExpressionTool.parenthesize(this.getAction());
    }

    @Override
    public String toShortString() {
        return "let $" + this.getVariableName() + " := ...";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("let", this);
        expressionPresenter.emitAttribute("var", this.variableName);
        expressionPresenter.emitAttribute("as", this.getSequence().getStaticType().toExportString());
        ExpressionPresenter.ExportOptions exportOptions = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if (exportOptions.target.equals("JS") && exportOptions.targetVersion == 2) {
            expressionPresenter.emitAttribute("asJ", this.getSequence().getStaticType().toExportString2());
        }
        if (this.isIndexedVariable()) {
            expressionPresenter.emitAttribute("indexable", "true");
        }
        expressionPresenter.emitAttribute("slot", "" + this.getLocalSlotNumber());
        if (this.a == null) {
            LetExpression letExpression = this;
            letExpression.setEvaluator(ExpressionTool.lazyEvaluator(letExpression.getSequence(), this.getNominalReferenceCount() > 1));
        }
        expressionPresenter.emitAttribute("eval", "" + this.getEvaluator().getCode());
        this.getSequence().export(expressionPresenter);
        this.getAction().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public void setEvaluator(Evaluator evaluator) {
        this.a = evaluator;
    }

    public void setEvaluationMode(int n2) {
        this.a = Evaluator.evaluatorForCode(n2);
    }

    public Evaluator getEvaluator() {
        return this.a;
    }
}

