/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ListConstructorFunction
extends AbstractFunction {
    protected ListType targetType;
    protected NamespaceResolver nsResolver;
    protected boolean allowEmpty;
    protected SimpleType memberType;

    public ListConstructorFunction(ListType listType, NamespaceResolver namespaceResolver, boolean bl2) {
        this.targetType = listType;
        this.nsResolver = namespaceResolver;
        this.allowEmpty = bl2;
        this.memberType = listType.getItemType();
    }

    public ListType getTargetType() {
        return this.targetType;
    }

    public SimpleType getMemberType() {
        return this.memberType;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        AtomicType atomicType = BuiltInAtomicType.ANY_ATOMIC;
        if (this.memberType.isAtomicType()) {
            atomicType = (AtomicType)this.memberType;
        }
        SequenceType sequenceType = this.allowEmpty ? SequenceType.OPTIONAL_ATOMIC : SequenceType.SINGLE_ATOMIC;
        return new SpecificFunctionType(new SequenceType[]{sequenceType}, SequenceType.makeSequenceType(atomicType, 57344));
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.targetType.getStructuredQName();
    }

    @Override
    public String getDescription() {
        return this.getFunctionName().getDisplayName();
    }

    @Override
    public int getArity() {
        return 1;
    }

    public AtomicSequence call(XPathContext object, Sequence[] object2) {
        if ((object2 = (AtomicValue)object2[0].head()) == null) {
            if (this.allowEmpty) {
                return EmptyAtomicSequence.getInstance();
            }
            object = new XPathException("Cast expression does not allow an empty sequence to be supplied", "XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        if (!(object2 instanceof StringValue) || object2 instanceof AnyURIValue) {
            object = new XPathException("Only xs:string and xs:untypedAtomic can be cast to a list type", "XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        object = object.getConfiguration().getConversionRules();
        ValidationFailure validationFailure = this.targetType.validateContent((CharSequence)(object2 = ((AtomicValue)object2).getStringValueCS()), this.nsResolver, (ConversionRules)object);
        if (validationFailure != null) {
            throw validationFailure.makeException();
        }
        return this.targetType.getTypedValue((CharSequence)object2, this.nsResolver, (ConversionRules)object);
    }
}

