/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class Literal
extends Expression {
    private GroundedValue<?> a;

    protected Literal(GroundedValue<?> groundedValue) {
        this.a = groundedValue.reduce();
    }

    public static Literal makeStringsLiteral(List<String> groundedValue) {
        ArrayList<StringValue> arrayList = new ArrayList<StringValue>();
        for (String string : groundedValue) {
            arrayList.add(new StringValue(string));
        }
        groundedValue = SequenceExtent.makeSequenceExtent(arrayList);
        return Literal.makeLiteral(groundedValue);
    }

    public GroundedValue<?> getValue() {
        return this.a;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public ItemType getItemType() {
        if (this.a instanceof AtomicValue) {
            return ((AtomicValue)this.a).getItemType();
        }
        if (this.a.getLength() == 0) {
            return ErrorType.getInstance();
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        return SequenceTool.getItemType(this.a, typeHierarchy);
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (this.a.getLength() == 0) {
            return UType.VOID;
        }
        if (this.a instanceof AtomicValue) {
            return ((AtomicValue)this.a).getUType();
        }
        if (this.a instanceof Function) {
            return UType.FUNCTION;
        }
        return super.getStaticUType(uType);
    }

    @Override
    public int computeCardinality() {
        if (this.a.getLength() == 0) {
            return 8192;
        }
        if (this.a instanceof AtomicValue) {
            return 16384;
        }
        try {
            SequenceIterator sequenceIterator = this.a.iterate();
            Object t2 = sequenceIterator.next();
            if (t2 == null) {
                return 8192;
            }
            if (sequenceIterator.next() != null) {
                return 32768;
            }
            return 16384;
        }
        catch (XPathException xPathException) {
            return 57344;
        }
    }

    @Override
    public int computeSpecialProperties() {
        if (this.a.getLength() == 0) {
            return 0xDFF0000;
        }
        return 0x800000;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.a instanceof IntegerValue) {
            return new IntegerValue[]{(IntegerValue)this.a, (IntegerValue)this.a};
        }
        if (this.a instanceof IntegerRange) {
            return new IntegerValue[]{Int64Value.makeIntegerValue(((IntegerRange)this.a).getStart()), Int64Value.makeIntegerValue(((IntegerRange)this.a).getEnd())};
        }
        return null;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.a.getLength() == 0;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new Literal(this.a);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        if (Literal.isEmptySequence(this)) {
            return new NodeTestPattern(ErrorType.getInstance());
        }
        return super.toPattern(configuration);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    @Override
    public final int getDependencies() {
        return 0;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return this.a.iterate();
    }

    public SequenceIterator iterate() {
        return this.a.iterate();
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.a.head();
    }

    @Override
    public void process(XPathContext object) {
        object = object.getReceiver();
        if (this.a instanceof Item) {
            object.append((Item)this.a, this.getLocation(), 524288);
            return;
        }
        this.a.iterate().forEachOrFail(arg_0 -> this.a((Receiver)object, arg_0));
    }

    @Override
    public int getImplementationMethod() {
        return 7;
    }

    @Override
    public CharSequence evaluateAsString(XPathContext object) {
        if ((object = (AtomicValue)((Expression)this).evaluateItem((XPathContext)object)) == null) {
            return "";
        }
        return ((AtomicValue)object).getStringValueCS();
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.a.effectiveBooleanValue();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        if (this.a.getLength() != 0) {
            super.evaluatePendingUpdates(xPathContext, pendingUpdateList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        Object t2;
        Object t3;
        if (!(object instanceof Literal)) {
            return false;
        }
        Object object2 = this.a;
        object = ((Literal)object).a;
        try {
            object2 = object2.iterate();
            object = object.iterate();
            while (true) {
                t3 = object2.next();
                t2 = object.next();
                if (t3 == null && t2 == null) {
                    return true;
                }
                if (t3 == null || t2 == null) {
                    return false;
                }
                if (t3 == t2) continue;
                break;
            }
        }
        catch (XPathException xPathException) {
            return false;
        }
        {
            boolean bl2;
            boolean bl3;
            block10: {
                bl3 = t3 instanceof NodeInfo;
                bl2 = t2 instanceof NodeInfo;
                if (bl3 != bl2) {
                    return false;
                }
                if (!bl3) break block10;
                if (t3.equals(t2)) continue;
                return false;
            }
            bl3 = t3 instanceof AtomicValue;
            bl2 = t2 instanceof AtomicValue;
            if (bl3 != bl2) {
                return false;
            }
            if (!bl3) return false;
            if (!((AtomicValue)t3).isIdentical((AtomicValue)t2) || ((AtomicValue)t3).getItemType() != ((AtomicValue)t2).getItemType()) return false;
            continue;
        }
    }

    @Override
    public int computeHashCode() {
        if (this.a instanceof AtomicSequence) {
            return ((AtomicSequence)this.a).getSchemaComparable().hashCode();
        }
        return super.computeHashCode();
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        Literal.exportValue(this.a, expressionPresenter);
    }

    public static void exportValue(Sequence<?> sequence, ExpressionPresenter expressionPresenter) {
        block18: {
            block20: {
                int n2;
                block19: {
                    if (sequence.head() == null) {
                        expressionPresenter.startElement("empty");
                        expressionPresenter.endElement();
                        return;
                    }
                    if (sequence instanceof AtomicValue) {
                        Literal.exportAtomicValue((AtomicValue)sequence, expressionPresenter);
                        return;
                    }
                    if (sequence instanceof IntegerRange) {
                        expressionPresenter.startElement("range");
                        expressionPresenter.emitAttribute("from", "" + ((IntegerRange)sequence).getStart());
                        expressionPresenter.emitAttribute("to", "" + ((IntegerRange)sequence).getEnd());
                        expressionPresenter.endElement();
                        return;
                    }
                    if (!(sequence instanceof NodeInfo)) break block18;
                    expressionPresenter.startElement("node");
                    n2 = ((NodeInfo)sequence).getNodeKind();
                    expressionPresenter.emitAttribute("kind", "" + n2);
                    if (!((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).explaining) break block19;
                    String string = ((NodeInfo)sequence).getDisplayName();
                    if (string.isEmpty()) break block20;
                    expressionPresenter.emitAttribute("name", string);
                    break block20;
                }
                switch (n2) {
                    case 1: 
                    case 9: {
                        StringWriter stringWriter = new StringWriter();
                        Properties properties = new Properties();
                        properties.setProperty("method", "xml");
                        properties.setProperty("indent", "no");
                        properties.setProperty("omit-xml-declaration", "yes");
                        QueryResult.serialize((NodeInfo)sequence, (Result)new StreamResult(stringWriter), properties);
                        expressionPresenter.emitAttribute("content", stringWriter.toString());
                        expressionPresenter.emitAttribute("baseUri", ((NodeInfo)sequence).getBaseURI());
                        break;
                    }
                    case 3: 
                    case 8: {
                        expressionPresenter.emitAttribute("content", ((NodeInfo)sequence).getStringValue());
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 13: {
                        StructuredQName structuredQName = NameOfNode.makeName((NodeInfo)sequence).getStructuredQName();
                        if (!structuredQName.getLocalPart().isEmpty()) {
                            expressionPresenter.emitAttribute("localName", structuredQName.getLocalPart());
                        }
                        if (!structuredQName.getPrefix().isEmpty()) {
                            expressionPresenter.emitAttribute("prefix", structuredQName.getPrefix());
                        }
                        if (!structuredQName.getURI().isEmpty()) {
                            expressionPresenter.emitAttribute("ns", structuredQName.getURI());
                        }
                        expressionPresenter.emitAttribute("content", ((NodeInfo)sequence).getStringValue());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            expressionPresenter.endElement();
            return;
        }
        if (sequence instanceof MapItem) {
            expressionPresenter.startElement("map");
            expressionPresenter.emitAttribute("size", "" + ((MapItem)sequence).size());
            for (KeyValuePair keyValuePair : ((MapItem)sequence).keyValuePairs()) {
                Literal.exportAtomicValue(keyValuePair.key, expressionPresenter);
                Literal.exportValue(keyValuePair.value, expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        if (sequence instanceof Function) {
            ((Function)sequence).export(expressionPresenter);
            return;
        }
        if (sequence instanceof ExternalObject) {
            if (((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).explaining) {
                expressionPresenter.startElement("externalObject");
                expressionPresenter.emitAttribute("class", ((ExternalObject)sequence).getObject().getClass().getName());
                expressionPresenter.endElement();
                return;
            }
            throw new XPathException("Cannot export a stylesheet containing literal values bound to external Java objects");
        }
        expressionPresenter.startElement("literal");
        if (sequence instanceof GroundedValue) {
            expressionPresenter.emitAttribute("count", "" + ((GroundedValue)sequence).getLength());
        }
        sequence.iterate().forEachOrFail(item -> Literal.exportValue(item, expressionPresenter));
        expressionPresenter.endElement();
    }

    @Override
    public String getExpressionName() {
        return "literal";
    }

    public static void exportAtomicValue(AtomicValue atomicValue, ExpressionPresenter expressionPresenter) {
        if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
            atomicValue.checkValidInJavascript();
        }
        AtomicType atomicType = atomicValue.getItemType();
        String string = atomicValue.getStringValue();
        if (atomicType.equals(BuiltInAtomicType.STRING)) {
            expressionPresenter.startElement("str");
            expressionPresenter.emitAttribute("val", string);
            expressionPresenter.endElement();
            return;
        }
        if (atomicType.equals(BuiltInAtomicType.INTEGER)) {
            expressionPresenter.startElement("int");
            expressionPresenter.emitAttribute("val", string);
            expressionPresenter.endElement();
            return;
        }
        if (atomicType.equals(BuiltInAtomicType.DECIMAL)) {
            expressionPresenter.startElement("dec");
            expressionPresenter.emitAttribute("val", string);
            expressionPresenter.endElement();
            return;
        }
        if (atomicType.equals(BuiltInAtomicType.DOUBLE)) {
            expressionPresenter.startElement("dbl");
            expressionPresenter.emitAttribute("val", string);
            expressionPresenter.endElement();
            return;
        }
        if (atomicType.equals(BuiltInAtomicType.BOOLEAN)) {
            expressionPresenter.startElement(((AtomicValue)((BooleanValue)atomicValue)).effectiveBooleanValue() ? "true" : "false");
            expressionPresenter.endElement();
            return;
        }
        if (atomicValue instanceof QualifiedNameValue) {
            expressionPresenter.startElement("qName");
            expressionPresenter.emitAttribute("pre", ((QualifiedNameValue)atomicValue).getPrefix());
            expressionPresenter.emitAttribute("uri", ((QualifiedNameValue)atomicValue).getNamespaceURI());
            expressionPresenter.emitAttribute("loc", ((QualifiedNameValue)atomicValue).getLocalName());
            if (!atomicType.equals(BuiltInAtomicType.QNAME)) {
                expressionPresenter.emitAttribute("type", atomicType.getTypeName());
            }
            expressionPresenter.endElement();
            return;
        }
        expressionPresenter.startElement("atomic");
        expressionPresenter.emitAttribute("val", string);
        expressionPresenter.emitAttribute("type", atomicType.toExportString());
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        if (this.a.getLength() == 0) {
            return "()";
        }
        if (this.a instanceof AtomicValue) {
            return this.a.toString();
        }
        return "(" + this.a.head() + ",...)";
    }

    public static boolean isAtomic(Expression expression) {
        return expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression expression) {
        return expression instanceof Literal && ((Literal)expression).getValue().getLength() == 0;
    }

    public static boolean isConstantBoolean(Expression object, boolean bl2) {
        if (object instanceof Literal) {
            return (object = ((Literal)object).getValue()) instanceof BooleanValue && ((BooleanValue)object).getBooleanValue() == bl2;
        }
        return false;
    }

    public static boolean hasEffectiveBooleanValue(Expression expression, boolean bl2) {
        if (expression instanceof Literal) {
            try {
                return bl2 == ((Literal)expression).getValue().effectiveBooleanValue();
            }
            catch (XPathException xPathException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isConstantOne(Expression object) {
        if (object instanceof Literal) {
            return (object = ((Literal)object).getValue()) instanceof Int64Value && ((NumericValue)((Int64Value)object)).longValue() == 1L;
        }
        return false;
    }

    @Override
    public boolean isSubtreeExpression() {
        return true;
    }

    public static Literal makeEmptySequence() {
        return new Literal(EmptySequence.getInstance());
    }

    public static <T extends Item<?>> Literal makeLiteral(GroundedValue<T> groundedValue) {
        if ((groundedValue = groundedValue.reduce()) instanceof StringValue) {
            return new StringLiteral((StringValue)groundedValue);
        }
        return new Literal(groundedValue);
    }

    public static Literal makeLiteral(GroundedValue<?> object, Expression expression) {
        object = Literal.makeLiteral(object);
        ExpressionTool.copyLocationInfo(expression, (Expression)object);
        return object;
    }

    @Override
    public String getStreamerName() {
        return "Literal";
    }

    private /* synthetic */ void a(Receiver receiver, Item item) {
        receiver.append(item, this.getLocation(), 524288);
    }
}

