/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;

public class LocalVariableReference
extends VariableReference {
    private int a = -999;

    public LocalVariableReference(StructuredQName structuredQName) {
        super(structuredQName);
    }

    public LocalVariableReference(LocalBinding localBinding) {
        super(localBinding);
    }

    @Override
    public Expression copy(RebindingMap object) {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        LocalVariableReference localVariableReference = new LocalVariableReference(this.getVariableName());
        localVariableReference.copyFrom(this);
        localVariableReference.a = this.a;
        object = ((RebindingMap)object).get(this.binding);
        if (object != null) {
            localVariableReference.binding = object;
        }
        localVariableReference.binding.addReference(localVariableReference, this.isInLoop());
        return localVariableReference;
    }

    @Override
    public LocalBinding getBinding() {
        return (LocalBinding)super.getBinding();
    }

    public void setSlotNumber(int n2) {
        this.a = n2;
    }

    public int getSlotNumber() {
        return this.a;
    }

    @Override
    public Sequence<?> evaluateVariable(XPathContext xPathContext) {
        try {
            return xPathContext.getStackFrame().slots[this.a];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.a == -999) {
                if (this.binding != null) {
                    try {
                        this.a = this.getBinding().getLocalSlotNumber();
                        return xPathContext.getStackFrame().slots[this.a];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {}
                }
                throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " has not been allocated a stack frame slot");
            }
            int n2 = xPathContext.getStackFrame().slots.length;
            throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " uses slot " + this.a + " but " + (n2 == 0 ? "no" : "only " + xPathContext.getStackFrame().slots.length) + " slots are allocated on the stack frame");
        }
    }

    @Override
    public String getExpressionName() {
        return "locVarRef";
    }
}

