/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class LookupAllExpression
extends UnaryExpression {
    public LookupAllExpression(Expression expression) {
        super(expression);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.INSPECT;
    }

    @Override
    public final ItemType getItemType() {
        ItemType itemType = this.getBaseExpression().getItemType();
        if (itemType instanceof MapType) {
            return ((MapType)itemType).getValueType().getPrimaryType();
        }
        if (itemType instanceof ArrayItemType) {
            return ((ArrayItemType)itemType).getMemberType().getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return ((Expression)this).getItemType().getUType();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        boolean bl2;
        Object object3 = ((ExpressionVisitor)object).getConfiguration();
        object3 = ((Configuration)object3).getTypeHierarchy();
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = this.getBaseExpression().getItemType();
        boolean bl3 = object2 instanceof ArrayItemType;
        boolean bl4 = bl2 = object2 instanceof MapType || object2 instanceof TupleType;
        if (!bl3 && !bl2 && ((TypeHierarchy)object3).relationship((ItemType)object2, MapType.ANY_MAP_TYPE) == 4 && ((TypeHierarchy)object3).relationship((ItemType)object2, ArrayItemType.getInstance()) == 4) {
            object = new XPathException("The left-hand operand of '?' must be a map or an array; the supplied expression is of type " + object2, "XPTY0004");
            ((XPathException)object).setLocation(this.getLocation());
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setFailingExpression(this);
            throw object;
        }
        if (this.getBaseExpression() instanceof Literal) {
            return new Literal(((Expression)this).iterate(((ExpressionVisitor)object).makeDynamicContext()).materialize());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo expressionArray) {
        this.getOperand().optimize((ExpressionVisitor)((Object)object), (ContextItemStaticInfo)expressionArray);
        if (this.getBaseExpression() instanceof Literal) {
            return new Literal(((Expression)this).iterate(((ExpressionVisitor)((Object)object)).makeDynamicContext()).materialize());
        }
        if (this.getBaseExpression() instanceof SquareArrayConstructor) {
            object = new ArrayList<Expression>();
            for (Operand object22 : this.getBaseExpression().operands()) {
                object.add(object22.getChildExpression().copy(new RebindingMap()));
            }
            expressionArray = object.toArray(new Expression[0]);
            Block block = new Block((Expression[])expressionArray);
            ExpressionTool.copyLocationInfo(this, block);
            return block;
        }
        return this;
    }

    @Override
    public double getCost() {
        return this.getBaseExpression().getCost() + 1.0;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public LookupAllExpression copy(RebindingMap rebindingMap) {
        return new LookupAllExpression(this.getBaseExpression().copy(rebindingMap));
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LookupAllExpression)) {
            return false;
        }
        object = (LookupAllExpression)object;
        return this.getBaseExpression().isEqual(((UnaryExpression)object).getBaseExpression());
    }

    @Override
    public int computeHashCode() {
        return "LookupAll".hashCode() ^ this.getBaseExpression().hashCode();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return new SequenceIterator(this, xPathContext){
            private SequenceIterator a;
            private Iterator<?> b;
            private UnfailingIterator c;
            private /* synthetic */ XPathContext d;
            private /* synthetic */ LookupAllExpression e;
            {
                this.e = lookupAllExpression;
                this.d = xPathContext;
                this.a = this.e.getBaseExpression().iterate(this.d);
                this.b = null;
                this.c = null;
            }

            public final Item next() {
                Object object;
                while (true) {
                    if (this.c == null) {
                        if (this.b == null) {
                            object = this.a.next();
                            if (object == null) {
                                return null;
                            }
                            if (object instanceof ArrayItem) {
                                this.b = ((ArrayItem)object).members().iterator();
                                continue;
                            }
                            if (object instanceof MapItem) {
                                this.b = ((MapItem)object).keyValuePairs().iterator();
                                continue;
                            }
                            LookupExpression.mustBeArrayOrMap(this.e, object);
                            return null;
                        }
                        if (this.b.hasNext()) {
                            object = this.b.next();
                            if (object instanceof KeyValuePair) {
                                object = ((KeyValuePair)object).value;
                                this.c = object.iterate();
                                continue;
                            }
                            if (object instanceof GroundedValue) {
                                this.c = ((GroundedValue)object).iterate();
                                continue;
                            }
                            throw new IllegalStateException();
                        }
                        this.b = null;
                        continue;
                    }
                    object = this.c.next();
                    if (object != null) break;
                    this.c = null;
                }
                return object;
            }

            @Override
            public final void close() {
                if (this.a != null) {
                    this.a.close();
                }
                if (this.c != null) {
                    this.c.close();
                }
            }
        };
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("lookupAll", this);
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "?*";
    }

    @Override
    public String toShortString() {
        return this.getBaseExpression().toShortString() + "?*";
    }
}

