/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyExternalObjectType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class LookupExpression
extends BinaryExpression {
    private boolean a = false;
    protected boolean isArrayLookup = false;
    protected boolean isMapLookup = false;
    protected boolean isSingleContainer = false;
    protected boolean isSingleEntry = false;

    public LookupExpression(Expression expression, Expression expression2) {
        super(expression, 213, expression2);
    }

    @Override
    protected OperandRole getOperandRole(int n2) {
        if (n2 == 0) {
            return OperandRole.INSPECT;
        }
        return OperandRole.ABSORB;
    }

    @Override
    public String getExpressionName() {
        return "lookupExp";
    }

    @Override
    public ItemType getItemType() {
        if (this.a) {
            if (this.isArrayLookup) {
                ItemType itemType = this.getLhsExpression().getItemType();
                if (itemType instanceof ArrayItemType) {
                    return ((ArrayItemType)itemType).getMemberType().getPrimaryType();
                }
            } else if (this.isMapLookup) {
                Object object = this.getLhsExpression().getItemType();
                if (object instanceof TupleItemType && this.getRhsExpression() instanceof StringLiteral) {
                    String string = ((StringLiteral)this.getRhsExpression()).getStringValue();
                    if ((object = ((TupleItemType)object).getFieldType(string)) == null) {
                        return ErrorType.getInstance();
                    }
                    return ((SequenceType)object).getPrimaryType();
                }
                if (object instanceof MapType) {
                    return ((MapType)object).getValueType().getPrimaryType();
                }
            }
        }
        return AnyItemType.getInstance();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return ((Expression)this).getItemType().getUType();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        Object object3 = ((ExpressionVisitor)object).getConfiguration();
        Object object4 = ((Configuration)object3).getTypeHierarchy();
        this.getLhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        ItemType itemType = this.getLhsExpression().getItemType();
        this.isArrayLookup = itemType instanceof ArrayItemType;
        boolean bl2 = itemType instanceof TupleType;
        boolean bl3 = this.isMapLookup = itemType instanceof MapType || bl2;
        if (itemType instanceof AnyExternalObjectType) {
            ((Configuration)object3).checkLicensedFeature(8, "use of lookup expressions on external objects", -1);
            return ((Configuration)object3).makeObjectLookupExpression(this.getLhsExpression(), this.getRhsExpression()).typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        }
        boolean bl4 = this.isSingleContainer = this.getLhsExpression().getCardinality() == 16384;
        if (!this.isArrayLookup && !this.isMapLookup && ((TypeHierarchy)object4).relationship(itemType, MapType.ANY_MAP_TYPE) == 4 && ((TypeHierarchy)object4).relationship(itemType, ArrayItemType.getInstance()) == 4 && ((TypeHierarchy)object4).relationship(itemType, AnyExternalObjectType.THE_INSTANCE) == 4) {
            object2 = new XPathException("The left-hand operand of '?' must be a map or an array; the supplied expression is of type " + itemType, "XPTY0004");
            ((XPathException)object2).setLocation(this.getLocation());
            ((XPathException)object2).setIsTypeError(true);
            ((XPathException)object2).setFailingExpression(this);
            throw object2;
        }
        this.getRhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = new RoleDiagnostic(1, "?", 1);
        object3 = ((Configuration)object3).getTypeChecker(false);
        object4 = BuiltInAtomicType.ANY_ATOMIC.zeroOrMore();
        if (this.isArrayLookup) {
            object4 = BuiltInAtomicType.INTEGER.zeroOrMore();
        }
        this.setRhsExpression(((TypeChecker)object3).staticTypeCheck(this.getRhsExpression(), (SequenceType)object4, (RoleDiagnostic)object2, (ExpressionVisitor)object));
        boolean bl5 = this.isSingleEntry = this.getRhsExpression().getCardinality() == 16384;
        if (bl2 && this.getRhsExpression() instanceof StringLiteral && ((TupleType)itemType).getFieldType((String)(object = ((StringLiteral)this.getRhsExpression()).getStringValue())) == null) {
            object = new XPathException("Field " + (String)object + " is not defined in the tuple type", "SXTT0001");
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        this.a = true;
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getLhs().optimize(expressionVisitor, contextItemStaticInfo);
        this.getRhs().optimize(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public double getCost() {
        return this.getLhsExpression().getCost() * this.getRhsExpression().getCost();
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public LookupExpression copy(RebindingMap object) {
        object = new LookupExpression(this.getLhsExpression().copy((RebindingMap)object), this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((LookupExpression)object).isArrayLookup = this.isArrayLookup;
        ((LookupExpression)object).isMapLookup = this.isMapLookup;
        ((LookupExpression)object).isSingleEntry = this.isSingleEntry;
        ((LookupExpression)object).isSingleContainer = this.isSingleContainer;
        return object;
    }

    @Override
    public int computeCardinality() {
        if (this.isSingleContainer && this.isSingleEntry) {
            if (this.isArrayLookup) {
                ItemType itemType = this.getLhsExpression().getItemType();
                if (itemType instanceof ArrayItemType) {
                    return ((ArrayItemType)itemType).getMemberType().getCardinality();
                }
            } else if (this.isMapLookup) {
                ItemType itemType = this.getLhsExpression().getItemType();
                if (itemType instanceof TupleItemType && this.getRhsExpression() instanceof StringLiteral) {
                    String string = ((StringLiteral)this.getRhsExpression()).getStringValue();
                    SequenceType sequenceType = ((TupleItemType)itemType).getFieldType(string);
                    boolean bl2 = ((TupleItemType)itemType).isOptional(string);
                    int n2 = sequenceType.getCardinality();
                    if (bl2) {
                        n2 = Cardinality.union(n2, 8192);
                    }
                    if (sequenceType == null) {
                        return 8192;
                    }
                    return n2;
                }
                if (itemType instanceof MapType) {
                    return ((MapType)itemType).getValueType().getCardinality();
                }
            }
        }
        return 57344;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LookupExpression)) {
            return false;
        }
        object = (LookupExpression)object;
        return this.getLhsExpression().isEqual(((BinaryExpression)object).getLhsExpression()) && this.getRhsExpression().isEqual(((BinaryExpression)object).getRhsExpression());
    }

    @Override
    public int computeHashCode() {
        return "LookupExpression".hashCode() ^ this.getLhsExpression().hashCode() ^ this.getRhsExpression().hashCode();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext groundedValue) {
        Configuration configuration = groundedValue.getConfiguration();
        if (this.isArrayLookup) {
            if (this.isSingleContainer && this.isSingleEntry) {
                ArrayItem arrayItem = (ArrayItem)this.getLhsExpression().evaluateItem((XPathContext)((Object)groundedValue));
                groundedValue = (IntegerValue)this.getRhsExpression().evaluateItem((XPathContext)((Object)groundedValue));
                return arrayItem.get((int)((NumericValue)groundedValue).longValue() - 1).iterate();
            }
            if (this.isSingleEntry) {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)((Object)groundedValue));
                int n2 = (int)((IntegerValue)this.getRhsExpression().evaluateItem((XPathContext)((Object)groundedValue))).longValue() - 1;
                return new MappingIterator(sequenceIterator, item -> ((ArrayItem)item).get(n2).iterate());
            }
            SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)((Object)groundedValue));
            groundedValue = this.getRhsExpression().iterate((XPathContext)((Object)groundedValue)).materialize();
            return new MappingIterator(sequenceIterator, item -> new MappingIterator(groundedValue.iterate(), item2 -> ((ArrayItem)item).get((int)((IntegerValue)item2).longValue() - 1).iterate()));
        }
        if (this.isMapLookup) {
            if (this.isSingleContainer && this.isSingleEntry) {
                MapItem mapItem = (MapItem)this.getLhsExpression().evaluateItem((XPathContext)((Object)groundedValue));
                groundedValue = (AtomicValue)this.getRhsExpression().evaluateItem((XPathContext)((Object)groundedValue));
                if ((groundedValue = mapItem.get((AtomicValue)groundedValue)) == null) {
                    return EmptyIterator.emptyIterator();
                }
                return groundedValue.iterate();
            }
            if (this.isSingleEntry) {
                SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)((Object)groundedValue));
                groundedValue = (AtomicValue)this.getRhsExpression().evaluateItem((XPathContext)((Object)groundedValue));
                return new MappingIterator(sequenceIterator, arg_0 -> LookupExpression.a((AtomicValue)groundedValue, arg_0));
            }
            SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)((Object)groundedValue));
            groundedValue = this.getRhsExpression().iterate((XPathContext)((Object)groundedValue)).materialize();
            return new MappingIterator(sequenceIterator, item2 -> new MappingIterator(groundedValue.iterate(), item -> {
                if ((item2 = ((MapItem)item2).get((AtomicValue)item)) == null) {
                    return EmptyIterator.emptyIterator();
                }
                return item2.iterate();
            }));
        }
        SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)((Object)groundedValue));
        groundedValue = this.getRhsExpression().iterate((XPathContext)((Object)groundedValue)).materialize();
        groundedValue = item2 -> {
            if (item2 instanceof ArrayItem) {
                MappingFunction mappingFunction = item -> {
                    if (item instanceof IntegerValue) {
                        item2 = ((ArrayItem)item2).get((int)((IntegerValue)item).longValue() - 1);
                        return item2.iterate();
                    }
                    item2 = new XPathException("An item on the LHS of the '?' operator is an array, but a value on the RHS of the operator (" + item2.toShortString() + ") is not an integer", "XPTY0004");
                    ((XPathException)((Object)item2)).setIsTypeError(true);
                    ((XPathException)((Object)item2)).setLocation(this.getLocation());
                    ((XPathException)((Object)item2)).setFailingExpression(this);
                    throw item2;
                };
                groundedValue = groundedValue.iterate();
                return new MappingIterator((SequenceIterator<Item>)((Object)groundedValue), mappingFunction);
            }
            if (item2 instanceof MapItem) {
                SequenceIterator sequenceIterator = groundedValue.iterate();
                return new MappingIterator(sequenceIterator, item -> {
                    if ((item2 = ((MapItem)item2).get((AtomicValue)item)) == null) {
                        return EmptyIterator.emptyIterator();
                    }
                    return item2.iterate();
                });
            }
            if (item2 instanceof ObjectValue) {
                if (!(groundedValue instanceof StringValue)) {
                    XPathException xPathException = new XPathException("An item on the LHS of the '?' operator is an external object, but a value on the RHS of the operator (" + item2.toShortString() + ") is not a singleton string", "XPTY0004");
                    xPathException.setIsTypeError(true);
                    xPathException.setLocation(this.getLocation());
                    xPathException.setFailingExpression(this);
                    throw xPathException;
                }
                String string = groundedValue.getStringValue();
                return configuration.externalObjectAsMap((ObjectValue)item2, string).get((StringValue)groundedValue).iterate();
            }
            LookupExpression.mustBeArrayOrMap(this, item2);
            return null;
        };
        return new MappingIterator(sequenceIterator, groundedValue);
    }

    protected static void mustBeArrayOrMap(Expression expression, Item object) {
        object = new XPathException("The items on the LHS of the '?' operator must be maps or arrays; but value (" + object.toShortString() + ") was supplied", "XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        ((XPathException)object).setLocation(expression.getLocation());
        ((XPathException)object).setFailingExpression(expression);
        throw object;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("lookup", this);
        this.getLhsExpression().export(expressionPresenter);
        this.getRhsExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        Object object;
        object = this.getRhsExpression() instanceof Literal ? ((object = (Literal)this.getRhsExpression()) instanceof StringLiteral && NameChecker.isValidNCName(((StringLiteral)object).getStringValue()) ? ((StringLiteral)object).getStringValue() : (((Literal)object).getValue() instanceof Int64Value ? ((Literal)object).getValue().toString() : ExpressionTool.parenthesize((Expression)object))) : ExpressionTool.parenthesize(this.getRhsExpression());
        return ExpressionTool.parenthesize(this.getLhsExpression()) + "?" + (String)object;
    }

    private static /* synthetic */ SequenceIterator a(AtomicValue groundedValue, Item item) {
        if ((groundedValue = ((MapItem)item).get((AtomicValue)groundedValue)) == null) {
            return EmptyIterator.emptyIterator();
        }
        return groundedValue.iterate();
    }
}

