/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class NegateExpression
extends UnaryExpression {
    private boolean a;

    public NegateExpression(Expression expression) {
        super(expression);
    }

    public void setBackwardsCompatible(boolean bl2) {
        this.a = bl2;
    }

    public boolean isBackwardsCompatible() {
        return this.a;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor groundedValue, ContextItemStaticInfo object) {
        this.getOperand().typeCheck((ExpressionVisitor)((Object)groundedValue), (ContextItemStaticInfo)object);
        object = new RoleDiagnostic(9, "-", 0);
        groundedValue = ((ExpressionVisitor)((Object)groundedValue)).getConfiguration().getTypeChecker(this.a).staticTypeCheck(this.getBaseExpression(), SequenceType.OPTIONAL_NUMERIC, (RoleDiagnostic)object, (ExpressionVisitor)((Object)groundedValue));
        this.setBaseExpression((Expression)((Object)groundedValue));
        if (groundedValue instanceof Literal && (groundedValue = ((Literal)((Object)groundedValue)).getValue()) instanceof NumericValue) {
            return Literal.makeLiteral(((NumericValue)groundedValue).negate(), this);
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType().getPrimitiveItemType();
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public NumericValue evaluateItem(XPathContext object) {
        object = (NumericValue)this.getBaseExpression().evaluateItem((XPathContext)object);
        if (object == null) {
            if (this.a) {
                return DoubleValue.NaN;
            }
            return null;
        }
        return ((NumericValue)object).negate();
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new NegateExpression(this.getBaseExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    protected String displayOperator(Configuration configuration) {
        return "-";
    }

    @Override
    public String getExpressionName() {
        return "minus";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("minus", this);
        if (this.a) {
            expressionPresenter.emitAttribute("vn", "1");
        }
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

