/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class NumberSequenceFormatter
extends Expression {
    private Operand a;
    private Operand b;
    private Operand c;
    private Operand d;
    private Operand e;
    private Operand f;
    private Operand g;
    private Operand h;
    private NumberFormatter i = null;
    private Numberer j = null;
    private boolean k;

    public NumberSequenceFormatter(Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6, Expression expression7, Expression expression8, NumberFormatter numberFormatter, boolean bl2) {
        if (expression != null) {
            this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        }
        if (expression2 != null) {
            this.b = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
        }
        if (expression3 != null) {
            this.c = new Operand(this, expression3, OperandRole.SINGLE_ATOMIC);
        }
        if (expression4 != null) {
            this.d = new Operand(this, expression4, OperandRole.SINGLE_ATOMIC);
        }
        if (expression5 != null) {
            this.e = new Operand(this, expression5, OperandRole.SINGLE_ATOMIC);
        }
        if (expression6 != null) {
            this.f = new Operand(this, expression6, OperandRole.SINGLE_ATOMIC);
        }
        this.g = new Operand(this, expression7, OperandRole.SINGLE_ATOMIC);
        if (expression8 != null) {
            this.h = new Operand(this, expression8, OperandRole.SINGLE_ATOMIC);
        }
        this.i = numberFormatter;
        this.k = bl2;
        if (numberFormatter == null && expression2 instanceof StringLiteral) {
            this.i = new NumberFormatter();
            this.i.prepare(((StringLiteral)expression2).getStringValue());
        }
    }

    @Override
    public Expression simplify() {
        if (this.a != null && !this.a.getChildExpression().getItemType().isPlainType()) {
            this.a.setChildExpression(Atomizer.makeAtomizer(this.a.getChildExpression(), null));
        }
        NumberSequenceFormatter numberSequenceFormatter = this;
        numberSequenceFormatter.preallocateNumberer(numberSequenceFormatter.getConfiguration());
        return super.simplify();
    }

    public void preallocateNumberer(Configuration configuration) {
        if (this.h == null) {
            this.j = configuration.makeNumberer(null, null);
            return;
        }
        if (this.h.getChildExpression() instanceof StringLiteral) {
            ValidationFailure validationFailure;
            String string = ((StringLiteral)this.h.getChildExpression()).getStringValue();
            if (!string.isEmpty() && (validationFailure = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate(string)) != null) {
                this.h.setChildExpression(new StringLiteral(StringValue.EMPTY_STRING));
                throw new XPathException("The lang attribute must be a valid language code", "XTDE0030");
            }
            this.j = configuration.makeNumberer(string, null);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo iterator) {
        boolean bl2;
        block2: {
            this.optimizeChildren((ExpressionVisitor)object, (ContextItemStaticInfo)((Object)iterator));
            iterator = this;
            for (Operand operand : ((Expression)((Object)iterator)).operands()) {
                Operand operand2 = operand;
                operand2 = operand;
                if (operand == null || operand2.getChildExpression() instanceof Literal) continue;
                bl2 = false;
                break block2;
            }
            bl2 = true;
        }
        if (bl2) {
            object = this.evaluateItem(((ExpressionVisitor)object).makeDynamicContext());
            object = new StringLiteral((StringValue)object);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new NumberSequenceFormatter(NumberSequenceFormatter.a(this.a, (RebindingMap)object), NumberSequenceFormatter.a(this.b, (RebindingMap)object), NumberSequenceFormatter.a(this.c, (RebindingMap)object), NumberSequenceFormatter.a(this.d, (RebindingMap)object), NumberSequenceFormatter.a(this.e, (RebindingMap)object), NumberSequenceFormatter.a(this.f, (RebindingMap)object), NumberSequenceFormatter.a(this.g, (RebindingMap)object), NumberSequenceFormatter.a(this.h, (RebindingMap)object), this.i, this.k);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    private static Expression a(Operand operand, RebindingMap rebindingMap) {
        if (operand == null) {
            return null;
        }
        return operand.getChildExpression().copy(rebindingMap);
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public StringValue evaluateItem(XPathContext xPathContext) {
        String string;
        Object object;
        int n2;
        AtomicValue atomicValue;
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        Object object2 = xPathContext.getConfiguration().getConversionRules();
        Object object3 = this.g.getChildExpression().evaluateAsString(xPathContext).toString();
        object3 = this.parseStartAtValue((String)object3);
        SequenceIterator<?> sequenceIterator = this.a.getChildExpression().iterate(xPathContext);
        int n3 = 0;
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null && (!this.k || arrayList.isEmpty())) {
            int n4;
            if (object3.size() > n3) {
                n4 = (Integer)object3.get(n3);
            } else {
                Object object4 = object3;
                n4 = (Integer)object4.get(object4.size() - 1);
            }
            n2 = n4;
            ++n3;
            try {
                object = atomicValue instanceof NumericValue ? (NumericValue)atomicValue : Number_1.convert(atomicValue, xPathContext.getConfiguration());
                if (((AtomicValue)object).isNaN()) {
                    throw new XPathException("NaN");
                }
                if (((NumericValue)(object = ((NumericValue)object).round(0))).compareTo(Int64Value.MAX_LONG) > 0) {
                    BigInteger bigInteger = ((IntegerValue)((BigIntegerValue)Converter.convert((AtomicValue)object, BuiltInAtomicType.INTEGER, (ConversionRules)object2).asAtomic())).asBigInteger();
                    if (n2 != 1) {
                        bigInteger = bigInteger.add(BigInteger.valueOf(n2 - 1));
                    }
                    arrayList.add(bigInteger);
                    continue;
                }
                if (((NumericValue)object).compareTo(Int64Value.ZERO) < 0) {
                    throw new XPathException("The numbers to be formatted must not be negative");
                }
                long l2 = ((NumericValue)Converter.convert((AtomicValue)object, BuiltInAtomicType.INTEGER, (ConversionRules)object2).asAtomic()).longValue();
                arrayList.add(l2 += (long)(n2 - 1));
            }
            catch (XPathException xPathException) {
                if (this.k) {
                    arrayList.add("NaN");
                    continue;
                }
                arrayList.add(atomicValue.getStringValue());
                XPathException xPathException2 = new XPathException("Cannot convert supplied value to an integer. " + xPathException.getMessage());
                xPathException2.setErrorCode("XTDE0980");
                xPathException2.setLocation(this.getLocation());
                xPathException2.setXPathContext(xPathContext);
                throw xPathException2;
            }
        }
        if (this.k && arrayList.isEmpty()) {
            arrayList.add("NaN");
        }
        n2 = 0;
        object = "";
        String string2 = null;
        if (this.c != null) {
            object2 = this.c.getChildExpression().evaluateAsString(xPathContext).toString();
            try {
                n2 = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                object2 = new XPathException("grouping-size must be numeric");
                ((XPathException)object2).setXPathContext(xPathContext);
                ((XPathException)object2).setErrorCode("XTDE0030");
                ((XPathException)object2).setLocation(this.getLocation());
                throw object2;
            }
        }
        if (this.d != null) {
            object = this.d.getChildExpression().evaluateAsString(xPathContext).toString();
        }
        if (this.f != null) {
            string2 = this.f.getChildExpression().evaluateAsString(xPathContext).toString();
        }
        if ((object2 = this.j) == null) {
            if (this.h == null) {
                object2 = xPathContext.getConfiguration().makeNumberer(null, null);
            } else {
                object3 = this.h.getChildExpression().evaluateAsString(xPathContext).toString();
                object2 = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate((CharSequence)object3);
                if (object2 != null) {
                    throw new XPathException("The lang attribute of xsl:number must be a valid language code", "XTDE0030");
                }
                object2 = xPathContext.getConfiguration().makeNumberer((String)object3, null);
            }
        }
        if (this.e == null) {
            string = "";
        } else {
            string = this.e.getChildExpression().evaluateAsString(xPathContext).toString();
            if (!"alphabetic".equals(string) && !"traditional".equals(string)) {
                object3 = new XPathException("letter-value must be \"traditional\" or \"alphabetic\"");
                ((XPathException)object3).setXPathContext(xPathContext);
                ((XPathException)object3).setErrorCode("XTDE0030");
                ((XPathException)object3).setLocation(this.getLocation());
                throw object3;
            }
        }
        if (this.i == null) {
            object3 = new NumberFormatter();
            ((NumberFormatter)object3).prepare(this.b.getChildExpression().evaluateAsString(xPathContext).toString());
        } else {
            object3 = this.i;
        }
        object2 = ((NumberFormatter)object3).format(arrayList, n2, (String)object, string, string2, (Numberer)object2);
        return new StringValue((CharSequence)object2);
    }

    public List<Integer> parseStartAtValue(String object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = ((String)object).split("\\s+");
        object = stringArray;
        object = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object[i2];
            try {
                int n3 = Integer.parseInt(string);
                arrayList.add(n3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                object = new XPathException("Invalid start-at value: non-integer component {" + string + "}");
                ((XPathException)object).setErrorCode("XTDE0030");
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
        }
        if (arrayList.isEmpty()) {
            object = new XPathException("Invalid start-at value: no numeric components found");
            ((XPathException)object).setErrorCode("XTDE0030");
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        return arrayList;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("numSeqFmt", this);
        String string = "";
        if (this.k) {
            string = string + "1";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        if (this.a != null) {
            expressionPresenter.setChildRole("value");
            this.a.getChildExpression().export(expressionPresenter);
        }
        if (this.b != null) {
            expressionPresenter.setChildRole("format");
            this.b.getChildExpression().export(expressionPresenter);
        }
        if (this.g != null) {
            expressionPresenter.setChildRole("startAt");
            this.g.getChildExpression().export(expressionPresenter);
        }
        if (this.h != null) {
            expressionPresenter.setChildRole("lang");
            this.h.getChildExpression().export(expressionPresenter);
        }
        if (this.f != null) {
            expressionPresenter.setChildRole("ordinal");
            this.f.getChildExpression().export(expressionPresenter);
        }
        if (this.d != null) {
            expressionPresenter.setChildRole("gpSep");
            this.d.getChildExpression().export(expressionPresenter);
        }
        if (this.c != null) {
            expressionPresenter.setChildRole("gpSize");
            this.c.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }
}

