/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public final class Operand
implements Iterable<Operand>,
ExpressionOwner {
    private Expression a;
    private Expression b;
    private OperandRole c;
    private static boolean d = false;

    public Operand(Expression expression, Expression expression2, OperandRole operandRole) {
        this.a = expression;
        this.c = operandRole;
        this.setChildExpression(expression2);
    }

    public final Expression getParentExpression() {
        return this.a;
    }

    public final Expression getChildExpression() {
        return this.b;
    }

    @Override
    public final void setChildExpression(Expression expression) {
        if (expression != this.b) {
            if (this.c.isConstrainedClass() && (this.c.getConstraint() != null ? !this.c.getConstraint().test(expression) : this.b != null && expression.getClass() != this.b.getClass())) {
                throw new AssertionError();
            }
            this.b = expression;
            this.a.adoptChildExpression(expression);
            this.a.resetLocalStaticProperties();
        }
    }

    public final void detachChild() {
    }

    public final OperandRole getOperandRole() {
        return this.c;
    }

    public final void setOperandRole(OperandRole operandRole) {
        this.c = operandRole;
    }

    public final boolean setsNewFocus() {
        return this.c.setsNewFocus();
    }

    public final boolean hasSpecialFocusRules() {
        return this.c.hasSpecialFocusRules();
    }

    public final boolean hasSameFocus() {
        return this.c.hasSameFocus();
    }

    public final boolean isEvaluatedRepeatedly() {
        return this.c.isEvaluatedRepeatedly();
    }

    public final boolean isHigherOrder() {
        return this.c.isHigherOrder();
    }

    public final OperandUsage getUsage() {
        return this.c.getUsage();
    }

    public final void setUsage(OperandUsage operandUsage) {
        this.c = new OperandRole(this.c.a, operandUsage, this.c.getRequiredType());
    }

    public final SequenceType getRequiredType() {
        return this.c.getRequiredType();
    }

    public final boolean isInChoiceGroup() {
        return this.c.isInChoiceGroup();
    }

    @Override
    public final Iterator<Operand> iterator() {
        return new MonoIterator<Operand>(this);
    }

    public final void typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        try {
            Operand operand = this;
            operand.setChildExpression(operand.getChildExpression().typeCheck(expressionVisitor, (ContextItemStaticInfo)object));
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getChildExpression().getLocation());
            if (!((XPathException)object).isReportableStatically()) {
                expressionVisitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + ((Throwable)object).getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression((XPathException)object));
                return;
            }
            throw object;
        }
    }

    public final void optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        try {
            Operand operand = this;
            operand.setChildExpression(operand.getChildExpression().optimize(expressionVisitor, (ContextItemStaticInfo)object));
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getChildExpression().getLocation());
            if (!((XPathException)object).isReportableStatically()) {
                expressionVisitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + ((Throwable)object).getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression((XPathException)object));
                return;
            }
            throw object;
        }
    }

    public static OperandUsage typeDeterminedUsage(ItemType itemType) {
        if (itemType.isPlainType()) {
            return OperandUsage.ABSORPTION;
        }
        if (itemType instanceof NodeTest || itemType == AnyItemType.getInstance()) {
            return OperandUsage.NAVIGATION;
        }
        return OperandUsage.INSPECTION;
    }
}

