/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.value.BooleanValue;

public class OrExpression
extends BooleanExpression {
    public OrExpression(Expression expression, Expression expression2) {
        super(expression, 9, expression2);
    }

    @Override
    protected Expression preEvaluate() {
        if (Literal.hasEffectiveBooleanValue(this.getLhsExpression(), true) || Literal.hasEffectiveBooleanValue(this.getRhsExpression(), true)) {
            return Literal.makeLiteral(BooleanValue.TRUE, this);
        }
        if (Literal.hasEffectiveBooleanValue(this.getLhsExpression(), false)) {
            OrExpression orExpression = this;
            return orExpression.forceToBoolean(orExpression.getRhsExpression());
        }
        if (Literal.hasEffectiveBooleanValue(this.getRhsExpression(), false)) {
            OrExpression orExpression = this;
            return orExpression.forceToBoolean(orExpression.getLhsExpression());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression = super.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        if (expression != this) {
            return expression;
        }
        if (!(this.getParentExpression() instanceof OrExpression) && (object = ((ExpressionVisitor)object).obtainOptimizer().tryGeneralComparison((ExpressionVisitor)object, contextItemStaticInfo, this)) != null && object != this) {
            return object;
        }
        return this;
    }

    @Override
    public double getCost() {
        return this.getLhsExpression().getCost() + this.getRhsExpression().getCost() / 2.0;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new OrExpression(this.getLhsExpression().copy((RebindingMap)object), this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Expression negate() {
        Expression expression = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
        Expression expression2 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
        expression = new AndExpression(expression, expression2);
        ExpressionTool.copyLocationInfo(this, expression);
        return expression;
    }

    @Override
    protected String tag() {
        return "or";
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.getLhsExpression().effectiveBooleanValue(xPathContext) || this.getRhsExpression().effectiveBooleanValue(xPathContext);
    }
}

