/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.OneOrMore;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class PJConverter {
    private static HashMap<Class, SequenceType> a = new HashMap<Class<Boolean>, SequenceType>();

    public static SequenceType getEquivalentSequenceType(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == Byte.TYPE) {
                return SequenceType.makeSequenceType(BuiltInAtomicType.UNSIGNED_BYTE, 57344);
            }
            if ((clazz2 = PJConverter.getEquivalentSequenceType(clazz2)) != null) {
                return SequenceType.makeSequenceType(((SequenceType)((Object)clazz2)).getPrimaryType(), 57344);
            }
        }
        return a.get(clazz);
    }

    public static SequenceType getParameterizedSequenceType(Type type) {
        Object object;
        if (type instanceof ParameterizedType && ((Type[])(object = (type = (ParameterizedType)type).getActualTypeArguments())).length == 1 && object[0] instanceof Class && Item.class.isAssignableFrom((Class)object[0])) {
            object = (object = PJConverter.getEquivalentSequenceType((Class)object[0])) == null ? null : ((SequenceType)object).getPrimaryType();
            type = type.getRawType();
            int n2 = -1;
            if (type.equals(ZeroOrOne.class)) {
                n2 = 24576;
            } else if (type.equals(One.class)) {
                n2 = 16384;
            } else if (type.equals(OneOrMore.class)) {
                n2 = 49152;
            } else if (type.equals(ZeroOrMore.class)) {
                n2 = 57344;
            }
            if (object != null && n2 != -1) {
                return SequenceType.makeSequenceType((ItemType)object, n2);
            }
        }
        return null;
    }

    public abstract Object convert(Sequence<?> var1, Class<?> var2, XPathContext var3);

    public static PJConverter allocate(Configuration configuration, ItemType itemType, int n2, Class<?> clazz) {
        Constructor<?> constructor;
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (clazz == SequenceIterator.class) {
            return ToSequenceIterator.INSTANCE;
        }
        if (clazz == Sequence.class || clazz == Item.class) {
            return Identity.INSTANCE;
        }
        if (clazz == One.class) {
            return ToOne.INSTANCE;
        }
        if (clazz == ZeroOrOne.class) {
            return ToZeroOrOne.INSTANCE;
        }
        if (clazz == OneOrMore.class) {
            return ToOneOrMore.INSTANCE;
        }
        if (clazz == ZeroOrMore.class) {
            return ToZeroOrMore.INSTANCE;
        }
        if (clazz == GroundedValue.class | clazz == SequenceExtent.class) {
            return ToSequenceExtent.INSTANCE;
        }
        if (!itemType.isPlainType()) {
            constructor = configuration.getExternalObjectModels();
            constructor = constructor.iterator();
            while (constructor.hasNext()) {
                Object object = (ExternalObjectModel)constructor.next();
                if ((object = object.getPJConverter(clazz)) == null) continue;
                return object;
            }
            if (NodeInfo.class.isAssignableFrom(clazz)) {
                return Identity.INSTANCE;
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return ToCollection.INSTANCE;
        }
        if (clazz.isArray()) {
            constructor = PJConverter.allocate(configuration, itemType, 16384, clazz.getComponentType());
            return new ToArray((PJConverter)((Object)constructor));
        }
        if (!Cardinality.allowsMany(n2)) {
            if (itemType.isPlainType()) {
                if (itemType == ErrorType.getInstance()) {
                    return StringValueToString.INSTANCE;
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.STRING)) {
                    if (clazz == Object.class || clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(StringValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Character.TYPE || clazz == Character.class) {
                        return StringValueToChar.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (itemType == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    if (clazz == Object.class || clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(UntypedAtomicValue.class)) {
                        return Identity.INSTANCE;
                    }
                    try {
                        constructor = clazz.getConstructor(String.class);
                        return new PJConverter(constructor){
                            private /* synthetic */ Constructor a;
                            {
                                this.a = constructor;
                            }

                            @Override
                            public final Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
                                try {
                                    return this.a.newInstance(sequence.head().getStringValue());
                                }
                                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                                    throw new XPathException(reflectiveOperationException);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throw new XPathException("Cannot convert untypedAtomic to " + clazz.getName() + ": " + invocationTargetException.getMessage(), "FORG0001");
                                }
                            }
                        };
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw PJConverter.a(itemType, clazz);
                    }
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.BOOLEAN)) {
                    if (clazz == Object.class || clazz == Boolean.class || clazz == Boolean.TYPE) {
                        return BooleanValueToBoolean.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(BooleanValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.INTEGER)) {
                    if (clazz == Object.class || clazz == BigInteger.class) {
                        return IntegerValueToBigInteger.INSTANCE;
                    }
                    if (clazz == Long.TYPE || clazz == Long.class) {
                        return IntegerValueToLong.INSTANCE;
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        return IntegerValueToInt.INSTANCE;
                    }
                    if (clazz == Short.TYPE || clazz == Short.class) {
                        return IntegerValueToShort.INSTANCE;
                    }
                    if (clazz == Byte.TYPE || clazz == Byte.class) {
                        return IntegerValueToByte.INSTANCE;
                    }
                    if (clazz == Character.TYPE || clazz == Character.class) {
                        return IntegerValueToChar.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(IntegerValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DECIMAL)) {
                    if (clazz == Object.class || clazz == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(BigDecimalValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.FLOAT)) {
                    if (clazz == Object.class || clazz == Float.class || clazz == Float.TYPE) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(FloatValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DOUBLE)) {
                    if (clazz == Object.class || clazz == Double.class || clazz == Double.TYPE) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(DoubleValue.class)) {
                        return Identity.INSTANCE;
                    }
                    return Atomic.INSTANCE;
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.ANY_URI)) {
                    if (clazz == Object.class || URI.class.isAssignableFrom(clazz)) {
                        return AnyURIValueToURI.INSTANCE;
                    }
                    if (URL.class.isAssignableFrom(clazz)) {
                        return AnyURIValueToURL.INSTANCE;
                    }
                    if (clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(AnyURIValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.QNAME)) {
                    if (clazz == Object.class || clazz == QName.class) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(QNameValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.NOTATION)) {
                    if (clazz == Object.class || clazz == QName.class) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(NotationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DURATION)) {
                    if (clazz.isAssignableFrom(DurationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DATE_TIME)) {
                    if (clazz.isAssignableFrom(DateTimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    if (clazz == Instant.class) {
                        return CalendarValueToInstant.INSTANCE;
                    }
                    if (clazz == ZonedDateTime.class) {
                        return CalendarValueToZonedDateTime.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DATE)) {
                    if (clazz.isAssignableFrom(DateValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    if (clazz == Instant.class) {
                        return CalendarValueToInstant.INSTANCE;
                    }
                    if (clazz == ZonedDateTime.class) {
                        return CalendarValueToZonedDateTime.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.TIME)) {
                    if (clazz.isAssignableFrom(TimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    if (clazz == Instant.class) {
                        return CalendarValueToInstant.INSTANCE;
                    }
                    if (clazz == ZonedDateTime.class) {
                        return CalendarValueToZonedDateTime.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_YEAR)) {
                    if (clazz.isAssignableFrom(GYearValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_YEAR_MONTH)) {
                    if (clazz.isAssignableFrom(GYearMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_MONTH)) {
                    if (clazz.isAssignableFrom(GMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_MONTH_DAY)) {
                    if (clazz.isAssignableFrom(GMonthDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_DAY)) {
                    if (clazz.isAssignableFrom(GDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.BASE64_BINARY)) {
                    if (clazz.isAssignableFrom(Base64BinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.HEX_BINARY)) {
                    if (clazz.isAssignableFrom(HexBinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.a(itemType, clazz);
                }
                return Atomic.INSTANCE;
            }
            if (itemType instanceof JavaExternalObjectType) {
                return UnwrapExternalObject.INSTANCE;
            }
            if (itemType instanceof ErrorType) {
                return ToNull.INSTANCE;
            }
            if (itemType instanceof NodeTest) {
                if (NodeInfo.class.isAssignableFrom(clazz)) {
                    return Identity.INSTANCE;
                }
                return General.INSTANCE;
            }
            return General.INSTANCE;
        }
        return General.INSTANCE;
    }

    private static XPathException a(ItemType itemType, Class clazz) {
        return new XPathException("Cannot convert from " + itemType + " to " + clazz.getName());
    }

    public static PJConverter allocateNodeListCreator(Configuration iterator, Object object) {
        iterator = ((Configuration)((Object)iterator)).getExternalObjectModels();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if ((object2 = object2.getNodeListCreator(object)) == null) continue;
            return object2;
        }
        return ToCollection.INSTANCE;
    }

    static {
        a.put(Boolean.TYPE, SequenceType.SINGLE_BOOLEAN);
        a.put(Boolean.class, SequenceType.OPTIONAL_BOOLEAN);
        a.put(String.class, SequenceType.OPTIONAL_STRING);
        a.put(CharSequence.class, SequenceType.OPTIONAL_STRING);
        a.put(Long.TYPE, SequenceType.SINGLE_INTEGER);
        a.put(Long.class, SequenceType.OPTIONAL_INTEGER);
        a.put(Integer.TYPE, SequenceType.SINGLE_INTEGER);
        a.put(Integer.class, SequenceType.OPTIONAL_INTEGER);
        a.put(Short.TYPE, SequenceType.SINGLE_SHORT);
        a.put(Short.class, SequenceType.OPTIONAL_SHORT);
        a.put(Byte.TYPE, SequenceType.SINGLE_BYTE);
        a.put(Byte.class, SequenceType.OPTIONAL_BYTE);
        a.put(Float.TYPE, SequenceType.SINGLE_FLOAT);
        a.put(Float.class, SequenceType.OPTIONAL_FLOAT);
        a.put(Double.TYPE, SequenceType.SINGLE_DOUBLE);
        a.put(Double.class, SequenceType.OPTIONAL_DOUBLE);
        a.put(URI.class, SequenceType.OPTIONAL_ANY_URI);
        a.put(URL.class, SequenceType.OPTIONAL_ANY_URI);
        a.put(BigInteger.class, SequenceType.OPTIONAL_INTEGER);
        a.put(BigDecimal.class, SequenceType.OPTIONAL_DECIMAL);
        a.put(StringValue.class, SequenceType.OPTIONAL_STRING);
        a.put(BooleanValue.class, SequenceType.OPTIONAL_BOOLEAN);
        a.put(DoubleValue.class, SequenceType.OPTIONAL_DOUBLE);
        a.put(FloatValue.class, SequenceType.OPTIONAL_FLOAT);
        a.put(DecimalValue.class, SequenceType.OPTIONAL_DECIMAL);
        a.put(IntegerValue.class, SequenceType.OPTIONAL_INTEGER);
        a.put(AnyURIValue.class, SequenceType.OPTIONAL_ANY_URI);
        a.put(QNameValue.class, SequenceType.OPTIONAL_QNAME);
        a.put(NotationValue.class, SequenceType.OPTIONAL_NOTATION);
        a.put(DateValue.class, SequenceType.OPTIONAL_DATE);
        a.put(DateTimeValue.class, SequenceType.OPTIONAL_DATE_TIME);
        a.put(TimeValue.class, SequenceType.OPTIONAL_TIME);
        a.put(DurationValue.class, SequenceType.OPTIONAL_DURATION);
        a.put(DayTimeDurationValue.class, SequenceType.OPTIONAL_DAY_TIME_DURATION);
        a.put(YearMonthDurationValue.class, SequenceType.OPTIONAL_YEAR_MONTH_DURATION);
        a.put(GYearValue.class, SequenceType.OPTIONAL_G_YEAR);
        a.put(GYearMonthValue.class, SequenceType.OPTIONAL_G_YEAR_MONTH);
        a.put(GMonthValue.class, SequenceType.OPTIONAL_G_MONTH);
        a.put(GMonthDayValue.class, SequenceType.OPTIONAL_G_MONTH_DAY);
        a.put(GDayValue.class, SequenceType.OPTIONAL_G_DAY);
        a.put(Base64BinaryValue.class, SequenceType.OPTIONAL_BASE64_BINARY);
        a.put(HexBinaryValue.class, SequenceType.OPTIONAL_HEX_BINARY);
        a.put(Function.class, SequenceType.OPTIONAL_FUNCTION_ITEM);
        a.put(MapItem.class, MapType.OPTIONAL_MAP_ITEM);
        a.put(NodeInfo.class, SequenceType.OPTIONAL_NODE);
        a.put(TreeInfo.class, SequenceType.OPTIONAL_DOCUMENT_NODE);
    }

    public static class General
    extends PJConverter {
        public static final General INSTANCE = new General();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            Object object = xPathContext.getConfiguration();
            if ((object = General.allocate((Configuration)object, SequenceTool.getItemType(sequence = sequence.materialize(), ((Configuration)object).getTypeHierarchy()), SequenceTool.getCardinality(sequence), clazz)) instanceof General) {
                object = Identity.INSTANCE;
            }
            return ((PJConverter)object).convert(sequence, clazz, xPathContext);
        }
    }

    public static class Atomic
    extends PJConverter {
        public static final Atomic INSTANCE = new Atomic();

        @Override
        public Object convert(Sequence<?> atomicValue, Class<?> clazz, XPathContext xPathContext) {
            if ((atomicValue = (AtomicValue)atomicValue.head()) == null) {
                return null;
            }
            Object object = xPathContext.getConfiguration();
            object = Atomic.allocate((Configuration)object, atomicValue.getItemType(), 16384, clazz);
            return ((PJConverter)object).convert(atomicValue, clazz, xPathContext);
        }
    }

    public static class CalendarValueToCalendar
    extends PJConverter {
        public static final CalendarValueToCalendar INSTANCE = new CalendarValueToCalendar();

        @Override
        public Object convert(Sequence<?> calendarValue, Class<?> clazz, XPathContext xPathContext) {
            if ((calendarValue = (CalendarValue)calendarValue.head()) == null) {
                return null;
            }
            return calendarValue.getCalendar();
        }
    }

    public static class CalendarValueToDate
    extends PJConverter {
        public static final CalendarValueToDate INSTANCE = new CalendarValueToDate();

        @Override
        public Object convert(Sequence<?> calendarValue, Class<?> clazz, XPathContext xPathContext) {
            if ((calendarValue = (CalendarValue)calendarValue.head()) == null) {
                return null;
            }
            return calendarValue.getCalendar().getTime();
        }
    }

    public static class CalendarValueToZonedDateTime
    extends PJConverter {
        public static final CalendarValueToZonedDateTime INSTANCE = new CalendarValueToZonedDateTime();

        @Override
        public Object convert(Sequence<?> calendarValue, Class<?> clazz, XPathContext xPathContext) {
            if ((calendarValue = (CalendarValue)calendarValue.head()) == null) {
                return null;
            }
            return calendarValue.toDateTime().toZonedDateTime();
        }
    }

    public static class CalendarValueToInstant
    extends PJConverter {
        public static final CalendarValueToInstant INSTANCE = new CalendarValueToInstant();

        @Override
        public Object convert(Sequence<?> calendarValue, Class<?> clazz, XPathContext xPathContext) {
            if ((calendarValue = (CalendarValue)calendarValue.head()) == null) {
                return null;
            }
            return calendarValue.toDateTime().toJavaInstant();
        }
    }

    public static class QualifiedNameValueToQName
    extends PJConverter {
        public static final QualifiedNameValueToQName INSTANCE = new QualifiedNameValueToQName();

        @Override
        public Object convert(Sequence<?> qualifiedNameValue, Class<?> clazz, XPathContext xPathContext) {
            if ((qualifiedNameValue = (QualifiedNameValue)qualifiedNameValue.head()) == null) {
                return null;
            }
            return qualifiedNameValue.toJaxpQName();
        }
    }

    public static class AnyURIValueToURL
    extends PJConverter {
        public static final AnyURIValueToURL INSTANCE = new AnyURIValueToURL();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> object, XPathContext xPathContext) {
            object = (AnyURIValue)sequence.head();
            try {
                if (object == null) {
                    return null;
                }
                return new URL(((AnyURIValue)sequence).getStringValue());
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException("The anyURI value '" + sequence + "' is not an acceptable Java URL");
            }
        }
    }

    public static class AnyURIValueToURI
    extends PJConverter {
        public static final AnyURIValueToURI INSTANCE = new AnyURIValueToURI();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> object, XPathContext xPathContext) {
            object = (AnyURIValue)sequence.head();
            try {
                if (object == null) {
                    return null;
                }
                return new URI(((AnyURIValue)sequence).getStringValue());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("The anyURI value '" + sequence + "' is not an acceptable Java URI");
            }
        }
    }

    public static class NumericValueToFloat
    extends PJConverter {
        public static final NumericValueToFloat INSTANCE = new NumericValueToFloat();

        @Override
        public Object convert(Sequence<?> numericValue, Class<?> clazz, XPathContext xPathContext) {
            numericValue = (NumericValue)numericValue.head();
            assert (numericValue != null);
            return Float.valueOf(numericValue.getFloatValue());
        }
    }

    public static class NumericValueToDouble
    extends PJConverter {
        public static final NumericValueToDouble INSTANCE = new NumericValueToDouble();

        @Override
        public Object convert(Sequence<?> numericValue, Class<?> clazz, XPathContext xPathContext) {
            numericValue = (NumericValue)numericValue.head();
            assert (numericValue != null);
            return numericValue.getDoubleValue();
        }
    }

    public static class NumericValueToBigDecimal
    extends PJConverter {
        public static final NumericValueToBigDecimal INSTANCE = new NumericValueToBigDecimal();

        @Override
        public Object convert(Sequence<?> numericValue, Class<?> clazz, XPathContext xPathContext) {
            if ((numericValue = (NumericValue)numericValue.head()) == null) {
                return null;
            }
            return numericValue.getDecimalValue();
        }
    }

    public static class IntegerValueToChar
    extends PJConverter {
        public static final IntegerValueToChar INSTANCE = new IntegerValueToChar();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            integerValue = (IntegerValue)integerValue.head();
            assert (integerValue != null);
            return Character.valueOf((char)integerValue.longValue());
        }
    }

    public static class IntegerValueToByte
    extends PJConverter {
        public static final IntegerValueToByte INSTANCE = new IntegerValueToByte();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            integerValue = (IntegerValue)integerValue.head();
            assert (integerValue != null);
            return (byte)integerValue.longValue();
        }
    }

    public static class IntegerValueToShort
    extends PJConverter {
        public static final IntegerValueToShort INSTANCE = new IntegerValueToShort();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            integerValue = (IntegerValue)integerValue.head();
            assert (integerValue != null);
            return (short)integerValue.longValue();
        }
    }

    public static class IntegerValueToInt
    extends PJConverter {
        public static final IntegerValueToInt INSTANCE = new IntegerValueToInt();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            integerValue = (IntegerValue)integerValue.head();
            assert (integerValue != null);
            return (int)integerValue.longValue();
        }
    }

    public static class IntegerValueToLong
    extends PJConverter {
        public static final IntegerValueToLong INSTANCE = new IntegerValueToLong();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            integerValue = (IntegerValue)integerValue.head();
            assert (integerValue != null);
            return integerValue.longValue();
        }
    }

    public static class IntegerValueToBigInteger
    extends PJConverter {
        public static final IntegerValueToBigInteger INSTANCE = new IntegerValueToBigInteger();

        @Override
        public Object convert(Sequence<?> integerValue, Class<?> clazz, XPathContext xPathContext) {
            if ((integerValue = (IntegerValue)integerValue.head()) == null) {
                return null;
            }
            return integerValue.asBigInteger();
        }
    }

    public static class BooleanValueToBoolean
    extends PJConverter {
        public static final BooleanValueToBoolean INSTANCE = new BooleanValueToBoolean();

        @Override
        public Object convert(Sequence<?> booleanValue, Class<?> clazz, XPathContext xPathContext) {
            booleanValue = (BooleanValue)booleanValue.head();
            assert (booleanValue != null);
            return booleanValue.getBooleanValue();
        }
    }

    public static class StringValueToChar
    extends PJConverter {
        public static final StringValueToChar INSTANCE = new StringValueToChar();

        @Override
        public Object convert(Sequence<?> object, Class<?> clazz, XPathContext xPathContext) {
            if ((object = object.head()) == null) {
                return null;
            }
            if (((String)(object = object.getStringValue())).length() == 1) {
                return Character.valueOf(((String)object).charAt(0));
            }
            object = new XPathException("Cannot convert xs:string to Java char unless length is 1");
            ((XPathException)object).setXPathContext(xPathContext);
            ((XPathException)object).setErrorCode("SXJE0005");
            throw object;
        }
    }

    public static class StringValueToString
    extends PJConverter {
        public static final StringValueToString INSTANCE = new StringValueToString();

        @Override
        public String convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            if ((sequence = sequence.head()) == null) {
                return null;
            }
            return sequence.getStringValue();
        }
    }

    public static class UnwrapExternalObject
    extends PJConverter {
        public static final UnwrapExternalObject INSTANCE = new UnwrapExternalObject();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext object) {
            object = sequence.head();
            if (object == null) {
                return null;
            }
            if (!(object instanceof ExternalObject)) {
                if (Sequence.class.isAssignableFrom(clazz)) {
                    object = new ObjectValue<Sequence<Object>>(sequence);
                } else {
                    throw new XPathException("Expected external object of class " + clazz.getName() + ", got " + object.getClass());
                }
            }
            if (!clazz.isAssignableFrom((sequence = ((ExternalObject)object).getObject()).getClass())) {
                throw new XPathException("External object has wrong class (is " + sequence.getClass().getName() + ", expected " + clazz.getName() + ")");
            }
            return sequence;
        }
    }

    public static class Identity
    extends PJConverter {
        public static final Identity INSTANCE = new Identity();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            GroundedValue<Object> groundedValue;
            if (sequence instanceof Closure) {
                sequence = ((Closure)sequence).reduce();
            }
            if (sequence instanceof ZeroOrOne) {
                sequence = ((ZeroOrOne)sequence).head();
            }
            if (sequence instanceof VirtualNode && clazz.isAssignableFrom((groundedValue = ((VirtualNode)sequence).getRealNode()).getClass())) {
                return groundedValue;
            }
            if (clazz.isAssignableFrom(sequence.getClass())) {
                return sequence;
            }
            groundedValue = sequence.materialize();
            if (clazz.isAssignableFrom(groundedValue.getClass())) {
                return groundedValue;
            }
            if (clazz.isAssignableFrom((groundedValue = groundedValue.reduce()).getClass())) {
                return groundedValue;
            }
            if (groundedValue.getLength() == 0) {
                return null;
            }
            throw new XPathException("Cannot convert value " + sequence.getClass() + " of type " + SequenceTool.getItemType(sequence, xPathContext.getConfiguration().getTypeHierarchy()) + " to class " + clazz.getName());
        }
    }

    public static class ToZeroOrMore
    extends PJConverter {
        public static final ToZeroOrMore INSTANCE = new ToZeroOrMore();

        @Override
        public ZeroOrMore<Item<?>> convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return new ZeroOrMore(sequence.iterate());
        }
    }

    public static class ToOneOrMore
    extends PJConverter {
        public static final ToOneOrMore INSTANCE = new ToOneOrMore();

        @Override
        public OneOrMore<?> convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return OneOrMore.makeOneOrMore(sequence);
        }
    }

    public static class ToZeroOrOne
    extends PJConverter {
        public static final ToZeroOrOne INSTANCE = new ToZeroOrOne();

        @Override
        public ZeroOrOne<Item<?>> convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return new ZeroOrOne((Item<?>)sequence.head());
        }
    }

    public static class ToOne
    extends PJConverter {
        public static final ToOne INSTANCE = new ToOne();

        @Override
        public One<Item<?>> convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return new One((Item<?>)sequence.head());
        }
    }

    public static class ToArray
    extends PJConverter {
        private PJConverter a;

        public ToArray(PJConverter pJConverter) {
            this.a = pJConverter;
        }

        @Override
        public Object convert(Sequence<?> object, Class<?> clazz, XPathContext xPathContext) {
            Object object2;
            if (object instanceof ExternalObject && clazz.isAssignableFrom(((ExternalObject)object).getObject().getClass())) {
                return ((ExternalObject)object).getObject();
            }
            clazz = clazz.getComponentType();
            ArrayList arrayList = new ArrayList(20);
            object = object.iterate();
            while ((object2 = object.next()) != null) {
                if ((object2 = this.a.convert((Sequence<?>)object2, clazz, xPathContext)) == null) continue;
                arrayList.add(object2);
            }
            object2 = Array.newInstance(clazz, arrayList.size());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Array.set(object2, i2, arrayList.get(i2));
            }
            return object2;
        }
    }

    public static class ToCollection
    extends PJConverter {
        public static final ToCollection INSTANCE = new ToCollection();

        @Override
        public Object convert(Sequence<?> object, Class<?> object2, XPathContext xPathContext) {
            Object t2;
            Collection<Object> collection;
            if (((Class)object2).isAssignableFrom(ArrayList.class)) {
                collection = new ArrayList(100);
            } else {
                try {
                    collection = (Collection)((Class)object2).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    object = new XPathException("Cannot instantiate collection class " + object2);
                    ((XPathException)object).setXPathContext(xPathContext);
                    throw object;
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = new XPathException("Cannot access collection class " + object2);
                    ((XPathException)object).setXPathContext(xPathContext);
                    throw object;
                }
            }
            object2 = xPathContext.getConfiguration();
            object = object.iterate();
            while ((t2 = object.next()) != null) {
                if (t2 instanceof AtomicValue) {
                    PJConverter pJConverter = ToCollection.allocate((Configuration)object2, ((AtomicValue)t2).getItemType(), 16384, Object.class);
                    collection.add(pJConverter.convert((Sequence<?>)t2, Object.class, xPathContext));
                    continue;
                }
                if (t2 instanceof VirtualNode) {
                    collection.add(((VirtualNode)t2).getRealNode());
                    continue;
                }
                collection.add(t2);
            }
            return collection;
        }
    }

    public static class ToSequenceExtent
    extends PJConverter {
        public static final ToSequenceExtent INSTANCE = new ToSequenceExtent();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return sequence.iterate().materialize();
        }
    }

    public static class ToNull
    extends PJConverter {
        public static final ToNull INSTANCE = new ToNull();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return null;
        }
    }

    public static class ToSequenceIterator
    extends PJConverter {
        public static final ToSequenceIterator INSTANCE = new ToSequenceIterator();

        @Override
        public Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
            return sequence.iterate();
        }
    }
}

