/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class QuantifiedExpression
extends Assignation {
    private int a;

    @Override
    public String getExpressionName() {
        return Token.tokens[this.a];
    }

    public void setOperator(int n2) {
        this.a = n2;
    }

    public int getOperator() {
        return this.a;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.getSequenceOp().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getSequence())) {
            return Literal.makeLiteral(BooleanValue.get(this.a != 32), this);
        }
        QuantifiedExpression quantifiedExpression = this;
        quantifiedExpression.setSequence(quantifiedExpression.getSequence().unordered(false, false));
        Object object2 = this.getRequiredType();
        if (((SequenceType)object2).getCardinality() == 8192) {
            object2 = new XPathException("Range variable will never satisfy the type empty-sequence()", "XPTY0004");
            ((XPathException)object2).setIsTypeError(true);
            ((XPathException)object2).setLocation(this.getLocation());
            throw object2;
        }
        object2 = SequenceType.makeSequenceType(((SequenceType)object2).getPrimaryType(), 57344);
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
        QuantifiedExpression quantifiedExpression2 = this;
        quantifiedExpression2.setSequence(TypeChecker.strictTypeCheck(quantifiedExpression2.getSequence(), (SequenceType)object2, roleDiagnostic, ((ExpressionVisitor)object).getStaticContext()));
        object2 = this.getSequence().getItemType();
        this.refineTypeInformation((ItemType)object2, 16384, null, this.getSequence().getSpecialProperties(), this);
        this.getActionOp().typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        object = TypeChecker.ebvError(this.getAction(), ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy());
        if (object != null) {
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        ((ExpressionVisitor)object).getConfiguration();
        ((ExpressionVisitor)object).obtainOptimizer();
        this.getSequenceOp().optimize((ExpressionVisitor)object, contextItemStaticInfo);
        this.getActionOp().optimize((ExpressionVisitor)object, contextItemStaticInfo);
        GroundedValue<?> groundedValue = BooleanFn.rewriteEffectiveBooleanValue(this.getAction(), (ExpressionVisitor)object, contextItemStaticInfo);
        if (groundedValue != null) {
            this.setAction((Expression)((Object)groundedValue));
            this.adoptChildExpression((Expression)((Object)groundedValue));
        }
        if (Literal.hasEffectiveBooleanValue((Expression)((Object)groundedValue), true)) {
            if (this.getOperator() == 32) {
                return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), this.getSequence());
            }
            groundedValue = new Literal(BooleanValue.TRUE);
            ExpressionTool.copyLocationInfo(this, (Expression)((Object)groundedValue));
            return groundedValue;
        }
        if (Literal.hasEffectiveBooleanValue((Expression)((Object)groundedValue), false)) {
            if (this.getOperator() == 32) {
                groundedValue = new Literal(BooleanValue.FALSE);
                ExpressionTool.copyLocationInfo(this, (Expression)((Object)groundedValue));
                return groundedValue;
            }
            return SystemFunction.makeCall("empty", this.getRetainedStaticContext(), this.getSequence());
        }
        if (this.getSequence() instanceof Literal) {
            groundedValue = ((Literal)this.getSequence()).getValue();
            int n2 = groundedValue.getLength();
            if (n2 == 0) {
                object = new Literal(BooleanValue.get(this.getOperator() == 33));
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
            if (n2 == 1) {
                if (this.getAction() instanceof VariableReference && ((VariableReference)this.getAction()).getBinding() == this) {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getSequence());
                }
                QuantifiedExpression quantifiedExpression = this;
                quantifiedExpression.replaceVariable(quantifiedExpression.getSequence());
                return this.getAction();
            }
        }
        if (((ExpressionVisitor)object).isOptimizeForStreaming() && (groundedValue = ((ExpressionVisitor)object).obtainOptimizer().optimizeQuantifiedExpressionForStreaming(this)) != null && groundedValue != this) {
            return ((Expression)((Object)groundedValue)).optimize((ExpressionVisitor)object, contextItemStaticInfo);
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        this.getSequence().checkForUpdatingSubexpressions();
        this.getAction().checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return false;
    }

    @Override
    public Expression copy(RebindingMap object) {
        QuantifiedExpression quantifiedExpression = new QuantifiedExpression();
        ((RebindingMap)object).put(this, quantifiedExpression);
        ExpressionTool.copyLocationInfo(this, quantifiedExpression);
        quantifiedExpression.setOperator(this.a);
        quantifiedExpression.setVariableQName(this.variableName);
        quantifiedExpression.setRequiredType(this.requiredType);
        quantifiedExpression.setSequence(this.getSequence().copy((RebindingMap)object));
        object = this.getAction().copy((RebindingMap)object);
        quantifiedExpression.setAction((Expression)object);
        quantifiedExpression.variableName = this.variableName;
        quantifiedExpression.slotNumber = this.slotNumber;
        return quantifiedExpression;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x800000;
    }

    public BooleanValue evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(((Expression)this).effectiveBooleanValue(xPathContext));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        Object obj;
        SequenceIterator<?> sequenceIterator = this.getSequence().iterate(xPathContext);
        boolean bl2 = this.a == 32;
        int n2 = this.getLocalSlotNumber();
        while ((obj = sequenceIterator.next()) != null) {
            xPathContext.setLocalVariable(n2, (Sequence<?>)obj);
            if (bl2 != this.getAction().effectiveBooleanValue(xPathContext)) continue;
            sequenceIterator.close();
            return bl2;
        }
        return !bl2;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    @Override
    public String toString() {
        return (this.a == 32 ? "some" : "every") + " $" + this.getVariableEQName() + " in " + this.getSequence() + " satisfies " + ExpressionTool.parenthesize(this.getAction());
    }

    @Override
    public String toShortString() {
        return (this.a == 32 ? "some" : "every") + " $" + this.getVariableName() + " in " + this.getSequence().toShortString() + " satisfies ...";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement(Token.tokens[this.a], this);
        expressionPresenter.emitAttribute("var", this.getVariableQName());
        expressionPresenter.emitAttribute("slot", "" + this.slotNumber);
        this.getSequence().export(expressionPresenter);
        this.getAction().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

