/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression expression, Expression expression2) {
        super(expression, 29, expression2);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getLhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        this.getRhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        boolean bl2 = expressionVisitor.getStaticContext().isInBackwardsCompatibleMode();
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(bl2);
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(1, "to", 0);
        this.setLhsExpression(typeChecker.staticTypeCheck(this.getLhsExpression(), SequenceType.OPTIONAL_INTEGER, roleDiagnostic, expressionVisitor));
        roleDiagnostic = new RoleDiagnostic(1, "to", 1);
        this.setRhsExpression(typeChecker.staticTypeCheck(this.getRhsExpression(), SequenceType.OPTIONAL_INTEGER, roleDiagnostic, expressionVisitor));
        return this.a();
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getLhs().optimize(expressionVisitor, contextItemStaticInfo);
        this.getRhs().optimize(expressionVisitor, contextItemStaticInfo);
        return this.a();
    }

    private Expression a() {
        if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
            Object object = ((Literal)this.getLhsExpression()).getValue();
            GroundedValue<?> groundedValue = ((Literal)this.getRhsExpression()).getValue();
            if (object instanceof Int64Value && groundedValue instanceof Int64Value) {
                long l2;
                long l3 = ((NumericValue)((Int64Value)object)).longValue();
                if (l3 > (l2 = ((NumericValue)((Int64Value)groundedValue)).longValue())) {
                    object = Literal.makeEmptySequence();
                } else if (l3 == l2) {
                    object = Literal.makeLiteral(Int64Value.makeIntegerValue(l3), this);
                } else {
                    if (l2 - l3 > Integer.MAX_VALUE) {
                        throw new XPathException("Maximum length of sequence in Saxon is 2147483647", "XPDY0130");
                    }
                    object = Literal.makeLiteral(new IntegerRange(l3, l2), this);
                }
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.DECIMAL;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        IntegerValue[] integerValueArray = this.getLhsExpression().getIntegerBounds();
        IntegerValue[] integerValueArray2 = this.getLhsExpression().getIntegerBounds();
        if (integerValueArray == null || integerValueArray2 == null) {
            return null;
        }
        return new IntegerValue[]{integerValueArray[0], integerValueArray2[1]};
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new RangeExpression(this.getLhsExpression().copy((RebindingMap)object), this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public String getExpressionName() {
        return "range";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("to", this);
        this.getLhsExpression().export(expressionPresenter);
        this.getRhsExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        IntegerValue integerValue = (IntegerValue)this.getLhsExpression().evaluateItem((XPathContext)object);
        object = (IntegerValue)this.getRhsExpression().evaluateItem((XPathContext)object);
        return RangeIterator.makeRangeIterator(integerValue, (IntegerValue)object);
    }
}

