/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BigRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

public class RangeIterator
implements LastPositionFinder,
AtomicIterator,
GroundedIterator<AtomicValue>,
LookaheadIterator<AtomicValue>,
ReversibleIterator<AtomicValue> {
    private long a;
    private long b;
    private long c;

    public static SequenceIterator<AtomicValue> makeRangeIterator(IntegerValue integerValue, IntegerValue integerValue2) {
        if (integerValue == null || integerValue2 == null) {
            return EmptyIterator.OfAtomic.THE_INSTANCE;
        }
        if (integerValue.compareTo(integerValue2) > 0) {
            return EmptyIterator.OfAtomic.THE_INSTANCE;
        }
        if (integerValue instanceof BigIntegerValue || integerValue2 instanceof BigIntegerValue) {
            return new BigRangeIterator(integerValue.asBigInteger(), integerValue2.asBigInteger());
        }
        long l2 = integerValue.longValue();
        long l3 = integerValue2.longValue();
        if (l3 - l2 > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        return new RangeIterator(l2, l3);
    }

    public RangeIterator(long l2, long l3) {
        this.a = l2;
        this.b = l2 - 1L;
        this.c = l3;
    }

    @Override
    public boolean hasNext() {
        return this.b < this.c;
    }

    @Override
    public IntegerValue next() {
        if (++this.b > this.c) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.b);
    }

    @Override
    public int getLength() {
        return (int)(this.c - this.a + 1L);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public SequenceIterator<AtomicValue> getReverseIterator() {
        try {
            return new ReverseRangeIterator(this.c, this.a);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    @Override
    public GroundedValue<AtomicValue> materialize() {
        return new IntegerRange(this.a, this.c);
    }

    @Override
    public GroundedValue<AtomicValue> getResidue() {
        return new IntegerRange(this.b, this.c);
    }
}

