/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class ReverseRangeIterator
implements LastPositionFinder,
AtomicIterator,
LookaheadIterator<AtomicValue>,
ReversibleIterator<AtomicValue> {
    private long a;
    private long b;
    private long c;

    public ReverseRangeIterator(long l2, long l3) {
        if (l2 - l3 > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        this.a = l2;
        this.b = l2 + 1L;
        this.c = l3;
    }

    @Override
    public boolean hasNext() {
        return this.b > this.c;
    }

    @Override
    public IntegerValue next() {
        if (--this.b < this.c) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.b);
    }

    @Override
    public int getLength() {
        return (int)(this.a - this.c + 1L);
    }

    @Override
    public int getProperties() {
        return 6;
    }

    public AtomicIterator getReverseIterator() {
        return new RangeIterator(this.c, this.a);
    }
}

