/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class RootExpression
extends Expression {
    private boolean a = true;

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if (contextItemStaticInfo == null || contextItemStaticInfo.getItemType() == null || contextItemStaticInfo.getItemType().equals(ErrorType.getInstance())) {
            object = new XPathException(this.noContextMessage() + ": the context item is absent");
            ((XPathException)object).setErrorCode("XPDY0002");
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        this.a = contextItemStaticInfo.isPossiblyAbsent();
        if (((TypeHierarchy)(object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())).isSubType(contextItemStaticInfo.getItemType(), NodeKindTest.DOCUMENT)) {
            object = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            ((ContextItemExpression)object).setStaticInfo(contextItemStaticInfo);
            return object;
        }
        int n2 = ((TypeHierarchy)object).relationship(contextItemStaticInfo.getItemType(), AnyNodeTest.getInstance());
        if (n2 == 4) {
            XPathException xPathException = new XPathException(this.noContextMessage() + ": the context item is not a node");
            xPathException.setErrorCode("XPTY0020");
            xPathException.setIsTypeError(true);
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return ((Expression)this).typeCheck(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public int computeSpecialProperties() {
        return 25362432;
    }

    public boolean isContextPossiblyUndefined() {
        return this.a;
    }

    protected String noContextMessage() {
        return "Leading '/' selects nothing";
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof RootExpression;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.DOCUMENT;
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.DOCUMENT;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public int computeHashCode() {
        return "RootExpression".hashCode();
    }

    public NodeInfo getNode(XPathContext xPathContext) {
        NodeInfo nodeInfo = xPathContext.getContextItem();
        if (nodeInfo == null) {
            this.dynamicError("Finding root of tree: the context item is absent", "XPDY0002", xPathContext);
        }
        if (nodeInfo instanceof NodeInfo) {
            if ((nodeInfo = ((NodeInfo)nodeInfo).getRoot()).getNodeKind() != 9) {
                this.dynamicError("The root of the tree containing the context item is not a document node", "XPDY0050", xPathContext);
            }
            return nodeInfo;
        }
        this.typeError("Finding root of tree: the context item is not a node", "XPTY0020", xPathContext);
        return null;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 16;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new RootExpression();
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        return new NodeTestPattern(NodeKindTest.DOCUMENT);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet object) {
        if (object == null) {
            object = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            object = new PathMap.PathMapNodeSet(pathMap.makeNewRoot((Expression)object));
        }
        return ((PathMap.PathMapNodeSet)object).createArc((byte)1, NodeKindTest.DOCUMENT);
    }

    @Override
    public String toString() {
        return "(/)";
    }

    @Override
    public String getExpressionName() {
        return "root";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("root", this);
        expressionPresenter.endElement();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return SingletonIterator.makeIterator(this.getNode(xPathContext));
    }

    public NodeInfo evaluateItem(XPathContext xPathContext) {
        return this.getNode(xPathContext);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.getNode(xPathContext) != null;
    }

    @Override
    public String getStreamerName() {
        return "RootExpression";
    }
}

